/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionRule;
import org.biopax.paxtools.io.sif.InteractionSet;
import org.biopax.paxtools.io.sif.MaximumInteractionThresholdExceedException;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.io.sif.level2.AffectsRule;
import org.biopax.paxtools.io.sif.level2.ComponentRule;
import org.biopax.paxtools.io.sif.level2.ControlRule;
import org.biopax.paxtools.io.sif.level3.ConsecutiveCatalysisRule;
import org.biopax.paxtools.io.sif.level3.ControlsTogetherRule;
import org.biopax.paxtools.io.sif.level3.ExpressionRule;
import org.biopax.paxtools.io.sif.level3.Group;
import org.biopax.paxtools.io.sif.level3.InteractionSetL3;
import org.biopax.paxtools.io.sif.level3.ParticipatesRule;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.complex;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public class SimpleInteractionConverter {
    private final InteractionRule[] rules;
    private final Log log = LogFactory.getLog(SimpleInteractionConverter.class);
    private final Map options;
    public static final String REDUCE_COMPLEXES = "REDUCE_COMPLEXES";
    public static final String REDUCE_GENERICS = "REDUCE_GENERICS";
    private Set<String> blackList;

    public SimpleInteractionConverter(InteractionRule ... rules) {
        this(new HashMap(), rules);
    }

    public SimpleInteractionConverter(Map options, InteractionRule ... rules) {
        this(options, (Set<String>)null, rules);
    }

    public SimpleInteractionConverter(Map options, Set<String> blackList, InteractionRule ... rules) {
        this.blackList = blackList;
        this.rules = rules;
        this.options = options;
        for (InteractionRule rule : rules) {
            rule.initOptions(options);
        }
    }

    public Set<SimpleInteraction> inferInteractions(Model model) {
        switch (model.getLevel()) {
            case L1: 
            case L2: {
                return this.inferL2(model);
            }
            case L3: {
                return this.inferL3(model);
            }
        }
        throw new IllegalBioPAXArgumentException("Unknown BioPAX Level");
    }

    private Set<SimpleInteraction> inferL3(Model model) {
        InteractionSetL3 interactions = new InteractionSetL3(model);
        Set bioPAXElements = model.getObjects(PhysicalEntity.class);
        for (PhysicalEntity er : bioPAXElements) {
            for (InteractionRule rule : this.rules) {
                this.tryInferringRule(model, interactions, (BioPAXElement)er, rule);
            }
        }
        interactions.convertGroupsToInteractions();
        if (this.options.containsKey(REDUCE_COMPLEXES)) {
            System.out.println("reducing groups");
            InteractionSetL3 reduced = new InteractionSetL3(model);
            Iterator iterator = interactions.iterator();
            while (iterator.hasNext()) {
                SimpleInteraction interaction2 = (SimpleInteraction)iterator.next();
                this.reduceL3Groups(interaction2, (Set<SimpleInteraction>)((Object)reduced));
            }
            interactions = reduced;
        }
        if (this.blackList != null) {
            this.removeInteractionsWithBlackListMolecules((Set<SimpleInteraction>)((Object)interactions), this.blackList);
        }
        return interactions;
    }

    private void tryInferringRule(Model model, InteractionSet interactions, BioPAXElement bpe, InteractionRule rule) {
        try {
            rule.inferInteractions(interactions, bpe, model);
        }
        catch (MaximumInteractionThresholdExceedException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error((Object)("Exception while applying rule :" + this.getClass().getSimpleName() + "to the element: " + bpe.getRDFId()), (Throwable)e);
        }
    }

    private void reduceL3Groups(SimpleInteraction int2reduce, Set<SimpleInteraction> reducedInts) {
        if (int2reduce.getType() != BinaryInteractionType.COMPONENT_OF) {
            HashSet<EntityReference> sourceSet = new HashSet<EntityReference>();
            HashSet<EntityReference> targetSet = new HashSet<EntityReference>();
            SimpleInteractionConverter.reduceL3Groups(int2reduce.getSource(), sourceSet);
            SimpleInteractionConverter.reduceL3Groups(int2reduce.getTarget(), targetSet);
            for (EntityReference source : sourceSet) {
                for (EntityReference target : targetSet) {
                    SimpleInteraction interaction2 = new SimpleInteraction((BioPAXElement)source, (BioPAXElement)target, int2reduce.getType());
                    interaction2.getMediators().addAll(int2reduce.getMediators());
                    reducedInts.add(interaction2);
                }
            }
        }
    }

    private static void reduceL3Groups(BioPAXElement bpe, Set<EntityReference> reduced) {
        if (bpe instanceof Group) {
            reduced.addAll(((Group)bpe).getAllSimpleMembers());
        } else {
            reduced.add((EntityReference)bpe);
        }
    }

    private Set<SimpleInteraction> inferL2(Model model) {
        InteractionSet interactions = new InteractionSet();
        Set bioPAXElements = model.getObjects(physicalEntity.class);
        for (physicalEntity pe : bioPAXElements) {
            for (InteractionRule rule : this.rules) {
                this.tryInferringRule(model, interactions, (BioPAXElement)pe, rule);
            }
        }
        if (this.options.containsKey(REDUCE_COMPLEXES)) {
            InteractionSet reduced = new InteractionSet();
            Iterator iterator = interactions.iterator();
            while (iterator.hasNext()) {
                SimpleInteraction si = (SimpleInteraction)iterator.next();
                this.reduceL2Complexes(si, (Set<SimpleInteraction>)((Object)reduced));
            }
            interactions = reduced;
        }
        this.log.info((Object)(interactions.size() + " interactions inferred"));
        return interactions;
    }

    private void reduceL2Complexes(SimpleInteraction int2reduce, Set<SimpleInteraction> reducedInts) {
        if (int2reduce.getType() != BinaryInteractionType.COMPONENT_OF) {
            HashSet<physicalEntity> sourceSet = new HashSet<physicalEntity>();
            HashSet<physicalEntity> targetSet = new HashSet<physicalEntity>();
            SimpleInteractionConverter.recursivelyReduceL2Complexes(int2reduce.getSource(), sourceSet);
            SimpleInteractionConverter.recursivelyReduceL2Complexes(int2reduce.getTarget(), targetSet);
            for (physicalEntity source : sourceSet) {
                for (physicalEntity target : targetSet) {
                    SimpleInteraction interaction2 = new SimpleInteraction((BioPAXElement)source, (BioPAXElement)target, int2reduce.getType());
                    interaction2.getMediators().addAll(int2reduce.getMediators());
                    reducedInts.add(interaction2);
                }
            }
        }
    }

    private static void recursivelyReduceL2Complexes(BioPAXElement bpe, Set<physicalEntity> reduced) {
        if (bpe instanceof physicalEntityParticipant) {
            SimpleInteractionConverter.recursivelyReduceL2Complexes((BioPAXElement)((physicalEntityParticipant)bpe).getPHYSICAL_ENTITY(), reduced);
        } else if (bpe instanceof complex) {
            for (physicalEntityParticipant pep : ((complex)bpe).getCOMPONENTS()) {
                physicalEntity pe = pep.getPHYSICAL_ENTITY();
                SimpleInteractionConverter.recursivelyReduceL2Complexes((BioPAXElement)pe, reduced);
            }
        } else if (bpe instanceof physicalEntity) {
            reduced.add((physicalEntity)bpe);
        }
    }

    protected void removeInteractionsWithBlackListMolecules(Set<SimpleInteraction> interactions, Set<String> blackList) {
        Iterator<SimpleInteraction> iter = interactions.iterator();
        while (iter.hasNext()) {
            SimpleInteraction inter = iter.next();
            if (!blackList.contains(inter.getSource().getRDFId()) && !blackList.contains(inter.getTarget().getRDFId()) && !this.intersects(blackList, inter.getMediators())) continue;
            iter.remove();
        }
    }

    private boolean intersects(Set<String> ids, Set<BioPAXElement> mediators) {
        for (BioPAXElement mediator : mediators) {
            if (!ids.contains(mediator.getRDFId())) continue;
            return true;
        }
        return false;
    }

    public void writeInteractionsInSIF(Model model, OutputStream out) throws IOException {
        Set<SimpleInteraction> interactions = this.inferInteractions(model);
        OutputStreamWriter writer = new OutputStreamWriter(out);
        for (SimpleInteraction simpleInteraction : interactions) {
            writer.write(simpleInteraction.toString() + "\n");
        }
        ((Writer)writer).close();
    }

    public void writeInteractionsInSIFNX(Model model, OutputStream edgeStream, OutputStream nodeStream, List<String> interactorPropertyPaths, List<String> mediatorPropertyPaths, boolean writeEntityTypes) throws IOException {
        Set<String> values;
        Set<SimpleInteraction> interactions = this.inferInteractions(model);
        HashSet<BioPAXElement> entities = new HashSet<BioPAXElement>();
        ArrayList<PathAccessor> interactorAccessors = null;
        ArrayList<PathAccessor> mediatorAccessors = null;
        if (interactorPropertyPaths != null) {
            interactorAccessors = new ArrayList<PathAccessor>(interactorPropertyPaths.size());
            for (String string : interactorPropertyPaths) {
                interactorAccessors.add(new PathAccessor(string, model.getLevel()));
            }
        }
        if (mediatorPropertyPaths != null) {
            mediatorAccessors = new ArrayList<PathAccessor>(mediatorPropertyPaths.size());
            for (String string : mediatorPropertyPaths) {
                mediatorAccessors.add(new PathAccessor(string, model.getLevel()));
            }
        }
        TreeSet<String> lines = new TreeSet<String>();
        for (SimpleInteraction si : interactions) {
            StringBuilder sb = new StringBuilder(si.toString());
            entities.add(si.getSource());
            entities.add(si.getTarget());
            if (mediatorAccessors != null) {
                for (PathAccessor mediatorAccessor : mediatorAccessors) {
                    values = new HashSet<String>();
                    for (BioPAXElement mediator : si.getMediators()) {
                        if (!mediatorAccessor.applies(mediator)) continue;
                        values.add(this.valuesToString(mediatorAccessor.getValueFromBean(mediator)));
                    }
                    sb.append("\t").append(values.isEmpty() ? "not applicable" : this.valuesToString(values));
                }
            }
            lines.add(sb.toString());
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(edgeStream);
        outputStreamWriter.write(StringUtils.join(lines, (String)"\n"));
        ((Writer)outputStreamWriter).flush();
        OutputStreamWriter outputStreamWriter2 = new OutputStreamWriter(nodeStream);
        for (BioPAXElement entity2 : entities) {
            if (entity2 == null) continue;
            outputStreamWriter2.write(entity2.getRDFId());
            if (writeEntityTypes) {
                outputStreamWriter2.write("\t" + this.getEntityTypeString(entity2));
            }
            if (interactorAccessors != null) {
                for (PathAccessor accessor : interactorAccessors) {
                    outputStreamWriter2.write("\t");
                    if (accessor == null || !accessor.applies(entity2)) {
                        outputStreamWriter2.write("(not applicable)");
                        continue;
                    }
                    if (accessor.isUnknown((Object)entity2)) {
                        outputStreamWriter2.write("(not specified)");
                        continue;
                    }
                    values = accessor.getValueFromBean(entity2);
                    outputStreamWriter2.write(this.valuesToString(values));
                }
            }
            outputStreamWriter2.write("\n");
        }
        ((Writer)outputStreamWriter2).close();
    }

    private String getEntityTypeString(BioPAXElement entity2) {
        if (entity2 instanceof Group) {
            return ((Group)entity2).groupTypeToString();
        }
        return entity2.getModelInterface().getSimpleName();
    }

    private String valuesToString(Set values) {
        StringBuilder bldr = new StringBuilder();
        for (Object value : values) {
            bldr.append(value).append(";");
        }
        if (bldr.length() > 0) {
            bldr.deleteCharAt(bldr.length() - 1);
        }
        return bldr.toString();
    }

    public static List<InteractionRule> getRules(BioPAXLevel level) {
        ArrayList<InteractionRule> list = new ArrayList<InteractionRule>(5);
        if (level == BioPAXLevel.L2) {
            list.add(new ComponentRule());
            list.add(new org.biopax.paxtools.io.sif.level2.ConsecutiveCatalysisRule());
            list.add(new ControlRule());
            list.add(new org.biopax.paxtools.io.sif.level2.ControlsTogetherRule());
            list.add(new org.biopax.paxtools.io.sif.level2.ParticipatesRule());
            list.add(new AffectsRule());
        } else if (level == BioPAXLevel.L3) {
            list.add(new org.biopax.paxtools.io.sif.level3.ComponentRule());
            list.add(new ConsecutiveCatalysisRule());
            list.add(new org.biopax.paxtools.io.sif.level3.ControlRule());
            list.add(new ControlsTogetherRule());
            list.add(new ParticipatesRule());
            list.add(new ExpressionRule());
        }
        return list;
    }
}

