/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level2;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionSet;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.io.sif.level2.InteractionRuleL2Adaptor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.Direction;
import org.biopax.paxtools.model.level2.SpontaneousType;
import org.biopax.paxtools.model.level2.catalysis;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level2.interaction;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.process;
import org.biopax.paxtools.util.ClassFilterSet;

public class ConsecutiveCatalysisRule
extends InteractionRuleL2Adaptor {
    private static List<BinaryInteractionType> binaryInteractionTypes = Arrays.asList(BinaryInteractionType.SEQUENTIAL_CATALYSIS);

    @Override
    public void inferInteractionsFromPE(InteractionSet interactionSet, physicalEntity pe, Model model) {
        Set catalyses = pe.getAllInteractions(catalysis.class);
        for (catalysis aCatalysis : catalyses) {
            this.processCatalysis(interactionSet, pe, aCatalysis);
        }
    }

    private void processCatalysis(InteractionSet interactionSet, physicalEntity pe, catalysis aCatalysis) {
        SpontaneousType catalysisDirection = this.mapDirectionToSpontaneous(aCatalysis.getDIRECTION());
        Set controlled = aCatalysis.getCONTROLLED();
        for (process process2 : controlled) {
            conversion aConversion = (conversion)process2;
            SpontaneousType direction = this.findConsensusDirection(catalysisDirection, aConversion.getSPONTANEOUS());
            assert (direction != null);
            this.createInteractions(aConversion, direction, pe, aCatalysis, interactionSet);
        }
    }

    private SpontaneousType findConsensusDirection(SpontaneousType direction1, SpontaneousType direction2) {
        boolean first = this.isReversible(direction1);
        boolean second = this.isReversible(direction2);
        Object consensus = first ? (second ? SpontaneousType.NOT_SPONTANEOUS : direction2) : (second ? direction1 : (direction1.equals((Object)direction2) ? direction1 : null));
        return consensus;
    }

    private boolean isReversible(SpontaneousType direction1) {
        return direction1 == null || direction1.equals((Object)SpontaneousType.NOT_SPONTANEOUS);
    }

    private void createInteractions(conversion centerConversion, SpontaneousType direction, physicalEntity pe, catalysis aCatalysis, InteractionSet interactionSet) {
        Set<physicalEntityParticipant> peps = this.getCompatiblePEPs(direction, centerConversion);
        Set<conversion> conversions = this.getCompatibleConversions(peps, direction);
        for (conversion neighbor : conversions) {
            this.findAndAddCatalysts(neighbor, direction, pe, aCatalysis, interactionSet);
        }
    }

    private Set<physicalEntityParticipant> getCompatiblePEPs(SpontaneousType direction, conversion aConversion) {
        switch (direction) {
            case L_R: {
                return aConversion.getRIGHT();
            }
            case R_L: {
                return aConversion.getLEFT();
            }
        }
        return this.mergedSet(aConversion);
    }

    private HashSet<physicalEntityParticipant> mergedSet(conversion aConversion) {
        HashSet<physicalEntityParticipant> hashSet = new HashSet<physicalEntityParticipant>();
        hashSet.addAll(aConversion.getLEFT());
        hashSet.addAll(aConversion.getRIGHT());
        return hashSet;
    }

    private Set<conversion> getCompatibleConversions(Set<physicalEntityParticipant> peps, SpontaneousType direction) {
        HashSet<conversion> compatibleConversions = new HashSet<conversion>();
        for (physicalEntityParticipant pep : peps) {
            Set npeps = pep.getPHYSICAL_ENTITY().isPHYSICAL_ENTITYof();
            for (physicalEntityParticipant npep : npeps) {
                conversion aConversion;
                if (pep.equals(npep) || !pep.isInEquivalentState(npep) || npep.isPARTICIPANTSof().isEmpty()) continue;
                assert (npep.isPARTICIPANTSof().size() == 1);
                interaction anI = (interaction)npep.isPARTICIPANTSof().iterator().next();
                if (!(anI instanceof conversion) || this.findConsensusDirection(direction, (aConversion = (conversion)anI).getSPONTANEOUS()) == null || !this.participantIsAtACompatibleSide(direction, npep, aConversion)) continue;
                compatibleConversions.add(aConversion);
            }
        }
        return compatibleConversions;
    }

    private boolean participantIsAtACompatibleSide(SpontaneousType direction, physicalEntityParticipant npep, conversion aConversion) {
        switch (direction) {
            case L_R: {
                return aConversion.getLEFT().contains(npep);
            }
            case R_L: {
                return aConversion.getRIGHT().contains(npep);
            }
        }
        return aConversion.getRIGHT().contains(npep) || aConversion.getLEFT().contains(npep);
    }

    private void findAndAddCatalysts(conversion aConversion, SpontaneousType direction, physicalEntity pe, catalysis aCatalysis, InteractionSet interactionSet) {
        Set controls = aConversion.isCONTROLLEDOf();
        for (catalysis consequentCatalysis : new ClassFilterSet(controls, catalysis.class)) {
            if (this.findConsensusDirection(direction, this.mapDirectionToSpontaneous(consequentCatalysis.getDIRECTION())) == null) continue;
            for (physicalEntityParticipant pepi : consequentCatalysis.getCONTROLLER()) {
                SimpleInteraction si = new SimpleInteraction((BioPAXElement)pe, (BioPAXElement)pepi.getPHYSICAL_ENTITY(), BinaryInteractionType.SEQUENTIAL_CATALYSIS);
                si.addMediator((BioPAXElement)aCatalysis);
                si.addMediator((BioPAXElement)consequentCatalysis);
                interactionSet.add(si);
            }
        }
    }

    private SpontaneousType mapDirectionToSpontaneous(Direction direction) {
        if (direction != null) {
            switch (direction) {
                case IRREVERSIBLE_LEFT_TO_RIGHT: 
                case PHYSIOL_LEFT_TO_RIGHT: {
                    return SpontaneousType.L_R;
                }
                case IRREVERSIBLE_RIGHT_TO_LEFT: 
                case PHYSIOL_RIGHT_TO_LEFT: {
                    return SpontaneousType.R_L;
                }
            }
        }
        return null;
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return binaryInteractionTypes;
    }
}

