/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionSet;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.io.sif.level2.InteractionRuleL2Adaptor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.complex;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.process;

public class ControlRule
extends InteractionRuleL2Adaptor {
    private static List<BinaryInteractionType> binaryInteractionTypes = Arrays.asList(BinaryInteractionType.METABOLIC_CATALYSIS, BinaryInteractionType.STATE_CHANGE);
    private boolean mineMetabolicChange;
    private boolean mineStateChange;

    @Override
    public void initOptionsNotNull(Map options) {
        this.mineStateChange = !options.containsKey((Object)BinaryInteractionType.STATE_CHANGE) || options.get((Object)BinaryInteractionType.STATE_CHANGE).equals(Boolean.TRUE);
        this.mineMetabolicChange = !options.containsKey((Object)BinaryInteractionType.METABOLIC_CATALYSIS) || options.get((Object)BinaryInteractionType.METABOLIC_CATALYSIS).equals(Boolean.TRUE);
    }

    @Override
    public void inferInteractionsFromPE(InteractionSet interactionSet, physicalEntity A, Model model) {
        for (control cont : A.getAllInteractions(control.class)) {
            for (conversion conv : this.getAffectedConversions(cont, null)) {
                Set<physicalEntity> presenceSet = this.collectEntities(conv.getLEFT(), null);
                this.collectEntities(conv.getRIGHT(), presenceSet);
                List<physicalEntity> left = this.collectSimpleEntities(conv.getLEFT());
                List<physicalEntity> right = this.collectSimpleEntities(conv.getRIGHT());
                ArrayList<physicalEntity> bothsided = new ArrayList<physicalEntity>();
                for (physicalEntity B : left) {
                    if (!right.contains(B)) continue;
                    bothsided.add(B);
                }
                for (physicalEntity B : presenceSet) {
                    if (!this.entityHasAChange(B, conv)) continue;
                    if (B instanceof complex || bothsided.contains(B)) {
                        if (!this.mineStateChange) continue;
                        SimpleInteraction sc = new SimpleInteraction((BioPAXElement)A, (BioPAXElement)B, BinaryInteractionType.STATE_CHANGE);
                        sc.addMediator((BioPAXElement)cont);
                        sc.addMediator((BioPAXElement)conv);
                        interactionSet.add(sc);
                        continue;
                    }
                    if (!this.mineMetabolicChange) continue;
                    SimpleInteraction mc = new SimpleInteraction((BioPAXElement)A, (BioPAXElement)B, BinaryInteractionType.METABOLIC_CATALYSIS);
                    mc.addMediator((BioPAXElement)cont);
                    mc.addMediator((BioPAXElement)conv);
                    interactionSet.add(mc);
                }
            }
        }
    }

    private List<conversion> getAffectedConversions(control cont, List<conversion> convList) {
        if (convList == null) {
            convList = new ArrayList<conversion>();
        }
        for (process prcss : cont.getCONTROLLED()) {
            if (prcss instanceof conversion) {
                convList.add((conversion)prcss);
                continue;
            }
            if (!(prcss instanceof control)) continue;
            this.getAffectedConversions((control)prcss, convList);
        }
        return convList;
    }

    private Set<physicalEntity> collectEntities(Set<physicalEntityParticipant> partics, Set<physicalEntity> peSet) {
        if (peSet == null) {
            peSet = new HashSet<physicalEntity>();
        }
        for (physicalEntityParticipant partic : partics) {
            peSet.add(partic.getPHYSICAL_ENTITY());
        }
        return peSet;
    }

    private List<physicalEntity> collectSimpleEntities(Set<physicalEntityParticipant> partics) {
        ArrayList<physicalEntity> peList = new ArrayList<physicalEntity>();
        for (physicalEntityParticipant partic : partics) {
            physicalEntity pe = partic.getPHYSICAL_ENTITY();
            if (pe instanceof complex) {
                this.collectSimpleMembersOfComplex(peList, (complex)pe);
                continue;
            }
            peList.add(pe);
        }
        return peList;
    }

    private void collectSimpleMembersOfComplex(List<physicalEntity> list, complex comp) {
        for (physicalEntityParticipant pep : comp.getCOMPONENTS()) {
            physicalEntity pe = pep.getPHYSICAL_ENTITY();
            if (pe instanceof complex) {
                this.collectSimpleMembersOfComplex(list, (complex)pe);
                continue;
            }
            list.add(pe);
        }
    }

    private boolean entityHasAChange(physicalEntity entity2, conversion conv) {
        HashSet<StateWrapper> leftonly = new HashSet<StateWrapper>();
        HashSet<StateWrapper> rightonly = new HashSet<StateWrapper>();
        HashSet<StateWrapper> both = new HashSet<StateWrapper>();
        for (physicalEntityParticipant pep : conv.getLEFT()) {
            if (pep.getPHYSICAL_ENTITY() != entity2) continue;
            leftonly.add(new StateWrapper(pep));
        }
        for (physicalEntityParticipant pep : conv.getRIGHT()) {
            if (pep.getPHYSICAL_ENTITY() != entity2) continue;
            StateWrapper sw = new StateWrapper(pep);
            if (leftonly.contains(sw)) {
                leftonly.remove(sw);
                both.add(sw);
                continue;
            }
            if (both.contains(sw)) continue;
            rightonly.add(sw);
        }
        return !leftonly.isEmpty() || !rightonly.isEmpty();
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return binaryInteractionTypes;
    }

    private class StateWrapper {
        final physicalEntityParticipant pep;

        private StateWrapper(physicalEntityParticipant pep) {
            this.pep = pep;
        }

        public int hashCode() {
            return this.pep.stateCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof StateWrapper) {
                StateWrapper sw = (StateWrapper)obj;
                return this.pep.isInEquivalentState(sw.pep);
            }
            return false;
        }
    }
}

