/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level2;

import java.util.Arrays;
import java.util.List;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionSet;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.io.sif.level2.InteractionRuleL2Adaptor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.process;

public class ControlsTogetherRule
extends InteractionRuleL2Adaptor {
    private static List<BinaryInteractionType> binaryInteractionTypes = Arrays.asList(BinaryInteractionType.CO_CONTROL);

    @Override
    public void inferInteractionsFromPE(InteractionSet interactionSet, physicalEntity A, Model model) {
        for (control ctrl : A.getAllInteractions(control.class)) {
            this.iterateControllers(ctrl, A, interactionSet);
            this.proceedUpwards(ctrl, A, interactionSet);
            this.proceedDownwards(ctrl, A, interactionSet);
        }
    }

    private void proceedDownwards(control ctrl, physicalEntity A, InteractionSet interactionSet) {
        for (process prcss : ctrl.getCONTROLLED()) {
            if (prcss instanceof control) {
                this.searchDownwards((control)prcss, A, interactionSet);
            }
            for (control cnt : prcss.isCONTROLLEDOf()) {
                if (cnt == ctrl) continue;
                this.searchUpwards(cnt, A, interactionSet);
            }
        }
    }

    private void searchDownwards(control ctrl, physicalEntity A, InteractionSet interactionSet) {
        this.iterateControllers(ctrl, A, interactionSet);
        this.proceedDownwards(ctrl, A, interactionSet);
    }

    private void searchUpwards(control ctrl, physicalEntity A, InteractionSet interactionSet) {
        this.iterateControllers(ctrl, A, interactionSet);
        this.proceedUpwards(ctrl, A, interactionSet);
    }

    private void iterateControllers(control ctrl, physicalEntity A, InteractionSet interactionSet) {
        for (physicalEntityParticipant pep : ctrl.getCONTROLLER()) {
            physicalEntity B = pep.getPHYSICAL_ENTITY();
            if (B == A) continue;
            interactionSet.add(new SimpleInteraction((BioPAXElement)A, (BioPAXElement)B, BinaryInteractionType.CO_CONTROL));
        }
    }

    private void proceedUpwards(control ctrl, physicalEntity A, InteractionSet interactionSet) {
        for (control cnt : ctrl.isCONTROLLEDOf()) {
            this.searchUpwards(cnt, A, interactionSet);
        }
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return binaryInteractionTypes;
    }
}

