/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.level3.InteractionRuleL3Adaptor;
import org.biopax.paxtools.io.sif.level3.InteractionSetL3;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.CatalysisDirectionType;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public class ConsecutiveCatalysisRule
extends InteractionRuleL3Adaptor {
    private static List<BinaryInteractionType> binaryInteractionTypes = Arrays.asList(BinaryInteractionType.SEQUENTIAL_CATALYSIS);

    @Override
    public void inferInteractionsFromPE(InteractionSetL3 interactionSet, PhysicalEntity pe, Model model) {
        for (Interaction inter : pe.getParticipantOf()) {
            if (!(inter instanceof Catalysis)) continue;
            BioPAXElement bpe = interactionSet.getGroupMap().getEntityReferenceOrGroup((BioPAXElement)pe);
            this.processCatalysis(interactionSet, (Catalysis)inter, bpe);
        }
    }

    private void processCatalysis(InteractionSetL3 interactionSet, Catalysis aCatalysis, BioPAXElement bpe) {
        ConversionDirectionType catalysisDirection = this.mapDirectionToConversion(aCatalysis.getCatalysisDirection());
        Set controlled = aCatalysis.getControlled();
        for (Process process : controlled) {
            assert (process instanceof Conversion);
            Conversion aConversion = (Conversion)process;
            ConversionDirectionType dirA = this.findConsensusDirection(catalysisDirection, aConversion.getConversionDirection());
            assert (dirA != null);
            this.createInteractions(aConversion, dirA, aCatalysis, interactionSet, bpe);
        }
    }

    private ConversionDirectionType findConsensusDirection(ConversionDirectionType direction1, ConversionDirectionType direction2) {
        boolean first = this.isReversible(direction1);
        boolean second = this.isReversible(direction2);
        Object consensus = first ? (second ? ConversionDirectionType.REVERSIBLE : direction2) : (second ? direction1 : (direction1.equals((Object)direction2) ? direction1 : null));
        return consensus;
    }

    private boolean isReversible(ConversionDirectionType direction1) {
        return direction1 == null || direction1.equals((Object)ConversionDirectionType.REVERSIBLE);
    }

    private void createInteractions(Conversion centerConversion, ConversionDirectionType dirA, Catalysis aCatalysis, InteractionSetL3 interactionSet, BioPAXElement bpe) {
        Set<PhysicalEntity> pes = this.getOutputPEs(dirA, centerConversion);
        for (PhysicalEntity pe : pes) {
            for (Interaction inter : pe.getParticipantOf()) {
                Conversion nextConversion;
                if (!(inter instanceof Conversion) || centerConversion == (nextConversion = (Conversion)inter)) continue;
                Set controls = nextConversion.getControlledOf();
                for (Catalysis consequentCatalysis : new ClassFilterSet(controls, Catalysis.class)) {
                    ConversionDirectionType direction2 = this.mapDirectionToConversion(consequentCatalysis.getCatalysisDirection());
                    ConversionDirectionType dirB = this.findConsensusDirection(nextConversion.getConversionDirection(), direction2);
                    if (!this.commonSubstrateFollowsFlow(pe, nextConversion, dirB)) continue;
                    for (Controller controller : consequentCatalysis.getController()) {
                        if (!(controller instanceof PhysicalEntity)) continue;
                        this.createAndAdd(bpe, interactionSet.getGroupMap().getEntityReferenceOrGroup((BioPAXElement)controller), interactionSet, BinaryInteractionType.SEQUENTIAL_CATALYSIS, new BioPAXElement[]{aCatalysis, consequentCatalysis, pe});
                    }
                }
            }
        }
    }

    private boolean commonSubstrateFollowsFlow(PhysicalEntity pe, Conversion nextConversion, ConversionDirectionType dirB) {
        if (dirB == null) {
            return true;
        }
        switch (dirB) {
            case REVERSIBLE: {
                return true;
            }
            case LEFT_TO_RIGHT: {
                return nextConversion.getLeft().contains(pe);
            }
            case RIGHT_TO_LEFT: {
                return nextConversion.getRight().contains(pe);
            }
        }
        throw new IllegalBioPAXArgumentException();
    }

    private Set<PhysicalEntity> getOutputPEs(ConversionDirectionType direction, Conversion aConversion) {
        switch (direction) {
            case LEFT_TO_RIGHT: {
                return aConversion.getRight();
            }
            case RIGHT_TO_LEFT: {
                return aConversion.getLeft();
            }
        }
        return this.mergedSet(aConversion);
    }

    private HashSet<PhysicalEntity> mergedSet(Conversion aConversion) {
        HashSet<PhysicalEntity> hashSet = new HashSet<PhysicalEntity>();
        hashSet.addAll(aConversion.getLeft());
        hashSet.addAll(aConversion.getRight());
        return hashSet;
    }

    private ConversionDirectionType mapDirectionToConversion(CatalysisDirectionType direction) {
        if (direction != null) {
            switch (direction) {
                case LEFT_TO_RIGHT: {
                    return ConversionDirectionType.LEFT_TO_RIGHT;
                }
                case RIGHT_TO_LEFT: {
                    return ConversionDirectionType.RIGHT_TO_LEFT;
                }
            }
        }
        return null;
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return binaryInteractionTypes;
    }
}

