/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.io.sif.level3.Group;
import org.biopax.paxtools.io.sif.level3.GroupMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.util.AccessibleSet;

public class Grouper {
    private static final Log log = LogFactory.getLog(Grouper.class);
    Map<BioPAXElement, Group> element2GroupMap = new HashMap<BioPAXElement, Group>();
    AccessibleSet<Group> groups = new AccessibleSet();
    Map<BioPAXElement, Set<Group>> delegated = new HashMap<BioPAXElement, Set<Group>>();
    Set<EntityReference> ersToBeGrouped;
    Set<Complex> complexesToBeGrouped;

    public static GroupMap inferGroups(Model model) {
        ModelUtils.normalizeGenerics((Model)model);
        Grouper grouper = new Grouper();
        return new GroupMap(grouper.inferGroups(model, grouper));
    }

    private Map<BioPAXElement, Group> inferGroups(Model model, Grouper grouper) {
        this.ersToBeGrouped = new HashSet<EntityReference>(model.getObjects(EntityReference.class));
        this.complexesToBeGrouped = new HashSet<Complex>(model.getObjects(Complex.class));
        for (EntityReference er : this.ersToBeGrouped) {
            this.addIfNotNull((BioPAXElement)er, this.inferGroupFromER(er, model));
        }
        for (Complex complex : this.complexesToBeGrouped) {
            this.addIfNotNull((BioPAXElement)complex, this.inferGroupFromComplex(complex, model));
        }
        return this.element2GroupMap;
    }

    private void addIfNotNull(BioPAXElement element, Group group) {
        if (group != null) {
            Group equivalentGroup = (Group)((Object)this.groups.access((Object)group));
            if (equivalentGroup == null) {
                equivalentGroup = group;
                this.groups.add((Object)equivalentGroup);
            } else {
                equivalentGroup.sources.addAll(group.sources);
            }
            this.element2GroupMap.put(element, equivalentGroup);
        }
    }

    private Group inferGroupFromComplex(Complex complex, Model model) {
        Group group = new Group(true, (BioPAXElement)complex);
        Set PElvlMembers = complex.getMemberPhysicalEntity();
        if (PElvlMembers.isEmpty()) {
            for (PhysicalEntity component : complex.getComponent()) {
                if (component instanceof SimplePhysicalEntity) {
                    EntityReference er = (EntityReference)this.element2GroupMap.get(component);
                    if (er == null) {
                        er = ((SimplePhysicalEntity)component).getEntityReference();
                    }
                    if (er != null) {
                        group.addMember(er);
                        continue;
                    }
                    this.addOrDelegate((BioPAXElement)component, group);
                    continue;
                }
                if (!(component instanceof Complex)) continue;
                this.addOrDelegate((BioPAXElement)component, group);
            }
        } else if (!complex.getComponent().isEmpty()) {
            log.debug((Object)("Generic complex with both membership types (" + complex.getRDFId() + "). Skipping."));
        } else {
            group = new Group(false, (BioPAXElement)complex);
            group.genericClass = Complex.class;
            for (PhysicalEntity member : PElvlMembers) {
                if (member instanceof Complex) {
                    this.addOrDelegate((BioPAXElement)member, group);
                    continue;
                }
                log.debug((Object)("Non complex PE member for complex (" + member.getRDFId() + "->" + complex.getRDFId() + "). Skipping"));
            }
        }
        Set<Group> groups = this.delegated.get(complex);
        if (groups != null) {
            for (Group owner : groups) {
                owner.addSubgroup(group);
            }
        }
        ModelUtils.copySimplePointers((Model)model, (Named)complex, (Named)group);
        return group;
    }

    private void addOrDelegate(BioPAXElement member, Group owner) {
        Group subgroup = this.element2GroupMap.get(member);
        if (subgroup != null) {
            owner.addSubgroup(subgroup);
        } else {
            Set<Group> groups = this.delegated.get(member);
            if (groups == null) {
                groups = new HashSet<Group>();
                this.delegated.put(member, groups);
            }
            groups.add(owner);
        }
    }

    private Group inferGroupFromER(EntityReference element, Model model) {
        Group group = new Group(false, (BioPAXElement)element);
        for (EntityReference member : element.getMemberEntityReference()) {
            if (group.genericClass == null) {
                group.genericClass = member.getModelInterface();
            }
            group.addMember(member);
        }
        Set<Group> owners = this.delegated.get(element);
        if (owners != null) {
            for (Group owner : owners) {
                owner.addSubgroup(group);
            }
        }
        ModelUtils.copySimplePointers((Model)model, (Named)element, (Named)group);
        return group.isEmpty() ? null : group;
    }
}

