/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.level3.InteractionRuleL3Adaptor;
import org.biopax.paxtools.io.sif.level3.InteractionSetL3;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;

public class ParticipatesRule
extends InteractionRuleL3Adaptor {
    private final Log log = LogFactory.getLog(ParticipatesRule.class);
    private static final List<BinaryInteractionType> binaryInteractionTypes = Arrays.asList(BinaryInteractionType.INTERACTS_WITH, BinaryInteractionType.REACTS_WITH);
    private boolean skipConversions;
    private boolean skipInteractions;

    @Override
    public void initOptionsNotNull(Map options) {
        this.skipConversions = this.checkOption((Object)BinaryInteractionType.REACTS_WITH, Boolean.FALSE, options);
        this.skipInteractions = this.checkOption((Object)BinaryInteractionType.INTERACTS_WITH, Boolean.FALSE, options);
    }

    @Override
    public void inferInteractionsFromPE(InteractionSetL3 interactionSet, PhysicalEntity pe, Model model) {
        for (Interaction interaction : pe.getParticipantOf()) {
            BinaryInteractionType type = this.getType(interaction);
            for (Entity participant : interaction.getParticipant()) {
                this.processParticipant(interactionSet, participant, type, interaction);
            }
        }
    }

    private BinaryInteractionType getType(Interaction interaction) {
        if (interaction instanceof Conversion) {
            if (!this.skipConversions) {
                return BinaryInteractionType.REACTS_WITH;
            }
        } else {
            if (interaction instanceof Control) {
                return null;
            }
            if (!this.skipInteractions) {
                return BinaryInteractionType.INTERACTS_WITH;
            }
        }
        return null;
    }

    private void processParticipant(InteractionSetL3 interactionSet, Entity entity, BinaryInteractionType type, Interaction interaction) {
        if (entity instanceof PhysicalEntity) {
            BioPAXElement source = interactionSet.getGroupMap().getEntityReferenceOrGroup((BioPAXElement)entity);
            for (Entity participant : interaction.getParticipant()) {
                if (!(participant instanceof PhysicalEntity)) continue;
                BioPAXElement target = interactionSet.getGroupMap().getEntityReferenceOrGroup((BioPAXElement)participant);
                this.createAndAdd(source, target, interactionSet, type, new BioPAXElement[]{interaction});
            }
        }
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return binaryInteractionTypes;
    }
}

