/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token;

import com.clevercloud.biscuit.crypto.KeyDelegate;
import com.clevercloud.biscuit.crypto.KeyPair;
import com.clevercloud.biscuit.crypto.PublicKey;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.token.Authorizer;
import com.clevercloud.biscuit.token.UnverifiedBiscuit;
import com.clevercloud.biscuit.token.builder.Block;
import com.clevercloud.biscuit.token.format.SerializedBiscuit;
import com.clevercloud.biscuit.token.format.SignedBlock;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;

public class Biscuit
extends UnverifiedBiscuit {
    public static com.clevercloud.biscuit.token.builder.Biscuit builder(KeyPair root) {
        return new com.clevercloud.biscuit.token.builder.Biscuit(new SecureRandom(), root, Biscuit.default_symbol_table());
    }

    public static com.clevercloud.biscuit.token.builder.Biscuit builder(SecureRandom rng, KeyPair root) {
        return new com.clevercloud.biscuit.token.builder.Biscuit(rng, root, Biscuit.default_symbol_table());
    }

    public static com.clevercloud.biscuit.token.builder.Biscuit builder(SecureRandom rng, KeyPair root, Option<Integer> root_key_id, SymbolTable symbols) {
        return new com.clevercloud.biscuit.token.builder.Biscuit(rng, root, root_key_id, symbols);
    }

    public static com.clevercloud.biscuit.token.builder.Biscuit builder(SecureRandom rng, KeyPair root, SymbolTable symbols) {
        return new com.clevercloud.biscuit.token.builder.Biscuit(rng, root, symbols);
    }

    @Deprecated
    public static Biscuit make(SecureRandom rng, KeyPair root, SymbolTable symbols, com.clevercloud.biscuit.token.Block authority) throws Error.SymbolTableOverlap, Error.FormatError {
        return Biscuit.make(rng, root, (Option<Integer>)Option.none(), symbols, authority);
    }

    public static Biscuit make(SecureRandom rng, KeyPair root, Option<Integer> root_key_id, SymbolTable symbols, com.clevercloud.biscuit.token.Block authority) throws Error.SymbolTableOverlap, Error.FormatError {
        if (!Collections.disjoint(symbols.symbols, authority.symbols.symbols)) {
            throw new Error.SymbolTableOverlap();
        }
        symbols.symbols.addAll(authority.symbols.symbols);
        ArrayList<com.clevercloud.biscuit.token.Block> blocks = new ArrayList<com.clevercloud.biscuit.token.Block>();
        KeyPair next = new KeyPair(rng);
        Either<Error.FormatError, SerializedBiscuit> container = SerializedBiscuit.make(root, root_key_id, authority, next);
        if (container.isLeft()) {
            Error.FormatError e = (Error.FormatError)container.getLeft();
            throw e;
        }
        SerializedBiscuit s = (SerializedBiscuit)container.get();
        List<byte[]> revocation_ids = s.revocation_identifiers();
        Option c = Option.some((Object)s);
        return new Biscuit(authority, blocks, symbols, s, revocation_ids, root_key_id);
    }

    Biscuit(com.clevercloud.biscuit.token.Block authority, List<com.clevercloud.biscuit.token.Block> blocks, SymbolTable symbols, SerializedBiscuit serializedBiscuit, List<byte[]> revocation_ids) {
        super(authority, blocks, symbols, serializedBiscuit, revocation_ids);
    }

    Biscuit(com.clevercloud.biscuit.token.Block authority, List<com.clevercloud.biscuit.token.Block> blocks, SymbolTable symbols, SerializedBiscuit serializedBiscuit, List<byte[]> revocation_ids, Option<Integer> root_key_id) {
        super(authority, blocks, symbols, serializedBiscuit, revocation_ids, root_key_id);
    }

    @Deprecated
    public static Biscuit from_b64(String data, PublicKey root) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes(Base64.getUrlDecoder().decode(data), root);
    }

    public static Biscuit from_b64url(String data, PublicKey root) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes(Base64.getUrlDecoder().decode(data), root);
    }

    public static Biscuit from_b64url(String data, KeyDelegate delegate) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes(Base64.getUrlDecoder().decode(data), delegate);
    }

    public static Biscuit from_bytes(byte[] data, PublicKey root) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes_with_symbols(data, root, Biscuit.default_symbol_table());
    }

    public static Biscuit from_bytes(byte[] data, KeyDelegate delegate) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes_with_symbols(data, delegate, Biscuit.default_symbol_table());
    }

    public static Biscuit from_bytes_with_symbols(byte[] data, PublicKey root, SymbolTable symbols) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        SerializedBiscuit ser = SerializedBiscuit.from_bytes(data, root);
        return Biscuit.from_serialized_biscuit(ser, symbols);
    }

    public static Biscuit from_bytes_with_symbols(byte[] data, KeyDelegate delegate, SymbolTable symbols) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        SerializedBiscuit ser = SerializedBiscuit.from_bytes(data, delegate);
        return Biscuit.from_serialized_biscuit(ser, symbols);
    }

    @Deprecated
    static Biscuit from_serialize_biscuit(SerializedBiscuit ser, SymbolTable symbols) throws Error {
        Either<Error.FormatError, com.clevercloud.biscuit.token.Block> authRes = com.clevercloud.biscuit.token.Block.from_bytes(ser.authority.block);
        if (authRes.isLeft()) {
            Error e = (Error)authRes.getLeft();
            throw e;
        }
        com.clevercloud.biscuit.token.Block authority = (com.clevercloud.biscuit.token.Block)authRes.get();
        ArrayList<com.clevercloud.biscuit.token.Block> blocks = new ArrayList<com.clevercloud.biscuit.token.Block>();
        for (SignedBlock bdata : ser.blocks) {
            Either<Error.FormatError, com.clevercloud.biscuit.token.Block> blockRes = com.clevercloud.biscuit.token.Block.from_bytes(bdata.block);
            if (blockRes.isLeft()) {
                Error e = (Error)blockRes.getLeft();
                throw e;
            }
            blocks.add((com.clevercloud.biscuit.token.Block)blockRes.get());
        }
        for (String s : authority.symbols.symbols) {
            symbols.add(s);
        }
        for (com.clevercloud.biscuit.token.Block b : blocks) {
            for (String s : b.symbols.symbols) {
                symbols.add(s);
            }
        }
        List<byte[]> revocation_ids = ser.revocation_identifiers();
        return new Biscuit(authority, blocks, symbols, ser, revocation_ids);
    }

    static Biscuit from_serialized_biscuit(SerializedBiscuit ser, SymbolTable symbols) throws Error {
        Either<Error.FormatError, com.clevercloud.biscuit.token.Block> authRes = com.clevercloud.biscuit.token.Block.from_bytes(ser.authority.block);
        if (authRes.isLeft()) {
            Error e = (Error)authRes.getLeft();
            throw e;
        }
        com.clevercloud.biscuit.token.Block authority = (com.clevercloud.biscuit.token.Block)authRes.get();
        ArrayList<com.clevercloud.biscuit.token.Block> blocks = new ArrayList<com.clevercloud.biscuit.token.Block>();
        for (SignedBlock bdata : ser.blocks) {
            Either<Error.FormatError, com.clevercloud.biscuit.token.Block> blockRes = com.clevercloud.biscuit.token.Block.from_bytes(bdata.block);
            if (blockRes.isLeft()) {
                Error e = (Error)blockRes.getLeft();
                throw e;
            }
            blocks.add((com.clevercloud.biscuit.token.Block)blockRes.get());
        }
        for (String s : authority.symbols.symbols) {
            symbols.add(s);
        }
        for (com.clevercloud.biscuit.token.Block b : blocks) {
            for (String s : b.symbols.symbols) {
                symbols.add(s);
            }
        }
        List<byte[]> revocation_ids = ser.revocation_identifiers();
        return new Biscuit(authority, blocks, symbols, ser, revocation_ids);
    }

    public Authorizer authorizer() throws Error.FailedLogic {
        return Authorizer.make(this);
    }

    @Override
    public byte[] serialize() throws Error.FormatError.SerializationError {
        return this.serializedBiscuit.serialize();
    }

    @Deprecated
    public String serialize_b64() throws Error.FormatError.SerializationError {
        return Base64.getUrlEncoder().encodeToString(this.serialize());
    }

    @Override
    public String serialize_b64url() throws Error.FormatError.SerializationError {
        return Base64.getUrlEncoder().encodeToString(this.serialize());
    }

    @Override
    public Biscuit attenuate(Block block) throws Error {
        SecureRandom rng = new SecureRandom();
        KeyPair keypair = new KeyPair(rng);
        return this.attenuate(rng, keypair, block.build());
    }

    @Override
    public Biscuit attenuate(SecureRandom rng, KeyPair keypair, com.clevercloud.biscuit.token.Block block) throws Error {
        Biscuit copiedBiscuit = this.copy();
        if (!Collections.disjoint(copiedBiscuit.symbols.symbols, block.symbols.symbols)) {
            throw new Error.SymbolTableOverlap();
        }
        Either<Error.FormatError, SerializedBiscuit> containerRes = copiedBiscuit.serializedBiscuit.append(keypair, block);
        if (containerRes.isLeft()) {
            Error.FormatError error = (Error.FormatError)containerRes.getLeft();
            throw error;
        }
        SerializedBiscuit container = (SerializedBiscuit)containerRes.get();
        SymbolTable symbols = new SymbolTable(copiedBiscuit.symbols);
        for (String string : block.symbols.symbols) {
            symbols.add(string);
        }
        ArrayList<com.clevercloud.biscuit.token.Block> blocks = new ArrayList<com.clevercloud.biscuit.token.Block>();
        for (com.clevercloud.biscuit.token.Block b : copiedBiscuit.blocks) {
            blocks.add(b);
        }
        blocks.add(block);
        List<byte[]> list = container.revocation_identifiers();
        return new Biscuit(copiedBiscuit.authority, blocks, symbols, container, list);
    }

    @Override
    public String print() {
        StringBuilder s = new StringBuilder();
        s.append("Biscuit {\n\tsymbols: ");
        s.append(this.symbols.getAllSymbols());
        s.append("\n\tauthority: ");
        s.append(this.authority.print(this.symbols));
        s.append("\n\tblocks: [\n");
        for (com.clevercloud.biscuit.token.Block b : this.blocks) {
            s.append("\t\t");
            s.append(b.print(this.symbols));
            s.append("\n");
        }
        s.append("\t]\n}");
        return s.toString();
    }

    @Override
    public Biscuit copy() throws Error {
        return Biscuit.from_serialize_biscuit(this.serializedBiscuit, this.symbols);
    }
}

