/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.builder;

import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.error.FailedCheck;
import com.clevercloud.biscuit.token.builder.Expression;
import com.clevercloud.biscuit.token.builder.Predicate;
import com.clevercloud.biscuit.token.builder.Term;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Rule
implements Cloneable {
    Predicate head;
    List<Predicate> body;
    List<Expression> expressions;
    Option<Map<String, Option<Term>>> variables;

    public Rule(Predicate head, List<Predicate> body, List<Expression> expressions) {
        HashMap<String, Option> variables = new HashMap<String, Option>();
        this.head = head;
        this.body = body;
        this.expressions = expressions;
        for (Term t : head.terms) {
            if (!(t instanceof Term.Variable)) continue;
            variables.put(((Term.Variable)t).value, Option.none());
        }
        for (Predicate p : body) {
            for (Term t : p.terms) {
                if (!(t instanceof Term.Variable)) continue;
                variables.put(((Term.Variable)t).value, Option.none());
            }
        }
        for (Expression e : expressions) {
            if (!(e instanceof Expression.Value)) continue;
            Expression.Value ev = (Expression.Value)e;
            if (!(ev.value instanceof Term.Variable)) continue;
            variables.put(((Term.Variable)ev.value).value, Option.none());
        }
        this.variables = Option.some(variables);
    }

    public Rule clone() {
        Predicate head = this.head.clone();
        ArrayList<Predicate> body = new ArrayList<Predicate>();
        body.addAll(this.body);
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.addAll(this.expressions);
        return new Rule(head, body, expressions);
    }

    public void set(String name, Term term) throws Error.Language {
        if (this.variables.isDefined()) {
            Option t = Option.of((Object)((Option)((Map)this.variables.get()).get(name)));
            if (!t.isDefined()) {
                throw new Error.Language(new FailedCheck.LanguageError.UnknownVariable("name"));
            }
        } else {
            throw new Error.Language(new FailedCheck.LanguageError.UnknownVariable("name"));
        }
        ((Map)this.variables.get()).put(name, Option.some((Object)term));
    }

    public void apply_variables() {
        this.variables.forEach(_variables -> {
            this.head.terms = this.head.terms.stream().flatMap(t -> {
                if (t instanceof Term.Variable) {
                    Option term = _variables.getOrDefault(((Term.Variable)t).value, Option.none());
                    return (Stream)term.map(_t -> Stream.of(_t)).getOrElse(Stream.of(t));
                }
                return Stream.of(t);
            }).collect(Collectors.toList());
            for (Predicate p : this.body) {
                p.terms = p.terms.stream().flatMap(t -> {
                    if (t instanceof Term.Variable) {
                        Option term = _variables.getOrDefault(((Term.Variable)t).value, Option.none());
                        return (Stream)term.map(_t -> Stream.of(_t)).getOrElse(Stream.of(t));
                    }
                    return Stream.of(t);
                }).collect(Collectors.toList());
            }
            this.expressions = this.expressions.stream().flatMap(e -> {
                if (e instanceof Expression.Value) {
                    Option t;
                    Expression.Value ev = (Expression.Value)e;
                    if (ev.value instanceof Term.Variable && (t = _variables.getOrDefault(((Term.Variable)ev.value).value, Option.none())).isDefined()) {
                        return Stream.of(new Expression.Value((Term)t.get()));
                    }
                }
                return Stream.of(e);
            }).collect(Collectors.toList());
        });
    }

    public Either<String, Rule> validate_variables() {
        Set head_variables = this.head.terms.stream().flatMap(t -> {
            if (t instanceof Term.Variable) {
                return Stream.of(((Term.Variable)t).value);
            }
            return Stream.empty();
        }).collect(Collectors.toSet());
        for (Predicate p : this.body) {
            for (Term term : p.terms) {
                if (!(term instanceof Term.Variable)) continue;
                head_variables.remove(((Term.Variable)term).value);
                if (!head_variables.isEmpty()) continue;
                return Either.right((Object)this);
            }
        }
        return Either.left((Object)("rule head contains variables that are not used in predicates of the rule's body: " + head_variables.toString()));
    }

    public com.clevercloud.biscuit.datalog.Rule convert(SymbolTable symbols) {
        Rule r = this.clone();
        r.apply_variables();
        com.clevercloud.biscuit.datalog.Predicate head = r.head.convert(symbols);
        ArrayList<com.clevercloud.biscuit.datalog.Predicate> body = new ArrayList<com.clevercloud.biscuit.datalog.Predicate>();
        ArrayList<com.clevercloud.biscuit.datalog.expressions.Expression> expressions = new ArrayList<com.clevercloud.biscuit.datalog.expressions.Expression>();
        for (Predicate p : r.body) {
            body.add(p.convert(symbols));
        }
        for (Expression e : r.expressions) {
            expressions.add(e.convert(symbols));
        }
        return new com.clevercloud.biscuit.datalog.Rule(head, body, expressions);
    }

    public static Rule convert_from(com.clevercloud.biscuit.datalog.Rule r, SymbolTable symbols) {
        Predicate head = Predicate.convert_from(r.head(), symbols);
        ArrayList<Predicate> body = new ArrayList<Predicate>();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (com.clevercloud.biscuit.datalog.Predicate p : r.body()) {
            body.add(Predicate.convert_from(p, symbols));
        }
        for (com.clevercloud.biscuit.datalog.expressions.Expression e : r.expressions()) {
            expressions.add(Expression.convert_from(e, symbols));
        }
        return new Rule(head, body, expressions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        if (this.head != null ? !this.head.equals(rule.head) : rule.head != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(rule.body) : rule.body != null) {
            return false;
        }
        return this.expressions != null ? this.expressions.equals(rule.expressions) : rule.expressions == null;
    }

    public int hashCode() {
        int result = this.head != null ? this.head.hashCode() : 0;
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.expressions != null ? this.expressions.hashCode() : 0);
        return result;
    }

    public String toString() {
        Rule r = this.clone();
        r.apply_variables();
        List b = r.body.stream().map(pred -> pred.toString()).collect(Collectors.toList());
        String res = r.head.toString() + " <- " + String.join((CharSequence)", ", b);
        if (!r.expressions.isEmpty()) {
            List e = r.expressions.stream().map(expression -> expression.toString()).collect(Collectors.toList());
            res = res + ", " + String.join((CharSequence)", ", e);
        }
        return res;
    }
}

