/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.datalog;

import io.vavr.Tuple2;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.biscuitsec.biscuit.datalog.Fact;
import org.biscuitsec.biscuit.datalog.Origin;
import org.biscuitsec.biscuit.datalog.TrustedOrigins;

public class FactSet {
    private final HashMap<Origin, HashSet<Fact>> facts = new HashMap();

    public FactSet() {
    }

    public FactSet(Origin o, HashSet<Fact> factSet) {
        this.facts.put(o, factSet);
    }

    public HashMap<Origin, HashSet<Fact>> facts() {
        return this.facts;
    }

    public void add(Origin origin, Fact fact) {
        if (!this.facts.containsKey(origin)) {
            this.facts.put(origin, new HashSet());
        }
        this.facts.get(origin).add(fact);
    }

    public int size() {
        int size = 0;
        for (HashSet<Fact> h : this.facts.values()) {
            size += h.size();
        }
        return size;
    }

    public FactSet clone() {
        FactSet newFacts = new FactSet();
        for (Map.Entry<Origin, HashSet<Fact>> entry : this.facts.entrySet()) {
            HashSet h = new HashSet(entry.getValue());
            newFacts.facts.put(entry.getKey(), h);
        }
        return newFacts;
    }

    public void merge(FactSet other) {
        for (Map.Entry<Origin, HashSet<Fact>> entry : other.facts.entrySet()) {
            if (!this.facts.containsKey(entry.getKey())) {
                this.facts.put(entry.getKey(), entry.getValue());
                continue;
            }
            this.facts.get(entry.getKey()).addAll((Collection<Fact>)entry.getValue());
        }
    }

    public Stream stream(TrustedOrigins blockIds) {
        return this.facts.entrySet().stream().filter(entry -> {
            Origin o = (Origin)entry.getKey();
            return blockIds.contains(o);
        }).flatMap(entry -> ((HashSet)entry.getValue()).stream().map(fact -> new Tuple2(entry.getKey(), fact)));
    }

    public Stream<Fact> stream() {
        return this.facts.entrySet().stream().flatMap(entry -> ((HashSet)entry.getValue()).stream().map(fact -> fact));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactSet factSet = (FactSet)o;
        return this.facts.equals(factSet.facts);
    }

    public int hashCode() {
        return this.facts.hashCode();
    }

    public String toString() {
        StringBuilder res = new StringBuilder("FactSet {");
        for (Map.Entry<Origin, HashSet<Fact>> entry : this.facts.entrySet()) {
            res.append("\n\t").append(entry.getKey()).append("[");
            for (Fact fact : entry.getValue()) {
                res.append("\n\t\t").append(fact);
            }
            res.append("\n]");
        }
        res.append("\n}");
        return res.toString();
    }
}

