/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.datalog;

import io.vavr.control.Option;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.datalog.TemporarySymbolTable;
import org.biscuitsec.biscuit.datalog.Term;
import org.biscuitsec.biscuit.datalog.expressions.Expression;
import org.biscuitsec.biscuit.error.Error;

public final class MatchedVariables
implements Serializable {
    private final Map<Long, Optional<Term>> variables = new HashMap<Long, Optional<Term>>();

    public boolean insert(long key, Term value) {
        if (this.variables.containsKey(key)) {
            Optional<Term> val = this.variables.get(key);
            if (val.isPresent()) {
                return val.get().equals(value);
            }
            this.variables.put(key, Optional.of(value));
            return true;
        }
        return false;
    }

    public Optional<Term> get(long key) {
        return this.variables.get(key);
    }

    public boolean is_complete() {
        return this.variables.values().stream().allMatch(v -> v.isPresent());
    }

    public Option<Map<Long, Term>> complete() {
        HashMap<Long, Term> variables = new HashMap<Long, Term>();
        for (Map.Entry<Long, Optional<Term>> entry : this.variables.entrySet()) {
            if (entry.getValue().isPresent()) {
                variables.put(entry.getKey(), entry.getValue().get());
                continue;
            }
            return Option.none();
        }
        return Option.some(variables);
    }

    public MatchedVariables clone() {
        MatchedVariables other = new MatchedVariables(this.variables.keySet());
        for (Map.Entry<Long, Optional<Term>> entry : this.variables.entrySet()) {
            if (!entry.getValue().isPresent()) continue;
            other.variables.put(entry.getKey(), entry.getValue());
        }
        return other;
    }

    public MatchedVariables(Set<Long> ids) {
        for (Long id : ids) {
            this.variables.put(id, Optional.empty());
        }
    }

    public Option<Map<Long, Term>> check_expressions(List<Expression> expressions, SymbolTable symbols) throws Error {
        Option<Map<Long, Term>> vars = this.complete();
        if (vars.isDefined()) {
            Map variables = (Map)vars.get();
            for (Expression e : expressions) {
                Term term = e.evaluate(variables, new TemporarySymbolTable(symbols));
                if (term.equals(new Term.Bool(true))) continue;
                throw new Error.InvalidType();
            }
            return Option.some((Object)variables);
        }
        return Option.none();
    }
}

