/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.datalog;

import biscuit.format.schema.Schema;
import io.vavr.API;
import io.vavr.control.Either;
import org.biscuitsec.biscuit.error.Error;

public class Scope {
    Kind kind;
    long publicKey;

    private Scope(Kind kind, long publicKey) {
        this.kind = kind;
        this.publicKey = publicKey;
    }

    public static Scope authority() {
        return new Scope(Kind.Authority, 0L);
    }

    public static Scope previous() {
        return new Scope(Kind.Previous, 0L);
    }

    public static Scope publicKey(long publicKey) {
        return new Scope(Kind.PublicKey, publicKey);
    }

    public Kind kind() {
        return this.kind;
    }

    public long publicKey() {
        return this.publicKey;
    }

    public Schema.Scope serialize() {
        Schema.Scope.Builder b = Schema.Scope.newBuilder();
        switch (this.kind) {
            case Authority: {
                b.setScopeType(Schema.Scope.ScopeType.Authority);
                break;
            }
            case Previous: {
                b.setScopeType(Schema.Scope.ScopeType.Previous);
                break;
            }
            case PublicKey: {
                b.setPublicKey(this.publicKey);
            }
        }
        return b.build();
    }

    public static Either<Error.FormatError, Scope> deserialize(Schema.Scope scope) {
        if (scope.hasPublicKey()) {
            long publicKey = scope.getPublicKey();
            return API.Right((Object)Scope.publicKey(publicKey));
        }
        if (scope.hasScopeType()) {
            switch (scope.getScopeType()) {
                case Authority: {
                    return API.Right((Object)Scope.authority());
                }
                case Previous: {
                    return API.Right((Object)Scope.previous());
                }
            }
        }
        return API.Left((Object)new Error.FormatError.DeserializationError("invalid Scope"));
    }

    public String toString() {
        return "Scope{kind=" + this.kind + ", publicKey=" + this.publicKey + "}";
    }

    public static enum Kind {
        Authority,
        Previous,
        PublicKey;

    }
}

