/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.datalog;

import io.vavr.control.Option;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.biscuitsec.biscuit.crypto.PublicKey;
import org.biscuitsec.biscuit.datalog.Check;
import org.biscuitsec.biscuit.datalog.Fact;
import org.biscuitsec.biscuit.datalog.Predicate;
import org.biscuitsec.biscuit.datalog.Rule;
import org.biscuitsec.biscuit.datalog.Scope;
import org.biscuitsec.biscuit.datalog.Term;
import org.biscuitsec.biscuit.datalog.World;
import org.biscuitsec.biscuit.datalog.expressions.Expression;
import org.biscuitsec.biscuit.token.builder.Utils;

public final class SymbolTable
implements Serializable {
    public static final short DEFAULT_SYMBOLS_OFFSET = 1024;
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_INSTANT;
    public static final List<String> defaultSymbols = List.of("read", "write", "resource", "operation", "right", "time", "role", "owner", "tenant", "namespace", "user", "team", "service", "admin", "email", "group", "member", "ip_address", "client", "client_ip", "domain", "path", "version", "cluster", "node", "hostname", "nonce", "query");
    public final List<String> symbols = new ArrayList<String>();
    private final List<PublicKey> publicKeys;

    public String fromEpochIsoDate(long epochSec) {
        return Instant.ofEpochSecond(epochSec).atOffset(ZoneOffset.ofTotalSeconds(0)).format(this.dateTimeFormatter);
    }

    public long insert(String symbol) {
        int index = defaultSymbols.indexOf(symbol);
        if (index == -1) {
            index = this.symbols.indexOf(symbol);
            if (index == -1) {
                this.symbols.add(symbol);
                return this.symbols.size() - 1 + 1024;
            }
            return index + 1024;
        }
        return index;
    }

    public int currentOffset() {
        return this.symbols.size();
    }

    public int currentPublicKeyOffset() {
        return this.publicKeys.size();
    }

    public List<PublicKey> publicKeys() {
        return this.publicKeys;
    }

    public long insert(PublicKey publicKey) {
        int index = this.publicKeys.indexOf(publicKey);
        if (index == -1) {
            this.publicKeys.add(publicKey);
            return this.publicKeys.size() - 1;
        }
        return index;
    }

    public Term add(String symbol) {
        return new Term.Str(this.insert(symbol));
    }

    public Option<Long> get(String symbol) {
        long index = defaultSymbols.indexOf(symbol);
        if (index == -1L) {
            index = this.symbols.indexOf(symbol);
            if (index == -1L) {
                return Option.none();
            }
            return Option.some((Object)(index + 1024L));
        }
        return Option.some((Object)index);
    }

    public Option<String> get_s(int i) {
        if (i >= 0) {
            if (i < defaultSymbols.size() && i < 1024) {
                return Option.some((Object)defaultSymbols.get(i));
            }
        }
        if (i >= 1024 && i < this.symbols.size() + 1024) {
            return Option.some((Object)this.symbols.get(i - 1024));
        }
        return Option.none();
    }

    public Option<PublicKey> get_pk(int i) {
        if (i >= 0 && i < this.publicKeys.size()) {
            return Option.some((Object)this.publicKeys.get(i));
        }
        return Option.none();
    }

    public String print_rule(Rule r) {
        Object res = this.print_predicate(r.head());
        res = (String)res + " <- " + this.print_rule_body(r);
        return res;
    }

    public String print_rule_body(Rule r) {
        List preds = r.body().stream().map(p -> this.print_predicate((Predicate)p)).collect(Collectors.toList());
        List expressions = r.expressions().stream().map(c -> this.print_expression((Expression)c)).collect(Collectors.toList());
        Object res = String.join((CharSequence)", ", preds);
        if (!expressions.isEmpty()) {
            if (!preds.isEmpty()) {
                res = (String)res + ", ";
            }
            res = (String)res + String.join((CharSequence)", ", expressions);
        }
        if (!r.scopes().isEmpty()) {
            res = (String)res + " trusting ";
            List scopes = r.scopes().stream().map(s -> this.print_scope((Scope)s)).collect(Collectors.toList());
            res = (String)res + String.join((CharSequence)", ", scopes);
        }
        return res;
    }

    public String print_expression(Expression e) {
        return (String)e.print(this).get();
    }

    public String print_scope(Scope scope) {
        switch (scope.kind) {
            case Authority: {
                return "authority";
            }
            case Previous: {
                return "previous";
            }
            case PublicKey: {
                Option<PublicKey> pk = this.get_pk((int)scope.publicKey);
                if (!pk.isDefined()) break;
                return ((PublicKey)pk.get()).toString();
            }
        }
        return "?";
    }

    public String print_predicate(Predicate p) {
        List ids = p.terms().stream().map(t -> this.print_term((Term)t)).collect(Collectors.toList());
        return Optional.ofNullable(this.print_symbol((int)p.name())).orElse("<?>") + "(" + String.join((CharSequence)", ", ids) + ")";
    }

    public String print_term(Term i) {
        if (i instanceof Term.Variable) {
            return "$" + this.print_symbol((int)((Term.Variable)i).value());
        }
        if (i instanceof Term.Bool) {
            return i.toString();
        }
        if (i instanceof Term.Date) {
            return this.fromEpochIsoDate(((Term.Date)i).value());
        }
        if (i instanceof Term.Integer) {
            return "" + ((Term.Integer)i).value();
        }
        if (i instanceof Term.Str) {
            return "\"" + this.print_symbol((int)((Term.Str)i).value()) + "\"";
        }
        if (i instanceof Term.Bytes) {
            return "hex:" + Utils.byteArrayToHexString(((Term.Bytes)i).value()).toLowerCase();
        }
        if (i instanceof Term.Set) {
            List values = ((Term.Set)i).value().stream().map(v -> this.print_term((Term)v)).collect(Collectors.toList());
            return "[" + String.join((CharSequence)", ", values) + "]";
        }
        return "???";
    }

    public String print_fact(Fact f) {
        return this.print_predicate(f.predicate());
    }

    public String print_check(Check c) {
        String prefix;
        switch (c.kind()) {
            case One: {
                prefix = "check if ";
                break;
            }
            case All: {
                prefix = "check all ";
                break;
            }
            default: {
                prefix = "check if ";
            }
        }
        List queries = c.queries().stream().map(q -> this.print_rule_body((Rule)q)).collect(Collectors.toList());
        return prefix + String.join((CharSequence)" or ", queries);
    }

    public String print_world(World w) {
        List facts = w.facts().stream().map(f -> this.print_fact((Fact)f)).collect(Collectors.toList());
        List rules = w.rules().stream().map(r -> this.print_rule((Rule)r)).collect(Collectors.toList());
        StringBuilder b = new StringBuilder();
        b.append("World {\n\tfacts: [\n\t\t");
        b.append(String.join((CharSequence)",\n\t\t", facts));
        b.append("\n\t],\n\trules: [\n\t\t");
        b.append(String.join((CharSequence)",\n\t\t", rules));
        b.append("\n\t]\n}");
        return b.toString();
    }

    public String print_symbol(int i) {
        return (String)this.get_s(i).getOrElse((Object)("<" + i + "?>"));
    }

    public SymbolTable() {
        this.publicKeys = new ArrayList<PublicKey>();
    }

    public SymbolTable(SymbolTable s) {
        this.symbols.addAll(s.symbols);
        this.publicKeys = new ArrayList<PublicKey>();
        this.publicKeys.addAll(s.publicKeys);
    }

    public SymbolTable(List<String> symbols, List<PublicKey> publicKeys) {
        this.symbols.addAll(symbols);
        this.publicKeys = new ArrayList<PublicKey>();
        this.publicKeys.addAll(publicKeys);
    }

    public List<String> getAllSymbols() {
        ArrayList<String> allSymbols = new ArrayList<String>();
        allSymbols.addAll(defaultSymbols);
        allSymbols.addAll(this.symbols);
        return allSymbols;
    }
}

