/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.datalog;

import java.util.HashMap;
import java.util.List;
import org.biscuitsec.biscuit.datalog.Origin;
import org.biscuitsec.biscuit.datalog.Scope;

public class TrustedOrigins {
    private final Origin inner;

    public TrustedOrigins(int ... origins) {
        Origin origin = new Origin();
        for (int i : origins) {
            origin.add(i);
        }
        this.inner = origin;
    }

    private TrustedOrigins() {
        this.inner = new Origin();
    }

    private TrustedOrigins(Origin inner) {
        if (inner == null) {
            throw new RuntimeException();
        }
        this.inner = inner;
    }

    public TrustedOrigins clone() {
        return new TrustedOrigins(this.inner.clone());
    }

    public static TrustedOrigins defaultOrigins() {
        TrustedOrigins origins = new TrustedOrigins();
        origins.inner.add(0);
        origins.inner.add(Long.MAX_VALUE);
        return origins;
    }

    public static TrustedOrigins fromScopes(List<Scope> ruleScopes, TrustedOrigins defaultOrigins, long currentBlock, HashMap<Long, List<Long>> publicKeyToBlockId) {
        if (ruleScopes.isEmpty()) {
            TrustedOrigins origins = defaultOrigins.clone();
            origins.inner.add(currentBlock);
            origins.inner.add(Long.MAX_VALUE);
            return origins;
        }
        TrustedOrigins origins = new TrustedOrigins();
        origins.inner.add(currentBlock);
        origins.inner.add(Long.MAX_VALUE);
        block5: for (Scope scope : ruleScopes) {
            switch (scope.kind()) {
                case Authority: {
                    origins.inner.add(0);
                    break;
                }
                case Previous: {
                    if (currentBlock == Long.MAX_VALUE) break;
                    for (long i = 0L; i < currentBlock + 1L; ++i) {
                        origins.inner.add(i);
                    }
                    continue block5;
                }
                case PublicKey: {
                    List<Long> blockIds = publicKeyToBlockId.get(scope.publicKey());
                    if (blockIds == null) break;
                    origins.inner.inner.addAll(blockIds);
                }
            }
        }
        return origins;
    }

    public boolean contains(Origin factOrigin) {
        return this.inner.inner.containsAll(factOrigin.inner);
    }

    public String toString() {
        return "TrustedOrigins{inner=" + this.inner + "}";
    }
}

