/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.datalog.expressions;

import biscuit.format.schema.Schema;
import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import io.vavr.API;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.datalog.TemporarySymbolTable;
import org.biscuitsec.biscuit.datalog.Term;
import org.biscuitsec.biscuit.error.Error;

public abstract class Op {
    public abstract void evaluate(Deque<Term> var1, Map<Long, Term> var2, TemporarySymbolTable var3) throws Error.Execution;

    public abstract String print(Deque<String> var1, SymbolTable var2);

    public abstract Schema.Op serialize();

    public static Either<Error.FormatError, Op> deserializeV2(Schema.Op op) {
        if (op.hasValue()) {
            return Term.deserialize_enumV2(op.getValue()).map(v -> new Value((Term)v));
        }
        if (op.hasUnary()) {
            return Unary.deserializeV2(op.getUnary());
        }
        if (op.hasBinary()) {
            return Binary.deserializeV1(op.getBinary());
        }
        return API.Left((Object)new Error.FormatError.DeserializationError("invalid unary operation"));
    }

    public static final class Binary
    extends Op {
        private final BinaryOp op;

        public Binary(BinaryOp value) {
            this.op = value;
        }

        public BinaryOp getOp() {
            return this.op;
        }

        @Override
        public void evaluate(Deque<Term> stack, Map<Long, Term> variables, TemporarySymbolTable symbols) throws Error.Execution {
            Term right = stack.pop();
            Term left = stack.pop();
            switch (this.op) {
                case LessThan: {
                    if (right instanceof Term.Integer && left instanceof Term.Integer) {
                        stack.push(new Term.Bool(((Term.Integer)left).value() < ((Term.Integer)right).value()));
                    }
                    if (!(right instanceof Term.Date) || !(left instanceof Term.Date)) break;
                    stack.push(new Term.Bool(((Term.Date)left).value() < ((Term.Date)right).value()));
                    break;
                }
                case GreaterThan: {
                    if (right instanceof Term.Integer && left instanceof Term.Integer) {
                        stack.push(new Term.Bool(((Term.Integer)left).value() > ((Term.Integer)right).value()));
                    }
                    if (!(right instanceof Term.Date) || !(left instanceof Term.Date)) break;
                    stack.push(new Term.Bool(((Term.Date)left).value() > ((Term.Date)right).value()));
                    break;
                }
                case LessOrEqual: {
                    if (right instanceof Term.Integer && left instanceof Term.Integer) {
                        stack.push(new Term.Bool(((Term.Integer)left).value() <= ((Term.Integer)right).value()));
                    }
                    if (!(right instanceof Term.Date) || !(left instanceof Term.Date)) break;
                    stack.push(new Term.Bool(((Term.Date)left).value() <= ((Term.Date)right).value()));
                    break;
                }
                case GreaterOrEqual: {
                    if (right instanceof Term.Integer && left instanceof Term.Integer) {
                        stack.push(new Term.Bool(((Term.Integer)left).value() >= ((Term.Integer)right).value()));
                    }
                    if (!(right instanceof Term.Date) || !(left instanceof Term.Date)) break;
                    stack.push(new Term.Bool(((Term.Date)left).value() >= ((Term.Date)right).value()));
                    break;
                }
                case Equal: {
                    if (right instanceof Term.Bool && left instanceof Term.Bool) {
                        stack.push(new Term.Bool(((Term.Bool)left).value() == ((Term.Bool)right).value()));
                    }
                    if (right instanceof Term.Integer && left instanceof Term.Integer) {
                        stack.push(new Term.Bool(((Term.Integer)left).value() == ((Term.Integer)right).value()));
                    }
                    if (right instanceof Term.Str && left instanceof Term.Str) {
                        stack.push(new Term.Bool(((Term.Str)left).value() == ((Term.Str)right).value()));
                    }
                    if (right instanceof Term.Bytes && left instanceof Term.Bytes) {
                        stack.push(new Term.Bool(Arrays.equals(((Term.Bytes)left).value(), ((Term.Bytes)right).value())));
                    }
                    if (right instanceof Term.Date && left instanceof Term.Date) {
                        stack.push(new Term.Bool(((Term.Date)left).value() == ((Term.Date)right).value()));
                    }
                    if (!(right instanceof Term.Set) || !(left instanceof Term.Set)) break;
                    HashSet<Term> leftSet = ((Term.Set)left).value();
                    HashSet<Term> rightSet = ((Term.Set)right).value();
                    stack.push(new Term.Bool(leftSet.size() == rightSet.size() && leftSet.containsAll(rightSet)));
                    break;
                }
                case NotEqual: {
                    if (right instanceof Term.Bool && left instanceof Term.Bool) {
                        stack.push(new Term.Bool(((Term.Bool)left).value() == ((Term.Bool)right).value()));
                    }
                    if (right instanceof Term.Integer && left instanceof Term.Integer) {
                        stack.push(new Term.Bool(((Term.Integer)left).value() != ((Term.Integer)right).value()));
                    }
                    if (right instanceof Term.Str && left instanceof Term.Str) {
                        stack.push(new Term.Bool(((Term.Str)left).value() != ((Term.Str)right).value()));
                    }
                    if (right instanceof Term.Bytes && left instanceof Term.Bytes) {
                        stack.push(new Term.Bool(!Arrays.equals(((Term.Bytes)left).value(), ((Term.Bytes)right).value())));
                    }
                    if (right instanceof Term.Date && left instanceof Term.Date) {
                        stack.push(new Term.Bool(((Term.Date)left).value() != ((Term.Date)right).value()));
                    }
                    if (!(right instanceof Term.Set) || !(left instanceof Term.Set)) break;
                    HashSet<Term> leftSet = ((Term.Set)left).value();
                    HashSet<Term> rightSet = ((Term.Set)right).value();
                    stack.push(new Term.Bool(leftSet.size() != rightSet.size() || !leftSet.containsAll(rightSet)));
                    break;
                }
                case Contains: {
                    System.out.println("calling contains op with left " + left + " and right " + right);
                    if (left instanceof Term.Set && (right instanceof Term.Integer || right instanceof Term.Str || right instanceof Term.Bytes || right instanceof Term.Date || right instanceof Term.Bool)) {
                        stack.push(new Term.Bool(((Term.Set)left).value().contains(right)));
                    }
                    if (right instanceof Term.Set && left instanceof Term.Set) {
                        HashSet<Term> leftSet = ((Term.Set)left).value();
                        HashSet<Term> rightSet = ((Term.Set)right).value();
                        stack.push(new Term.Bool(leftSet.containsAll(rightSet)));
                    }
                    if (!(left instanceof Term.Str) || !(right instanceof Term.Str)) break;
                    Option<String> left_s = symbols.get_s((int)((Term.Str)left).value());
                    Option<String> right_s = symbols.get_s((int)((Term.Str)right).value());
                    if (left_s.isEmpty()) {
                        throw new Error.Execution("cannot find string in symbols for index " + ((Term.Str)left).value());
                    }
                    if (right_s.isEmpty()) {
                        throw new Error.Execution("cannot find string in symbols for index " + ((Term.Str)right).value());
                    }
                    stack.push(new Term.Bool(((String)left_s.get()).contains((CharSequence)right_s.get())));
                    break;
                }
                case Prefix: {
                    if (!(right instanceof Term.Str) || !(left instanceof Term.Str)) break;
                    Option<String> left_s = symbols.get_s((int)((Term.Str)left).value());
                    Option<String> right_s = symbols.get_s((int)((Term.Str)right).value());
                    if (left_s.isEmpty()) {
                        throw new Error.Execution("cannot find string in symbols for index " + ((Term.Str)left).value());
                    }
                    if (right_s.isEmpty()) {
                        throw new Error.Execution("cannot find string in symbols for index " + ((Term.Str)right).value());
                    }
                    stack.push(new Term.Bool(((String)left_s.get()).startsWith((String)right_s.get())));
                    break;
                }
                case Suffix: {
                    if (!(right instanceof Term.Str) || !(left instanceof Term.Str)) break;
                    Option<String> left_s = symbols.get_s((int)((Term.Str)left).value());
                    Option<String> right_s = symbols.get_s((int)((Term.Str)right).value());
                    if (left_s.isEmpty()) {
                        throw new Error.Execution("cannot find string in symbols for index " + ((Term.Str)left).value());
                    }
                    if (right_s.isEmpty()) {
                        throw new Error.Execution("cannot find string in symbols for index " + ((Term.Str)right).value());
                    }
                    stack.push(new Term.Bool(((String)left_s.get()).endsWith((String)right_s.get())));
                    break;
                }
                case Regex: {
                    if (!(right instanceof Term.Str) || !(left instanceof Term.Str)) break;
                    Option<String> left_s = symbols.get_s((int)((Term.Str)left).value());
                    Option<String> right_s = symbols.get_s((int)((Term.Str)right).value());
                    if (left_s.isEmpty()) {
                        throw new Error.Execution("cannot find string in symbols for index " + ((Term.Str)left).value());
                    }
                    if (right_s.isEmpty()) {
                        throw new Error.Execution("cannot find string in symbols for index " + ((Term.Str)right).value());
                    }
                    Pattern p = Pattern.compile((String)((String)right_s.get()));
                    Matcher m = p.matcher((CharSequence)left_s.get());
                    stack.push(new Term.Bool(m.find()));
                    break;
                }
                case Add: {
                    if (right instanceof Term.Integer && left instanceof Term.Integer) {
                        try {
                            stack.push(new Term.Integer(Math.addExact(((Term.Integer)left).value(), ((Term.Integer)right).value())));
                        }
                        catch (ArithmeticException e) {
                            throw new Error.Execution(Error.Execution.Kind.Overflow, "overflow");
                        }
                    }
                    if (!(right instanceof Term.Str) || !(left instanceof Term.Str)) break;
                    Option<String> left_s = symbols.get_s((int)((Term.Str)left).value());
                    Option<String> right_s = symbols.get_s((int)((Term.Str)right).value());
                    if (left_s.isEmpty()) {
                        throw new Error.Execution("cannot find string in symbols for index " + ((Term.Str)left).value());
                    }
                    if (right_s.isEmpty()) {
                        throw new Error.Execution("cannot find string in symbols for index " + ((Term.Str)right).value());
                    }
                    String concatenation = (String)left_s.get() + (String)right_s.get();
                    long index = symbols.insert(concatenation);
                    stack.push(new Term.Str(index));
                    break;
                }
                case Sub: {
                    if (!(right instanceof Term.Integer) || !(left instanceof Term.Integer)) break;
                    try {
                        stack.push(new Term.Integer(Math.subtractExact(((Term.Integer)left).value(), ((Term.Integer)right).value())));
                        break;
                    }
                    catch (ArithmeticException e) {
                        throw new Error.Execution(Error.Execution.Kind.Overflow, "overflow");
                    }
                }
                case Mul: {
                    if (!(right instanceof Term.Integer) || !(left instanceof Term.Integer)) break;
                    try {
                        stack.push(new Term.Integer(Math.multiplyExact(((Term.Integer)left).value(), ((Term.Integer)right).value())));
                        break;
                    }
                    catch (ArithmeticException e) {
                        throw new Error.Execution(Error.Execution.Kind.Overflow, "overflow");
                    }
                }
                case Div: {
                    long rl;
                    if (!(right instanceof Term.Integer) || !(left instanceof Term.Integer) || (rl = ((Term.Integer)right).value()) == 0L) break;
                    stack.push(new Term.Integer(((Term.Integer)left).value() / rl));
                    break;
                }
                case And: {
                    if (!(right instanceof Term.Bool) || !(left instanceof Term.Bool)) break;
                    stack.push(new Term.Bool(((Term.Bool)left).value() && ((Term.Bool)right).value()));
                    break;
                }
                case Or: {
                    if (!(right instanceof Term.Bool) || !(left instanceof Term.Bool)) break;
                    stack.push(new Term.Bool(((Term.Bool)left).value() || ((Term.Bool)right).value()));
                    break;
                }
                case Intersection: {
                    if (!(right instanceof Term.Set) || !(left instanceof Term.Set)) break;
                    HashSet<Term> intersec = new HashSet<Term>();
                    HashSet<Term> _right = ((Term.Set)right).value();
                    HashSet<Term> _left = ((Term.Set)left).value();
                    for (Term _id : _right) {
                        if (!_left.contains(_id)) continue;
                        intersec.add(_id);
                    }
                    stack.push(new Term.Set(intersec));
                    break;
                }
                case Union: {
                    if (!(right instanceof Term.Set) || !(left instanceof Term.Set)) break;
                    HashSet<Term> union = new HashSet<Term>();
                    HashSet<Term> _right = ((Term.Set)right).value();
                    HashSet<Term> _left = ((Term.Set)left).value();
                    union.addAll(_right);
                    union.addAll(_left);
                    stack.push(new Term.Set(union));
                    break;
                }
                case BitwiseAnd: {
                    if (!(right instanceof Term.Integer) || !(left instanceof Term.Integer)) break;
                    long r = ((Term.Integer)right).value();
                    long l = ((Term.Integer)left).value();
                    stack.push(new Term.Integer(r & l));
                    break;
                }
                case BitwiseOr: {
                    if (!(right instanceof Term.Integer) || !(left instanceof Term.Integer)) break;
                    long r = ((Term.Integer)right).value();
                    long l = ((Term.Integer)left).value();
                    stack.push(new Term.Integer(r | l));
                    break;
                }
                case BitwiseXor: {
                    if (!(right instanceof Term.Integer) || !(left instanceof Term.Integer)) break;
                    long r = ((Term.Integer)right).value();
                    long l = ((Term.Integer)left).value();
                    stack.push(new Term.Integer(r ^ l));
                    break;
                }
                default: {
                    throw new Error.Execution("binary exec error for op" + this);
                }
            }
        }

        @Override
        public String print(Deque<String> stack, SymbolTable symbols) {
            String right = stack.pop();
            String left = stack.pop();
            Object _s = "";
            switch (this.op) {
                case LessThan: {
                    _s = left + " < " + right;
                    stack.push((String)_s);
                    break;
                }
                case GreaterThan: {
                    _s = left + " > " + right;
                    stack.push((String)_s);
                    break;
                }
                case LessOrEqual: {
                    _s = left + " <= " + right;
                    stack.push((String)_s);
                    break;
                }
                case GreaterOrEqual: {
                    _s = left + " >= " + right;
                    stack.push((String)_s);
                    break;
                }
                case Equal: {
                    _s = left + " == " + right;
                    stack.push((String)_s);
                    break;
                }
                case NotEqual: {
                    _s = left + " != " + right;
                    stack.push((String)_s);
                    break;
                }
                case Contains: {
                    _s = left + ".contains(" + right + ")";
                    stack.push((String)_s);
                    break;
                }
                case Prefix: {
                    _s = left + ".starts_with(" + right + ")";
                    stack.push((String)_s);
                    break;
                }
                case Suffix: {
                    _s = left + ".ends_with(" + right + ")";
                    stack.push((String)_s);
                    break;
                }
                case Regex: {
                    _s = left + ".matches(" + right + ")";
                    stack.push((String)_s);
                    break;
                }
                case Add: {
                    _s = left + " + " + right;
                    stack.push((String)_s);
                    break;
                }
                case Sub: {
                    _s = left + " - " + right;
                    stack.push((String)_s);
                    break;
                }
                case Mul: {
                    _s = left + " * " + right;
                    stack.push((String)_s);
                    break;
                }
                case Div: {
                    _s = left + " / " + right;
                    stack.push((String)_s);
                    break;
                }
                case And: {
                    _s = left + " && " + right;
                    stack.push((String)_s);
                    break;
                }
                case Or: {
                    _s = left + " || " + right;
                    stack.push((String)_s);
                    break;
                }
                case Intersection: {
                    _s = left + ".intersection(" + right + ")";
                    stack.push((String)_s);
                    break;
                }
                case Union: {
                    _s = left + ".union(" + right + ")";
                    stack.push((String)_s);
                    break;
                }
                case BitwiseAnd: {
                    _s = left + " & " + right;
                    stack.push((String)_s);
                    break;
                }
                case BitwiseOr: {
                    _s = left + " | " + right;
                    stack.push((String)_s);
                    break;
                }
                case BitwiseXor: {
                    _s = left + " ^ " + right;
                    stack.push((String)_s);
                }
            }
            return _s;
        }

        @Override
        public Schema.Op serialize() {
            Schema.Op.Builder b = Schema.Op.newBuilder();
            Schema.OpBinary.Builder b1 = Schema.OpBinary.newBuilder();
            switch (this.op) {
                case LessThan: {
                    b1.setKind(Schema.OpBinary.Kind.LessThan);
                    break;
                }
                case GreaterThan: {
                    b1.setKind(Schema.OpBinary.Kind.GreaterThan);
                    break;
                }
                case LessOrEqual: {
                    b1.setKind(Schema.OpBinary.Kind.LessOrEqual);
                    break;
                }
                case GreaterOrEqual: {
                    b1.setKind(Schema.OpBinary.Kind.GreaterOrEqual);
                    break;
                }
                case Equal: {
                    b1.setKind(Schema.OpBinary.Kind.Equal);
                    break;
                }
                case NotEqual: {
                    b1.setKind(Schema.OpBinary.Kind.NotEqual);
                    break;
                }
                case Contains: {
                    b1.setKind(Schema.OpBinary.Kind.Contains);
                    break;
                }
                case Prefix: {
                    b1.setKind(Schema.OpBinary.Kind.Prefix);
                    break;
                }
                case Suffix: {
                    b1.setKind(Schema.OpBinary.Kind.Suffix);
                    break;
                }
                case Regex: {
                    b1.setKind(Schema.OpBinary.Kind.Regex);
                    break;
                }
                case Add: {
                    b1.setKind(Schema.OpBinary.Kind.Add);
                    break;
                }
                case Sub: {
                    b1.setKind(Schema.OpBinary.Kind.Sub);
                    break;
                }
                case Mul: {
                    b1.setKind(Schema.OpBinary.Kind.Mul);
                    break;
                }
                case Div: {
                    b1.setKind(Schema.OpBinary.Kind.Div);
                    break;
                }
                case And: {
                    b1.setKind(Schema.OpBinary.Kind.And);
                    break;
                }
                case Or: {
                    b1.setKind(Schema.OpBinary.Kind.Or);
                    break;
                }
                case Intersection: {
                    b1.setKind(Schema.OpBinary.Kind.Intersection);
                    break;
                }
                case Union: {
                    b1.setKind(Schema.OpBinary.Kind.Union);
                    break;
                }
                case BitwiseAnd: {
                    b1.setKind(Schema.OpBinary.Kind.BitwiseAnd);
                    break;
                }
                case BitwiseOr: {
                    b1.setKind(Schema.OpBinary.Kind.BitwiseOr);
                    break;
                }
                case BitwiseXor: {
                    b1.setKind(Schema.OpBinary.Kind.BitwiseXor);
                }
            }
            b.setBinary(b1.build());
            return b.build();
        }

        public static Either<Error.FormatError, Op> deserializeV1(Schema.OpBinary op) {
            switch (op.getKind()) {
                case LessThan: {
                    return API.Right((Object)new Binary(BinaryOp.LessThan));
                }
                case GreaterThan: {
                    return API.Right((Object)new Binary(BinaryOp.GreaterThan));
                }
                case LessOrEqual: {
                    return API.Right((Object)new Binary(BinaryOp.LessOrEqual));
                }
                case GreaterOrEqual: {
                    return API.Right((Object)new Binary(BinaryOp.GreaterOrEqual));
                }
                case Equal: {
                    return API.Right((Object)new Binary(BinaryOp.Equal));
                }
                case NotEqual: {
                    return API.Right((Object)new Binary(BinaryOp.NotEqual));
                }
                case Contains: {
                    return API.Right((Object)new Binary(BinaryOp.Contains));
                }
                case Prefix: {
                    return API.Right((Object)new Binary(BinaryOp.Prefix));
                }
                case Suffix: {
                    return API.Right((Object)new Binary(BinaryOp.Suffix));
                }
                case Regex: {
                    return API.Right((Object)new Binary(BinaryOp.Regex));
                }
                case Add: {
                    return API.Right((Object)new Binary(BinaryOp.Add));
                }
                case Sub: {
                    return API.Right((Object)new Binary(BinaryOp.Sub));
                }
                case Mul: {
                    return API.Right((Object)new Binary(BinaryOp.Mul));
                }
                case Div: {
                    return API.Right((Object)new Binary(BinaryOp.Div));
                }
                case And: {
                    return API.Right((Object)new Binary(BinaryOp.And));
                }
                case Or: {
                    return API.Right((Object)new Binary(BinaryOp.Or));
                }
                case Intersection: {
                    return API.Right((Object)new Binary(BinaryOp.Intersection));
                }
                case Union: {
                    return API.Right((Object)new Binary(BinaryOp.Union));
                }
                case BitwiseAnd: {
                    return API.Right((Object)new Binary(BinaryOp.BitwiseAnd));
                }
                case BitwiseOr: {
                    return API.Right((Object)new Binary(BinaryOp.BitwiseOr));
                }
                case BitwiseXor: {
                    return API.Right((Object)new Binary(BinaryOp.BitwiseXor));
                }
            }
            return API.Left((Object)new Error.FormatError.DeserializationError("invalid binary operation: " + op.getKind()));
        }

        public String toString() {
            return "Binary." + this.op;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Binary binary = (Binary)o;
            return this.op == binary.op;
        }

        public int hashCode() {
            return this.op.hashCode();
        }
    }

    public static enum BinaryOp {
        LessThan,
        GreaterThan,
        LessOrEqual,
        GreaterOrEqual,
        Equal,
        NotEqual,
        Contains,
        Prefix,
        Suffix,
        Regex,
        Add,
        Sub,
        Mul,
        Div,
        And,
        Or,
        Intersection,
        Union,
        BitwiseAnd,
        BitwiseOr,
        BitwiseXor;

    }

    public static final class Unary
    extends Op {
        private final UnaryOp op;

        public Unary(UnaryOp op) {
            this.op = op;
        }

        public UnaryOp getOp() {
            return this.op;
        }

        @Override
        public void evaluate(Deque<Term> stack, Map<Long, Term> variables, TemporarySymbolTable symbols) throws Error.Execution {
            Term value = stack.pop();
            switch (this.op) {
                case Negate: {
                    if (value instanceof Term.Bool) {
                        Term.Bool b = (Term.Bool)value;
                        stack.push(new Term.Bool(!b.value()));
                        break;
                    }
                    throw new Error.Execution("invalid type for negate op, expected boolean");
                }
                case Parens: {
                    stack.push(value);
                    break;
                }
                case Length: {
                    if (value instanceof Term.Str) {
                        Option<String> s = symbols.get_s((int)((Term.Str)value).value());
                        if (s.isEmpty()) {
                            throw new Error.Execution("string not found in symbols for id" + value);
                        }
                        stack.push(new Term.Integer(((String)s.get()).length()));
                        break;
                    }
                    if (value instanceof Term.Bytes) {
                        stack.push(new Term.Integer(((Term.Bytes)value).value().length));
                        break;
                    }
                    if (value instanceof Term.Set) {
                        stack.push(new Term.Integer(((Term.Set)value).value().size()));
                        break;
                    }
                    throw new Error.Execution("invalid type for length op");
                }
            }
        }

        @Override
        public String print(Deque<String> stack, SymbolTable symbols) {
            String prec = stack.pop();
            Object _s = "";
            switch (this.op) {
                case Negate: {
                    _s = "!" + prec;
                    stack.push((String)_s);
                    break;
                }
                case Parens: {
                    _s = "(" + prec + ")";
                    stack.push((String)_s);
                    break;
                }
                case Length: {
                    _s = prec + ".length()";
                    stack.push((String)_s);
                }
            }
            return _s;
        }

        @Override
        public Schema.Op serialize() {
            Schema.Op.Builder b = Schema.Op.newBuilder();
            Schema.OpUnary.Builder b1 = Schema.OpUnary.newBuilder();
            switch (this.op) {
                case Negate: {
                    b1.setKind(Schema.OpUnary.Kind.Negate);
                    break;
                }
                case Parens: {
                    b1.setKind(Schema.OpUnary.Kind.Parens);
                    break;
                }
                case Length: {
                    b1.setKind(Schema.OpUnary.Kind.Length);
                }
            }
            b.setUnary(b1.build());
            return b.build();
        }

        public static Either<Error.FormatError, Op> deserializeV2(Schema.OpUnary op) {
            switch (op.getKind()) {
                case Negate: {
                    return API.Right((Object)new Unary(UnaryOp.Negate));
                }
                case Parens: {
                    return API.Right((Object)new Unary(UnaryOp.Parens));
                }
                case Length: {
                    return API.Right((Object)new Unary(UnaryOp.Length));
                }
            }
            return API.Left((Object)new Error.FormatError.DeserializationError("invalid unary operation"));
        }

        public String toString() {
            return "Unary." + this.op;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Unary unary = (Unary)o;
            return this.op == unary.op;
        }

        public int hashCode() {
            return this.op.hashCode();
        }
    }

    public static enum UnaryOp {
        Negate,
        Parens,
        Length;

    }

    public static final class Value
    extends Op {
        private final Term value;

        public Value(Term value) {
            this.value = value;
        }

        public Term getValue() {
            return this.value;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void evaluate(Deque<Term> stack, Map<Long, Term> variables, TemporarySymbolTable symbols) throws Error.Execution {
            if (this.value instanceof Term.Variable) {
                Term.Variable var = (Term.Variable)this.value;
                Term valueVar = variables.get(var.value());
                if (valueVar == null) throw new Error.Execution("cannot find a variable for index " + this.value);
                stack.push(valueVar);
                return;
            } else {
                stack.push(this.value);
            }
        }

        @Override
        public String print(Deque<String> stack, SymbolTable symbols) {
            String s = symbols.print_term(this.value);
            stack.push(s);
            return s;
        }

        @Override
        public Schema.Op serialize() {
            Schema.Op.Builder b = Schema.Op.newBuilder();
            b.setValue(this.value.serialize());
            return b.build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value1 = (Value)o;
            return this.value.equals(value1.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "Value(" + this.value + ")";
        }
    }
}

