/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.error;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.vavr.control.Option;
import java.util.List;
import java.util.Objects;
import org.biscuitsec.biscuit.error.FailedCheck;

public class LogicError {
    public Option<List<FailedCheck>> failed_checks() {
        return Option.none();
    }

    public JsonElement toJson() {
        return new JsonObject();
    }

    public static abstract class MatchedPolicy {
        public abstract JsonElement toJson();

        public static class Deny
        extends MatchedPolicy {
            public final long nb;

            public Deny(long nb) {
                this.nb = nb;
            }

            public String toString() {
                return "Deny(" + this.nb + ")";
            }

            @Override
            public JsonElement toJson() {
                JsonObject jo = new JsonObject();
                jo.addProperty("Deny", (Number)this.nb);
                return jo;
            }
        }

        public static class Allow
        extends MatchedPolicy {
            public final long nb;

            public Allow(long nb) {
                this.nb = nb;
            }

            public String toString() {
                return "Allow(" + this.nb + ")";
            }

            @Override
            public JsonElement toJson() {
                JsonObject jo = new JsonObject();
                jo.addProperty("Allow", (Number)this.nb);
                return jo;
            }
        }
    }

    public static class AuthorizerNotEmpty
    extends LogicError {
        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public String toString() {
            return "AuthorizerNotEmpty";
        }
    }

    public static class NoMatchingPolicy
    extends LogicError {
        public final List<FailedCheck> errors;

        public NoMatchingPolicy(List<FailedCheck> errors) {
            this.errors = errors;
        }

        public int hashCode() {
            return Objects.hash(this.errors);
        }

        @Override
        public Option<List<FailedCheck>> failed_checks() {
            return Option.some(this.errors);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Unauthorized other = (Unauthorized)o;
            if (this.errors.size() != other.errors.size()) {
                return false;
            }
            for (int i = 0; i < this.errors.size(); ++i) {
                if (this.errors.get(i).equals(other.errors.get(i))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "NoMatchingPolicy{}";
        }

        @Override
        public JsonElement toJson() {
            JsonObject jo = new JsonObject();
            JsonArray ja = new JsonArray();
            for (FailedCheck t : this.errors) {
                ja.add(t.toJson());
            }
            jo.add("NoMatchingPolicy", (JsonElement)ja);
            return jo;
        }
    }

    public static class Unauthorized
    extends LogicError {
        public final List<FailedCheck> errors;
        public final MatchedPolicy policy;

        public Unauthorized(MatchedPolicy policy, List<FailedCheck> errors) {
            this.errors = errors;
            this.policy = policy;
        }

        @Override
        public Option<List<FailedCheck>> failed_checks() {
            return Option.some(this.errors);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Unauthorized other = (Unauthorized)o;
            if (this.errors.size() != other.errors.size()) {
                return false;
            }
            for (int i = 0; i < this.errors.size(); ++i) {
                if (this.errors.get(i).equals(other.errors.get(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.errors);
        }

        public String toString() {
            return "Unauthorized( policy = " + this.policy + " errors = " + this.errors + ")";
        }

        @Override
        public JsonElement toJson() {
            JsonObject jo = new JsonObject();
            JsonObject unauthorized = new JsonObject();
            unauthorized.add("policy", this.policy.toJson());
            JsonArray ja = new JsonArray();
            for (FailedCheck t : this.errors) {
                ja.add(t.toJson());
            }
            unauthorized.add("checks", (JsonElement)ja);
            jo.add("Unauthorized", (JsonElement)unauthorized);
            return jo;
        }
    }

    public static class InvalidBlockRule
    extends LogicError {
        public final long id;
        public final String e;

        public InvalidBlockRule(long id, String e) {
            this.id = id;
            this.e = e;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvalidBlockRule other = (InvalidBlockRule)o;
            return this.id == other.id && this.e.equals(other.e);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.e);
        }

        public String toString() {
            return "LogicError.InvalidBlockRule{ id: " + this.id + ", error: " + this.e + " }";
        }

        @Override
        public JsonElement toJson() {
            JsonArray child = new JsonArray();
            child.add((Number)this.id);
            child.add(this.e);
            JsonObject root = new JsonObject();
            root.add("InvalidBlockRule", (JsonElement)child);
            return root;
        }
    }

    public static class InvalidBlockFact
    extends LogicError {
        public final long id;
        public final String e;

        public InvalidBlockFact(long id, String e) {
            this.id = id;
            this.e = e;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvalidBlockFact other = (InvalidBlockFact)o;
            return this.id == other.id && this.e.equals(other.e);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.e);
        }

        public String toString() {
            return "LogicError.InvalidBlockFact{ id: " + this.id + ", error: " + this.e + " }";
        }

        @Override
        public JsonElement toJson() {
            JsonObject child = new JsonObject();
            child.addProperty("id", (Number)this.id);
            child.addProperty("error", this.e);
            JsonObject root = new JsonObject();
            root.add("InvalidBlockFact", (JsonElement)child);
            return root;
        }
    }

    public static class InvalidAmbientFact
    extends LogicError {
        public final String e;

        public InvalidAmbientFact(String e) {
            this.e = e;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvalidAmbientFact other = (InvalidAmbientFact)o;
            return this.e.equals(other.e);
        }

        public int hashCode() {
            return Objects.hash(this.e);
        }

        public String toString() {
            return "LogicError.InvalidAmbientFact{ error: " + this.e + " }";
        }

        @Override
        public JsonElement toJson() {
            JsonObject child = new JsonObject();
            child.addProperty("error", this.e);
            JsonObject root = new JsonObject();
            root.add("InvalidAmbientFact", (JsonElement)child);
            return root;
        }
    }

    public static class InvalidAuthorityFact
    extends LogicError {
        public final String e;

        public InvalidAuthorityFact(String e) {
            this.e = e;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvalidAuthorityFact other = (InvalidAuthorityFact)o;
            return this.e.equals(other.e);
        }

        public int hashCode() {
            return Objects.hash(this.e);
        }

        public String toString() {
            return "LogicError.InvalidAuthorityFact{ error: " + this.e + " }";
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive("InvalidAuthorityFact");
        }
    }
}

