/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token;

import io.vavr.Tuple3;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.biscuitsec.biscuit.crypto.KeyDelegate;
import org.biscuitsec.biscuit.crypto.KeyPair;
import org.biscuitsec.biscuit.crypto.PublicKey;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.error.Error;
import org.biscuitsec.biscuit.token.Authorizer;
import org.biscuitsec.biscuit.token.UnverifiedBiscuit;
import org.biscuitsec.biscuit.token.builder.Block;
import org.biscuitsec.biscuit.token.format.SerializedBiscuit;

public class Biscuit
extends UnverifiedBiscuit {
    public static org.biscuitsec.biscuit.token.builder.Biscuit builder(KeyPair root) {
        return new org.biscuitsec.biscuit.token.builder.Biscuit(new SecureRandom(), root, Biscuit.default_symbol_table());
    }

    public static org.biscuitsec.biscuit.token.builder.Biscuit builder(SecureRandom rng, KeyPair root) {
        return new org.biscuitsec.biscuit.token.builder.Biscuit(rng, root, Biscuit.default_symbol_table());
    }

    public static org.biscuitsec.biscuit.token.builder.Biscuit builder(SecureRandom rng, KeyPair root, Option<Integer> root_key_id, SymbolTable symbols) {
        return new org.biscuitsec.biscuit.token.builder.Biscuit(rng, root, root_key_id, symbols);
    }

    public static org.biscuitsec.biscuit.token.builder.Biscuit builder(SecureRandom rng, KeyPair root, SymbolTable symbols) {
        return new org.biscuitsec.biscuit.token.builder.Biscuit(rng, root, symbols);
    }

    public static Biscuit make(SecureRandom rng, KeyPair root, SymbolTable symbols, org.biscuitsec.biscuit.token.Block authority) throws Error.SymbolTableOverlap, Error.FormatError {
        return Biscuit.make(rng, root, (Option<Integer>)Option.none(), symbols, authority);
    }

    public static Biscuit make(SecureRandom rng, KeyPair root, Integer root_key_id, SymbolTable symbols, org.biscuitsec.biscuit.token.Block authority) throws Error.SymbolTableOverlap, Error.FormatError {
        return Biscuit.make(rng, root, (Option<Integer>)Option.of((Object)root_key_id), symbols, authority);
    }

    private static Biscuit make(SecureRandom rng, KeyPair root, Option<Integer> root_key_id, SymbolTable symbols, org.biscuitsec.biscuit.token.Block authority) throws Error.SymbolTableOverlap, Error.FormatError {
        if (!Collections.disjoint(symbols.symbols, authority.symbols.symbols)) {
            throw new Error.SymbolTableOverlap();
        }
        symbols.symbols.addAll(authority.symbols.symbols);
        ArrayList<org.biscuitsec.biscuit.token.Block> blocks = new ArrayList<org.biscuitsec.biscuit.token.Block>();
        KeyPair next = new KeyPair(rng);
        Either<Error.FormatError, SerializedBiscuit> container = SerializedBiscuit.make(root, root_key_id, authority, next);
        if (container.isLeft()) {
            Error.FormatError e = (Error.FormatError)container.getLeft();
            throw e;
        }
        SerializedBiscuit s = (SerializedBiscuit)container.get();
        List<byte[]> revocation_ids = s.revocation_identifiers();
        HashMap<Long, List<Long>> publicKeyToBlockId = new HashMap<Long, List<Long>>();
        Option c = Option.some((Object)s);
        return new Biscuit(authority, blocks, symbols, s, publicKeyToBlockId, revocation_ids, root_key_id);
    }

    Biscuit(org.biscuitsec.biscuit.token.Block authority, List<org.biscuitsec.biscuit.token.Block> blocks, SymbolTable symbols, SerializedBiscuit serializedBiscuit, HashMap<Long, List<Long>> publicKeyToBlockId, List<byte[]> revocation_ids) {
        super(authority, blocks, symbols, serializedBiscuit, publicKeyToBlockId, revocation_ids);
    }

    Biscuit(org.biscuitsec.biscuit.token.Block authority, List<org.biscuitsec.biscuit.token.Block> blocks, SymbolTable symbols, SerializedBiscuit serializedBiscuit, HashMap<Long, List<Long>> publicKeyToBlockId, List<byte[]> revocation_ids, Option<Integer> root_key_id) {
        super(authority, blocks, symbols, serializedBiscuit, publicKeyToBlockId, revocation_ids, root_key_id);
    }

    @Deprecated
    public static Biscuit from_b64(String data, PublicKey root) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes(Base64.getUrlDecoder().decode(data), root);
    }

    public static Biscuit from_b64url(String data, PublicKey root) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes(Base64.getUrlDecoder().decode(data), root);
    }

    public static Biscuit from_b64url(String data, KeyDelegate delegate) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes(Base64.getUrlDecoder().decode(data), delegate);
    }

    public static Biscuit from_bytes(byte[] data, PublicKey root) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes_with_symbols(data, root, Biscuit.default_symbol_table());
    }

    public static Biscuit from_bytes(byte[] data, KeyDelegate delegate) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes_with_symbols(data, delegate, Biscuit.default_symbol_table());
    }

    public static Biscuit from_bytes_with_symbols(byte[] data, PublicKey root, SymbolTable symbols) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        SerializedBiscuit ser = SerializedBiscuit.from_bytes(data, root);
        return Biscuit.from_serialized_biscuit(ser, symbols);
    }

    public static Biscuit from_bytes_with_symbols(byte[] data, KeyDelegate delegate, SymbolTable symbols) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        SerializedBiscuit ser = SerializedBiscuit.from_bytes(data, delegate);
        return Biscuit.from_serialized_biscuit(ser, symbols);
    }

    static Biscuit from_serialized_biscuit(SerializedBiscuit ser, SymbolTable symbols) throws Error {
        Tuple3<org.biscuitsec.biscuit.token.Block, ArrayList<org.biscuitsec.biscuit.token.Block>, HashMap<Long, List<Long>>> t = ser.extractBlocks(symbols);
        org.biscuitsec.biscuit.token.Block authority = (org.biscuitsec.biscuit.token.Block)t._1;
        ArrayList blocks = (ArrayList)t._2;
        HashMap publicKeyToBlockId = (HashMap)t._3;
        List<byte[]> revocation_ids = ser.revocation_identifiers();
        return new Biscuit(authority, blocks, symbols, ser, publicKeyToBlockId, revocation_ids);
    }

    public Authorizer authorizer() throws Error.FailedLogic {
        return Authorizer.make(this);
    }

    @Override
    public byte[] serialize() throws Error.FormatError.SerializationError {
        return this.serializedBiscuit.serialize();
    }

    @Deprecated
    public String serialize_b64() throws Error.FormatError.SerializationError {
        return Base64.getUrlEncoder().encodeToString(this.serialize());
    }

    @Override
    public String serialize_b64url() throws Error.FormatError.SerializationError {
        return Base64.getUrlEncoder().encodeToString(this.serialize());
    }

    @Override
    public Biscuit attenuate(Block block) throws Error {
        SecureRandom rng = new SecureRandom();
        KeyPair keypair = new KeyPair(rng);
        return this.attenuate(rng, keypair, block.build());
    }

    @Override
    public Biscuit attenuate(SecureRandom rng, KeyPair keypair, org.biscuitsec.biscuit.token.Block block) throws Error {
        Biscuit copiedBiscuit = this.copy();
        if (!Collections.disjoint(copiedBiscuit.symbols.symbols, block.symbols.symbols)) {
            throw new Error.SymbolTableOverlap();
        }
        Either<Error.FormatError, SerializedBiscuit> containerRes = copiedBiscuit.serializedBiscuit.append(keypair, block);
        if (containerRes.isLeft()) {
            Error.FormatError error = (Error.FormatError)containerRes.getLeft();
            throw error;
        }
        SerializedBiscuit container = (SerializedBiscuit)containerRes.get();
        SymbolTable symbols = new SymbolTable(copiedBiscuit.symbols);
        for (String string : block.symbols.symbols) {
            symbols.add(string);
        }
        ArrayList<org.biscuitsec.biscuit.token.Block> blocks = new ArrayList<org.biscuitsec.biscuit.token.Block>();
        for (org.biscuitsec.biscuit.token.Block b : copiedBiscuit.blocks) {
            blocks.add(b);
        }
        blocks.add(block);
        List<byte[]> list = container.revocation_identifiers();
        HashMap<Long, List<Long>> publicKeyToBlockId = new HashMap<Long, List<Long>>();
        publicKeyToBlockId.putAll(this.publicKeyToBlockId);
        return new Biscuit(copiedBiscuit.authority, blocks, symbols, container, publicKeyToBlockId, list);
    }

    @Override
    public String print() {
        StringBuilder s = new StringBuilder();
        s.append("Biscuit {\n\tsymbols: ");
        s.append(this.symbols.getAllSymbols());
        s.append("\n\tauthority: ");
        s.append(this.authority.print(this.symbols));
        s.append("\n\tblocks: [\n");
        for (org.biscuitsec.biscuit.token.Block b : this.blocks) {
            s.append("\t\t");
            s.append(b.print(this.symbols));
            s.append("\n");
        }
        s.append("\t]\n}");
        return s.toString();
    }

    @Override
    public Biscuit copy() throws Error {
        return Biscuit.from_serialized_biscuit(this.serializedBiscuit, this.symbols);
    }
}

