/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token;

import biscuit.format.schema.Schema;
import com.google.protobuf.InvalidProtocolBufferException;
import io.vavr.API;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.biscuitsec.biscuit.crypto.PublicKey;
import org.biscuitsec.biscuit.datalog.Check;
import org.biscuitsec.biscuit.datalog.Fact;
import org.biscuitsec.biscuit.datalog.Rule;
import org.biscuitsec.biscuit.datalog.SchemaVersion;
import org.biscuitsec.biscuit.datalog.Scope;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.error.Error;
import org.biscuitsec.biscuit.token.format.SerializedBiscuit;

public class Block {
    final SymbolTable symbols;
    final String context;
    final List<Fact> facts;
    final List<Rule> rules;
    final List<Check> checks;
    final List<Scope> scopes;
    final List<PublicKey> publicKeys;
    final Option<PublicKey> externalKey;
    final long version;

    public Block(SymbolTable base_symbols) {
        this.symbols = base_symbols;
        this.context = "";
        this.facts = new ArrayList<Fact>();
        this.rules = new ArrayList<Rule>();
        this.checks = new ArrayList<Check>();
        this.scopes = new ArrayList<Scope>();
        this.publicKeys = new ArrayList<PublicKey>();
        this.externalKey = Option.none();
        this.version = SerializedBiscuit.MAX_SCHEMA_VERSION;
    }

    public Block(SymbolTable base_symbols, String context, List<Fact> facts, List<Rule> rules, List<Check> checks, List<Scope> scopes, List<PublicKey> publicKeys, Option<PublicKey> externalKey, int version) {
        this.symbols = base_symbols;
        this.context = context;
        this.facts = facts;
        this.rules = rules;
        this.checks = checks;
        this.scopes = scopes;
        this.version = version;
        this.publicKeys = publicKeys;
        this.externalKey = externalKey;
    }

    public SymbolTable symbols() {
        return this.symbols;
    }

    public List<PublicKey> publicKeys() {
        return this.publicKeys;
    }

    public String print(SymbolTable symbol_table) {
        StringBuilder s = new StringBuilder();
        s.append("Block");
        s.append(" {\n\t\tsymbols: ");
        s.append(this.symbols.symbols);
        s.append("\n\t\tcontext: ");
        s.append(this.context);
        if (this.externalKey.isDefined()) {
            s.append("\n\t\texternal key: ");
            s.append(((PublicKey)this.externalKey.get()).toString());
        }
        s.append("\n\t\tfacts: [");
        for (Fact f : this.facts) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_fact(f));
        }
        s.append("\n\t\t]\n\t\trules: [");
        for (Rule r : this.rules) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_rule(r));
        }
        s.append("\n\t\t]\n\t\tchecks: [");
        for (Check c : this.checks) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_check(c));
        }
        s.append("\n\t\t]\n\t}");
        return s.toString();
    }

    public Schema.Block serialize() {
        int i;
        Schema.Block.Builder b = Schema.Block.newBuilder();
        for (i = 0; i < this.symbols.symbols.size(); ++i) {
            b.addSymbols(this.symbols.symbols.get(i));
        }
        if (!this.context.isEmpty()) {
            b.setContext(this.context);
        }
        for (i = 0; i < this.facts.size(); ++i) {
            b.addFactsV2(this.facts.get(i).serialize());
        }
        for (i = 0; i < this.rules.size(); ++i) {
            b.addRulesV2(this.rules.get(i).serialize());
        }
        for (i = 0; i < this.checks.size(); ++i) {
            b.addChecksV2(this.checks.get(i).serialize());
        }
        for (Scope scope : this.scopes) {
            b.addScope(scope.serialize());
        }
        for (PublicKey pk : this.publicKeys) {
            b.addPublicKeys(pk.serialize());
        }
        b.setVersion(SerializedBiscuit.MAX_SCHEMA_VERSION);
        return b.build();
    }

    public static Either<Error.FormatError, Block> deserialize(Schema.Block b, Option<PublicKey> externalKey) {
        Object res;
        int version = b.getVersion();
        if (version < SerializedBiscuit.MIN_SCHEMA_VERSION || version > SerializedBiscuit.MAX_SCHEMA_VERSION) {
            return API.Left((Object)new Error.FormatError.Version(SerializedBiscuit.MIN_SCHEMA_VERSION, SerializedBiscuit.MAX_SCHEMA_VERSION, version));
        }
        SymbolTable symbols = new SymbolTable();
        for (String s : b.getSymbolsList()) {
            symbols.add(s);
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ArrayList<Check> checks = new ArrayList<Check>();
        for (Schema.FactV2 factV2 : b.getFactsV2List()) {
            Either<Error.FormatError, Fact> either = Fact.deserializeV2(factV2);
            if (either.isLeft()) {
                Error.FormatError e = (Error.FormatError)either.getLeft();
                return API.Left((Object)e);
            }
            facts.add((Fact)either.get());
        }
        for (Schema.RuleV2 ruleV2 : b.getRulesV2List()) {
            Either<Error.FormatError, Rule> either = Rule.deserializeV2(ruleV2);
            if (either.isLeft()) {
                Error.FormatError e = (Error.FormatError)either.getLeft();
                return API.Left((Object)e);
            }
            rules.add((Rule)either.get());
        }
        for (Schema.CheckV2 checkV2 : b.getChecksV2List()) {
            Either<Error.FormatError, Check> either = Check.deserializeV2(checkV2);
            if (either.isLeft()) {
                Error.FormatError e = (Error.FormatError)either.getLeft();
                return API.Left((Object)e);
            }
            checks.add((Check)either.get());
        }
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        for (Schema.Scope scope : b.getScopeList()) {
            res = Scope.deserialize(scope);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            scopes.add((Scope)res.get());
        }
        ArrayList<PublicKey> arrayList = new ArrayList<PublicKey>();
        for (Schema.PublicKey pk : b.getPublicKeysList()) {
            try {
                arrayList.add(PublicKey.deserialize(pk));
            }
            catch (Error.FormatError e) {
                return API.Left((Object)e);
            }
        }
        SchemaVersion schemaVersion = new SchemaVersion(facts, rules, checks, scopes);
        res = schemaVersion.checkCompatibility(version);
        if (res.isLeft()) {
            Error.FormatError e = (Error.FormatError)res.getLeft();
            return API.Left((Object)e);
        }
        return API.Right((Object)new Block(symbols, b.getContext(), facts, rules, checks, scopes, arrayList, externalKey, version));
    }

    public static Either<Error.FormatError, Block> from_bytes(byte[] slice, Option<PublicKey> externalKey) {
        try {
            Schema.Block data = Schema.Block.parseFrom(slice);
            return Block.deserialize(data, externalKey);
        }
        catch (InvalidProtocolBufferException e) {
            return API.Left((Object)new Error.FormatError.DeserializationError(e.toString()));
        }
    }

    public Either<Error.FormatError, byte[]> to_bytes() {
        Schema.Block b = this.serialize();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            b.writeTo(stream);
            byte[] data = stream.toByteArray();
            return API.Right((Object)data);
        }
        catch (IOException e) {
            return API.Left((Object)new Error.FormatError.SerializationError(e.toString()));
        }
    }
}

