/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token;

import io.vavr.Tuple3;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.biscuitsec.biscuit.crypto.KeyDelegate;
import org.biscuitsec.biscuit.crypto.KeyPair;
import org.biscuitsec.biscuit.crypto.PublicKey;
import org.biscuitsec.biscuit.datalog.Check;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.error.Error;
import org.biscuitsec.biscuit.token.Biscuit;
import org.biscuitsec.biscuit.token.RevocationIdentifier;
import org.biscuitsec.biscuit.token.builder.Block;
import org.biscuitsec.biscuit.token.format.SerializedBiscuit;

public class UnverifiedBiscuit {
    final org.biscuitsec.biscuit.token.Block authority;
    final List<org.biscuitsec.biscuit.token.Block> blocks;
    final SymbolTable symbols;
    final SerializedBiscuit serializedBiscuit;
    final List<byte[]> revocation_ids;
    final Option<Integer> root_key_id;
    final HashMap<Long, List<Long>> publicKeyToBlockId;

    UnverifiedBiscuit(org.biscuitsec.biscuit.token.Block authority, List<org.biscuitsec.biscuit.token.Block> blocks, SymbolTable symbols, SerializedBiscuit serializedBiscuit, HashMap<Long, List<Long>> publicKeyToBlockId, List<byte[]> revocation_ids) {
        this.authority = authority;
        this.blocks = blocks;
        this.symbols = symbols;
        this.serializedBiscuit = serializedBiscuit;
        this.publicKeyToBlockId = publicKeyToBlockId;
        this.revocation_ids = revocation_ids;
        this.root_key_id = Option.none();
    }

    UnverifiedBiscuit(org.biscuitsec.biscuit.token.Block authority, List<org.biscuitsec.biscuit.token.Block> blocks, SymbolTable symbols, SerializedBiscuit serializedBiscuit, HashMap<Long, List<Long>> publicKeyToBlockId, List<byte[]> revocation_ids, Option<Integer> root_key_id) {
        this.authority = authority;
        this.blocks = blocks;
        this.symbols = symbols;
        this.serializedBiscuit = serializedBiscuit;
        this.publicKeyToBlockId = publicKeyToBlockId;
        this.revocation_ids = revocation_ids;
        this.root_key_id = root_key_id;
    }

    public static UnverifiedBiscuit from_b64url(String data) throws Error {
        return UnverifiedBiscuit.from_bytes(Base64.getUrlDecoder().decode(data));
    }

    public static UnverifiedBiscuit from_bytes(byte[] data) throws Error {
        return UnverifiedBiscuit.from_bytes_with_symbols(data, UnverifiedBiscuit.default_symbol_table());
    }

    public static UnverifiedBiscuit from_bytes_with_symbols(byte[] data, SymbolTable symbols) throws Error {
        SerializedBiscuit ser = SerializedBiscuit.unsafe_deserialize(data);
        return UnverifiedBiscuit.from_serialized_biscuit(ser, symbols);
    }

    private static UnverifiedBiscuit from_serialized_biscuit(SerializedBiscuit ser, SymbolTable symbols) throws Error {
        Tuple3<org.biscuitsec.biscuit.token.Block, ArrayList<org.biscuitsec.biscuit.token.Block>, HashMap<Long, List<Long>>> t = ser.extractBlocks(symbols);
        org.biscuitsec.biscuit.token.Block authority = (org.biscuitsec.biscuit.token.Block)t._1;
        ArrayList blocks = (ArrayList)t._2;
        HashMap publicKeyToBlockId = (HashMap)t._3;
        List<byte[]> revocation_ids = ser.revocation_identifiers();
        return new UnverifiedBiscuit(authority, blocks, symbols, ser, publicKeyToBlockId, revocation_ids);
    }

    public byte[] serialize() throws Error.FormatError.SerializationError {
        return this.serializedBiscuit.serialize();
    }

    public String serialize_b64url() throws Error.FormatError.SerializationError {
        return Base64.getUrlEncoder().encodeToString(this.serialize());
    }

    public Block create_block() {
        return new Block(1 + this.blocks.size(), new SymbolTable(this.symbols));
    }

    public UnverifiedBiscuit attenuate(Block block) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        SecureRandom rng = new SecureRandom();
        KeyPair keypair = new KeyPair(rng);
        return this.attenuate(rng, keypair, block.build());
    }

    public UnverifiedBiscuit attenuate(SecureRandom rng, KeyPair keypair, org.biscuitsec.biscuit.token.Block block) throws Error {
        UnverifiedBiscuit copiedBiscuit = this.copy();
        if (!Collections.disjoint(copiedBiscuit.symbols.symbols, block.symbols.symbols)) {
            throw new Error.SymbolTableOverlap();
        }
        Either<Error.FormatError, SerializedBiscuit> containerRes = copiedBiscuit.serializedBiscuit.append(keypair, block);
        if (containerRes.isLeft()) {
            Error.FormatError error = (Error.FormatError)containerRes.getLeft();
            throw error;
        }
        SerializedBiscuit container = (SerializedBiscuit)containerRes.get();
        SymbolTable symbols = new SymbolTable(copiedBiscuit.symbols);
        for (String string : block.symbols.symbols) {
            symbols.add(string);
        }
        ArrayList<org.biscuitsec.biscuit.token.Block> blocks = new ArrayList<org.biscuitsec.biscuit.token.Block>();
        for (org.biscuitsec.biscuit.token.Block b : copiedBiscuit.blocks) {
            blocks.add(b);
        }
        blocks.add(block);
        List<byte[]> list = container.revocation_identifiers();
        HashMap<Long, List<Long>> publicKeyToBlockId = new HashMap<Long, List<Long>>();
        publicKeyToBlockId.putAll(this.publicKeyToBlockId);
        return new UnverifiedBiscuit(copiedBiscuit.authority, blocks, symbols, container, publicKeyToBlockId, list);
    }

    public List<RevocationIdentifier> revocation_identifiers() {
        return this.revocation_ids.stream().map(RevocationIdentifier::from_bytes).collect(Collectors.toList());
    }

    public List<List<Check>> checks() {
        ArrayList<List<Check>> l = new ArrayList<List<Check>>();
        l.add(new ArrayList<Check>(this.authority.checks));
        for (org.biscuitsec.biscuit.token.Block b : this.blocks) {
            l.add(new ArrayList<Check>(b.checks));
        }
        return l;
    }

    public List<Option<String>> context() {
        ArrayList<Option<String>> res = new ArrayList<Option<String>>();
        if (this.authority.context.isEmpty()) {
            res.add(Option.none());
        } else {
            res.add(Option.some((Object)this.authority.context));
        }
        for (org.biscuitsec.biscuit.token.Block b : this.blocks) {
            if (b.context.isEmpty()) {
                res.add((Option<String>)Option.none());
                continue;
            }
            res.add((Option<String>)Option.some((Object)b.context));
        }
        return res;
    }

    public Option<Integer> root_key_id() {
        return this.root_key_id;
    }

    public String print() {
        StringBuilder s = new StringBuilder();
        s.append("UnverifiedBiscuit {\n\tsymbols: ");
        s.append(this.symbols.getAllSymbols());
        s.append("\n\tauthority: ");
        s.append(this.authority.print(this.symbols));
        s.append("\n\tblocks: [\n");
        for (org.biscuitsec.biscuit.token.Block b : this.blocks) {
            s.append("\t\t");
            s.append(b.print(this.symbols));
            s.append("\n");
        }
        s.append("\t]\n}");
        return s.toString();
    }

    public static SymbolTable default_symbol_table() {
        return new SymbolTable();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public UnverifiedBiscuit copy() throws Error {
        return UnverifiedBiscuit.from_bytes(this.serialize());
    }

    public Biscuit verify(PublicKey publicKey) throws Error, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        SerializedBiscuit serializedBiscuit = this.serializedBiscuit;
        serializedBiscuit.verify(publicKey);
        return Biscuit.from_serialized_biscuit(serializedBiscuit, this.symbols);
    }

    public Biscuit verify(KeyDelegate delegate) throws Error, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        SerializedBiscuit serializedBiscuit = this.serializedBiscuit;
        Option<PublicKey> root = delegate.root_key(this.root_key_id);
        if (root.isEmpty()) {
            throw new InvalidKeyException("unknown root key id");
        }
        serializedBiscuit.verify((PublicKey)root.get());
        return Biscuit.from_serialized_biscuit(serializedBiscuit, this.symbols);
    }
}

