/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token.builder;

import io.vavr.Tuple2;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.biscuitsec.biscuit.crypto.KeyPair;
import org.biscuitsec.biscuit.crypto.PublicKey;
import org.biscuitsec.biscuit.datalog.SchemaVersion;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.error.Error;
import org.biscuitsec.biscuit.token.Block;
import org.biscuitsec.biscuit.token.builder.Check;
import org.biscuitsec.biscuit.token.builder.Fact;
import org.biscuitsec.biscuit.token.builder.Rule;
import org.biscuitsec.biscuit.token.builder.Scope;
import org.biscuitsec.biscuit.token.builder.Utils;
import org.biscuitsec.biscuit.token.builder.parser.Error;
import org.biscuitsec.biscuit.token.builder.parser.Parser;

public class Biscuit {
    SecureRandom rng;
    KeyPair root;
    int symbol_start;
    int publicKeyStart;
    SymbolTable symbols;
    String context;
    List<org.biscuitsec.biscuit.datalog.Fact> facts;
    List<org.biscuitsec.biscuit.datalog.Rule> rules;
    List<org.biscuitsec.biscuit.datalog.Check> checks;
    List<org.biscuitsec.biscuit.datalog.Scope> scopes;
    Option<Integer> root_key_id;

    public Biscuit(SecureRandom rng, KeyPair root, SymbolTable base_symbols) {
        this.rng = rng;
        this.root = root;
        this.symbol_start = base_symbols.currentOffset();
        this.publicKeyStart = base_symbols.currentPublicKeyOffset();
        this.symbols = new SymbolTable(base_symbols);
        this.context = "";
        this.facts = new ArrayList<org.biscuitsec.biscuit.datalog.Fact>();
        this.rules = new ArrayList<org.biscuitsec.biscuit.datalog.Rule>();
        this.checks = new ArrayList<org.biscuitsec.biscuit.datalog.Check>();
        this.scopes = new ArrayList<org.biscuitsec.biscuit.datalog.Scope>();
        this.root_key_id = Option.none();
    }

    public Biscuit(SecureRandom rng, KeyPair root, Option<Integer> root_key_id, SymbolTable base_symbols) {
        this.rng = rng;
        this.root = root;
        this.symbol_start = base_symbols.symbols.size();
        this.symbols = new SymbolTable(base_symbols);
        this.context = "";
        this.facts = new ArrayList<org.biscuitsec.biscuit.datalog.Fact>();
        this.rules = new ArrayList<org.biscuitsec.biscuit.datalog.Rule>();
        this.checks = new ArrayList<org.biscuitsec.biscuit.datalog.Check>();
        this.scopes = new ArrayList<org.biscuitsec.biscuit.datalog.Scope>();
        this.root_key_id = root_key_id;
    }

    public Biscuit add_authority_fact(Fact f) throws Error.Language {
        f.validate();
        this.facts.add(f.convert(this.symbols));
        return this;
    }

    public Biscuit add_authority_fact(String s) throws Error.Parser, Error.Language {
        Either<Error, Tuple2<String, Fact>> res = Parser.fact(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_authority_fact((Fact)t._2);
    }

    public Biscuit add_authority_rule(Rule rule) {
        this.rules.add(rule.convert(this.symbols));
        return this;
    }

    public Biscuit add_authority_rule(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Rule>> res = Parser.rule(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_authority_rule((Rule)t._2);
    }

    public Biscuit add_authority_check(Check c) {
        this.checks.add(c.convert(this.symbols));
        return this;
    }

    public Biscuit add_authority_check(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Check>> res = Parser.check(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_authority_check((Check)t._2);
    }

    public Biscuit set_context(String context) {
        this.context = context;
        return this;
    }

    public Biscuit add_scope(Scope scope) {
        this.scopes.add(scope.convert(this.symbols));
        return this;
    }

    public void set_root_key_id(Integer i) {
        this.root_key_id = Option.some((Object)i);
    }

    public org.biscuitsec.biscuit.token.Biscuit build() throws org.biscuitsec.biscuit.error.Error {
        int i;
        SymbolTable base_symbols = new SymbolTable();
        SymbolTable symbols = new SymbolTable();
        for (i = 0; i < this.symbol_start; ++i) {
            base_symbols.add(this.symbols.symbols.get(i));
        }
        for (i = this.symbol_start; i < this.symbols.symbols.size(); ++i) {
            symbols.add(this.symbols.symbols.get(i));
        }
        ArrayList<PublicKey> publicKeys = new ArrayList<PublicKey>();
        for (int i2 = this.publicKeyStart; i2 < this.symbols.currentPublicKeyOffset(); ++i2) {
            publicKeys.add(this.symbols.publicKeys().get(i2));
        }
        SchemaVersion schemaVersion = new SchemaVersion(this.facts, this.rules, this.checks, this.scopes);
        Block authority_block = new Block(symbols, this.context, this.facts, this.rules, this.checks, this.scopes, publicKeys, (Option<PublicKey>)Option.none(), schemaVersion.version());
        if (this.root_key_id.isDefined()) {
            return org.biscuitsec.biscuit.token.Biscuit.make(this.rng, this.root, (Integer)this.root_key_id.get(), base_symbols, authority_block);
        }
        return org.biscuitsec.biscuit.token.Biscuit.make(this.rng, this.root, base_symbols, authority_block);
    }

    public Biscuit add_right(String resource, String right) throws Error.Language {
        return this.add_authority_fact(Utils.fact("right", Arrays.asList(Utils.string(resource), Utils.s(right))));
    }
}

