/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token.builder;

import io.vavr.Tuple2;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.biscuitsec.biscuit.crypto.PublicKey;
import org.biscuitsec.biscuit.datalog.Check;
import org.biscuitsec.biscuit.datalog.SchemaVersion;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.error.Error;
import org.biscuitsec.biscuit.token.builder.Check;
import org.biscuitsec.biscuit.token.builder.Expression;
import org.biscuitsec.biscuit.token.builder.Fact;
import org.biscuitsec.biscuit.token.builder.Rule;
import org.biscuitsec.biscuit.token.builder.Scope;
import org.biscuitsec.biscuit.token.builder.Utils;
import org.biscuitsec.biscuit.token.builder.parser.Error;
import org.biscuitsec.biscuit.token.builder.parser.Parser;

public class Block {
    long index;
    int symbol_start;
    int publicKeyStart;
    SymbolTable symbols;
    String context;
    List<org.biscuitsec.biscuit.datalog.Fact> facts;
    List<org.biscuitsec.biscuit.datalog.Rule> rules;
    List<org.biscuitsec.biscuit.datalog.Check> checks;
    List<org.biscuitsec.biscuit.datalog.Scope> scopes;

    public Block(long index, SymbolTable base_symbols) {
        this.index = index;
        this.symbol_start = base_symbols.currentOffset();
        this.publicKeyStart = base_symbols.currentPublicKeyOffset();
        this.symbols = new SymbolTable(base_symbols);
        this.context = "";
        this.facts = new ArrayList<org.biscuitsec.biscuit.datalog.Fact>();
        this.rules = new ArrayList<org.biscuitsec.biscuit.datalog.Rule>();
        this.checks = new ArrayList<org.biscuitsec.biscuit.datalog.Check>();
        this.scopes = new ArrayList<org.biscuitsec.biscuit.datalog.Scope>();
    }

    public Block add_fact(Fact f) {
        this.facts.add(f.convert(this.symbols));
        return this;
    }

    public Block add_fact(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Fact>> res = Parser.fact(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_fact((Fact)t._2);
    }

    public Block add_rule(Rule rule) {
        this.rules.add(rule.convert(this.symbols));
        return this;
    }

    public Block add_rule(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Rule>> res = Parser.rule(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_rule((Rule)t._2);
    }

    public Block add_check(Check check) {
        this.checks.add(check.convert(this.symbols));
        return this;
    }

    public Block add_check(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Check>> res = Parser.check(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_check((Check)t._2);
    }

    public Block add_scope(Scope scope) {
        this.scopes.add(scope.convert(this.symbols));
        return this;
    }

    public Block set_context(String context) {
        this.context = context;
        return this;
    }

    public org.biscuitsec.biscuit.token.Block build() {
        SymbolTable symbols = new SymbolTable();
        for (int i = this.symbol_start; i < this.symbols.symbols.size(); ++i) {
            symbols.add(this.symbols.symbols.get(i));
        }
        ArrayList<PublicKey> publicKeys = new ArrayList<PublicKey>();
        for (int i = this.publicKeyStart; i < this.symbols.currentPublicKeyOffset(); ++i) {
            publicKeys.add(this.symbols.publicKeys().get(i));
        }
        SchemaVersion schemaVersion = new SchemaVersion(this.facts, this.rules, this.checks, this.scopes);
        return new org.biscuitsec.biscuit.token.Block(symbols, this.context, this.facts, this.rules, this.checks, this.scopes, publicKeys, (Option<PublicKey>)Option.none(), schemaVersion.version());
    }

    public Block check_right(String right) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        queries.add(Utils.rule("check_right", Arrays.asList(Utils.s(right)), Arrays.asList(Utils.pred("resource", Arrays.asList(Utils.var("resource"))), Utils.pred("operation", Arrays.asList(Utils.s(right))), Utils.pred("right", Arrays.asList(Utils.var("resource"), Utils.s(right))))));
        return this.add_check(new Check(Check.Kind.One, queries));
    }

    public Block resource_prefix(String prefix) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        queries.add(Utils.constrained_rule("prefix", Arrays.asList(Utils.var("resource")), Arrays.asList(Utils.pred("resource", Arrays.asList(Utils.var("resource")))), Arrays.asList(new Expression.Binary(Expression.Op.Prefix, new Expression.Value(Utils.var("resource")), new Expression.Value(Utils.string(prefix))))));
        return this.add_check(new Check(Check.Kind.One, queries));
    }

    public Block resource_suffix(String suffix) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        queries.add(Utils.constrained_rule("suffix", Arrays.asList(Utils.var("resource")), Arrays.asList(Utils.pred("resource", Arrays.asList(Utils.var("resource")))), Arrays.asList(new Expression.Binary(Expression.Op.Suffix, new Expression.Value(Utils.var("resource")), new Expression.Value(Utils.string(suffix))))));
        return this.add_check(new Check(Check.Kind.One, queries));
    }

    public Block expiration_date(Date d) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        queries.add(Utils.constrained_rule("expiration", Arrays.asList(Utils.var("date")), Arrays.asList(Utils.pred("time", Arrays.asList(Utils.var("date")))), Arrays.asList(new Expression.Binary(Expression.Op.LessOrEqual, new Expression.Value(Utils.var("date")), new Expression.Value(Utils.date(d))))));
        return this.add_check(new Check(Check.Kind.One, queries));
    }
}

