/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token.builder;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.datalog.expressions.Op;
import org.biscuitsec.biscuit.token.builder.Term;

public abstract class Expression {
    public org.biscuitsec.biscuit.datalog.expressions.Expression convert(SymbolTable symbols) {
        ArrayList<org.biscuitsec.biscuit.datalog.expressions.Op> ops = new ArrayList<org.biscuitsec.biscuit.datalog.expressions.Op>();
        this.toOpcodes(symbols, ops);
        return new org.biscuitsec.biscuit.datalog.expressions.Expression(ops);
    }

    public static Expression convert_from(org.biscuitsec.biscuit.datalog.expressions.Expression e, SymbolTable symbols) {
        ArrayList ops = new ArrayList();
        ArrayDeque<Expression> stack = new ArrayDeque<Expression>(16);
        block28: for (org.biscuitsec.biscuit.datalog.expressions.Op op : e.getOps()) {
            org.biscuitsec.biscuit.datalog.expressions.Op v;
            if (op instanceof Op.Value) {
                v = (Op.Value)op;
                stack.push(new Value(Term.convert_from(((Op.Value)v).getValue(), symbols)));
                continue;
            }
            if (op instanceof Op.Unary) {
                v = (Op.Unary)op;
                Expression e1 = (Expression)stack.pop();
                switch (((Op.Unary)v).getOp()) {
                    case Length: {
                        stack.push(new Unary(Op.Length, e1));
                        break;
                    }
                    case Negate: {
                        stack.push(new Unary(Op.Negate, e1));
                        break;
                    }
                    case Parens: {
                        stack.push(new Unary(Op.Parens, e1));
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                continue;
            }
            if (!(op instanceof Op.Binary)) continue;
            v = (Op.Binary)op;
            Expression e2 = (Expression)stack.pop();
            Expression e1 = (Expression)stack.pop();
            switch (((Op.Binary)v).getOp()) {
                case LessThan: {
                    stack.push(new Binary(Op.LessThan, e1, e2));
                    continue block28;
                }
                case GreaterThan: {
                    stack.push(new Binary(Op.GreaterThan, e1, e2));
                    continue block28;
                }
                case LessOrEqual: {
                    stack.push(new Binary(Op.LessOrEqual, e1, e2));
                    continue block28;
                }
                case GreaterOrEqual: {
                    stack.push(new Binary(Op.GreaterOrEqual, e1, e2));
                    continue block28;
                }
                case Equal: {
                    stack.push(new Binary(Op.Equal, e1, e2));
                    continue block28;
                }
                case NotEqual: {
                    stack.push(new Binary(Op.NotEqual, e1, e2));
                    continue block28;
                }
                case Contains: {
                    stack.push(new Binary(Op.Contains, e1, e2));
                    continue block28;
                }
                case Prefix: {
                    stack.push(new Binary(Op.Prefix, e1, e2));
                    continue block28;
                }
                case Suffix: {
                    stack.push(new Binary(Op.Suffix, e1, e2));
                    continue block28;
                }
                case Regex: {
                    stack.push(new Binary(Op.Regex, e1, e2));
                    continue block28;
                }
                case Add: {
                    stack.push(new Binary(Op.Add, e1, e2));
                    continue block28;
                }
                case Sub: {
                    stack.push(new Binary(Op.Sub, e1, e2));
                    continue block28;
                }
                case Mul: {
                    stack.push(new Binary(Op.Mul, e1, e2));
                    continue block28;
                }
                case Div: {
                    stack.push(new Binary(Op.Div, e1, e2));
                    continue block28;
                }
                case And: {
                    stack.push(new Binary(Op.And, e1, e2));
                    continue block28;
                }
                case Or: {
                    stack.push(new Binary(Op.Or, e1, e2));
                    continue block28;
                }
                case Intersection: {
                    stack.push(new Binary(Op.Intersection, e1, e2));
                    continue block28;
                }
                case Union: {
                    stack.push(new Binary(Op.Union, e1, e2));
                    continue block28;
                }
                case BitwiseAnd: {
                    stack.push(new Binary(Op.BitwiseAnd, e1, e2));
                    continue block28;
                }
                case BitwiseOr: {
                    stack.push(new Binary(Op.BitwiseOr, e1, e2));
                    continue block28;
                }
                case BitwiseXor: {
                    stack.push(new Binary(Op.BitwiseXor, e1, e2));
                    continue block28;
                }
            }
            return null;
        }
        return (Expression)stack.pop();
    }

    public abstract void toOpcodes(SymbolTable var1, List<org.biscuitsec.biscuit.datalog.expressions.Op> var2);

    public abstract void gatherVariables(Set<String> var1);

    public static final class Binary
    extends Expression {
        private final Op op;
        private final Expression arg1;
        private final Expression arg2;

        public Binary(Op op, Expression arg1, Expression arg2) {
            this.op = op;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        @Override
        public void toOpcodes(SymbolTable symbols, List<org.biscuitsec.biscuit.datalog.expressions.Op> ops) {
            this.arg1.toOpcodes(symbols, ops);
            this.arg2.toOpcodes(symbols, ops);
            switch (this.op) {
                case LessThan: {
                    ops.add(new Op.Binary(Op.BinaryOp.LessThan));
                    break;
                }
                case GreaterThan: {
                    ops.add(new Op.Binary(Op.BinaryOp.GreaterThan));
                    break;
                }
                case LessOrEqual: {
                    ops.add(new Op.Binary(Op.BinaryOp.LessOrEqual));
                    break;
                }
                case GreaterOrEqual: {
                    ops.add(new Op.Binary(Op.BinaryOp.GreaterOrEqual));
                    break;
                }
                case Equal: {
                    ops.add(new Op.Binary(Op.BinaryOp.Equal));
                    break;
                }
                case NotEqual: {
                    ops.add(new Op.Binary(Op.BinaryOp.NotEqual));
                    break;
                }
                case Contains: {
                    ops.add(new Op.Binary(Op.BinaryOp.Contains));
                    break;
                }
                case Prefix: {
                    ops.add(new Op.Binary(Op.BinaryOp.Prefix));
                    break;
                }
                case Suffix: {
                    ops.add(new Op.Binary(Op.BinaryOp.Suffix));
                    break;
                }
                case Regex: {
                    ops.add(new Op.Binary(Op.BinaryOp.Regex));
                    break;
                }
                case Add: {
                    ops.add(new Op.Binary(Op.BinaryOp.Add));
                    break;
                }
                case Sub: {
                    ops.add(new Op.Binary(Op.BinaryOp.Sub));
                    break;
                }
                case Mul: {
                    ops.add(new Op.Binary(Op.BinaryOp.Mul));
                    break;
                }
                case Div: {
                    ops.add(new Op.Binary(Op.BinaryOp.Div));
                    break;
                }
                case And: {
                    ops.add(new Op.Binary(Op.BinaryOp.And));
                    break;
                }
                case Or: {
                    ops.add(new Op.Binary(Op.BinaryOp.Or));
                    break;
                }
                case Intersection: {
                    ops.add(new Op.Binary(Op.BinaryOp.Intersection));
                    break;
                }
                case Union: {
                    ops.add(new Op.Binary(Op.BinaryOp.Union));
                    break;
                }
                case BitwiseAnd: {
                    ops.add(new Op.Binary(Op.BinaryOp.BitwiseAnd));
                    break;
                }
                case BitwiseOr: {
                    ops.add(new Op.Binary(Op.BinaryOp.BitwiseOr));
                    break;
                }
                case BitwiseXor: {
                    ops.add(new Op.Binary(Op.BinaryOp.BitwiseXor));
                }
            }
        }

        @Override
        public void gatherVariables(Set<String> variables) {
            this.arg1.gatherVariables(variables);
            this.arg2.gatherVariables(variables);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Binary binary = (Binary)o;
            if (this.op != binary.op) {
                return false;
            }
            if (!this.arg1.equals(binary.arg1)) {
                return false;
            }
            return this.arg2.equals(binary.arg2);
        }

        public int hashCode() {
            int result = this.op.hashCode();
            result = 31 * result + this.arg1.hashCode();
            result = 31 * result + this.arg2.hashCode();
            return result;
        }

        public String toString() {
            switch (this.op) {
                case LessThan: {
                    return this.arg1.toString() + " < " + this.arg2.toString();
                }
                case GreaterThan: {
                    return this.arg1.toString() + " > " + this.arg2.toString();
                }
                case LessOrEqual: {
                    return this.arg1.toString() + " <= " + this.arg2.toString();
                }
                case GreaterOrEqual: {
                    return this.arg1.toString() + " >= " + this.arg2.toString();
                }
                case Equal: {
                    return this.arg1.toString() + " == " + this.arg2.toString();
                }
                case NotEqual: {
                    return this.arg1.toString() + " != " + this.arg2.toString();
                }
                case Contains: {
                    return this.arg1.toString() + ".contains(" + this.arg2.toString() + ")";
                }
                case Prefix: {
                    return this.arg1.toString() + ".starts_with(" + this.arg2.toString() + ")";
                }
                case Suffix: {
                    return this.arg1.toString() + ".ends_with(" + this.arg2.toString() + ")";
                }
                case Regex: {
                    return this.arg1.toString() + ".matches(" + this.arg2.toString() + ")";
                }
                case Add: {
                    return this.arg1.toString() + " + " + this.arg2.toString();
                }
                case Sub: {
                    return this.arg1.toString() + " - " + this.arg2.toString();
                }
                case Mul: {
                    return this.arg1.toString() + " * " + this.arg2.toString();
                }
                case Div: {
                    return this.arg1.toString() + " / " + this.arg2.toString();
                }
                case And: {
                    return this.arg1.toString() + " && " + this.arg2.toString();
                }
                case Or: {
                    return this.arg1.toString() + " || " + this.arg2.toString();
                }
                case Intersection: {
                    return this.arg1.toString() + ".intersection(" + this.arg2.toString() + ")";
                }
                case Union: {
                    return this.arg1.toString() + ".union(" + this.arg2.toString() + ")";
                }
                case BitwiseAnd: {
                    return this.arg1.toString() + " & " + this.arg2.toString();
                }
                case BitwiseOr: {
                    return this.arg1.toString() + " | " + this.arg2.toString();
                }
                case BitwiseXor: {
                    return this.arg1.toString() + " ^ " + this.arg2.toString();
                }
            }
            return "";
        }
    }

    public static final class Unary
    extends Expression {
        private final Op op;
        private final Expression arg1;

        public Unary(Op op, Expression arg1) {
            this.op = op;
            this.arg1 = arg1;
        }

        @Override
        public void toOpcodes(SymbolTable symbols, List<org.biscuitsec.biscuit.datalog.expressions.Op> ops) {
            this.arg1.toOpcodes(symbols, ops);
            switch (this.op) {
                case Negate: {
                    ops.add(new Op.Unary(Op.UnaryOp.Negate));
                    break;
                }
                case Parens: {
                    ops.add(new Op.Unary(Op.UnaryOp.Parens));
                    break;
                }
                case Length: {
                    ops.add(new Op.Unary(Op.UnaryOp.Length));
                }
            }
        }

        @Override
        public void gatherVariables(Set<String> variables) {
            this.arg1.gatherVariables(variables);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Unary unary = (Unary)o;
            if (this.op != unary.op) {
                return false;
            }
            return this.arg1.equals(unary.arg1);
        }

        public int hashCode() {
            int result = this.op.hashCode();
            result = 31 * result + this.arg1.hashCode();
            return result;
        }

        public String toString() {
            switch (this.op) {
                case Negate: {
                    return "!" + this.arg1;
                }
                case Parens: {
                    return "(" + this.arg1 + ")";
                }
                case Length: {
                    return this.arg1.toString() + ".length()";
                }
            }
            return "";
        }
    }

    public static final class Value
    extends Expression {
        public final Term value;

        public Value(Term value) {
            this.value = value;
        }

        @Override
        public void toOpcodes(SymbolTable symbols, List<org.biscuitsec.biscuit.datalog.expressions.Op> ops) {
            ops.add(new Op.Value(this.value.convert(symbols)));
        }

        @Override
        public void gatherVariables(Set<String> variables) {
            if (this.value instanceof Term.Variable) {
                variables.add(((Term.Variable)this.value).value);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value1 = (Value)o;
            return this.value != null ? this.value.equals(value1.value) : value1.value == null;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static enum Op {
        Negate,
        Parens,
        LessThan,
        GreaterThan,
        LessOrEqual,
        GreaterOrEqual,
        Equal,
        NotEqual,
        Contains,
        Prefix,
        Suffix,
        Regex,
        Add,
        Sub,
        Mul,
        Div,
        And,
        Or,
        Length,
        Intersection,
        Union,
        BitwiseAnd,
        BitwiseOr,
        BitwiseXor;

    }
}

