/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token.builder;

import io.vavr.control.Option;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.error.Error;
import org.biscuitsec.biscuit.error.FailedCheck;
import org.biscuitsec.biscuit.token.builder.Predicate;
import org.biscuitsec.biscuit.token.builder.Term;

public class Fact
implements Cloneable {
    Predicate predicate;
    Option<Map<String, Option<Term>>> variables;

    public Fact(String name, List<Term> terms) {
        HashMap<String, Option> variables = new HashMap<String, Option>();
        for (Term term : terms) {
            if (!(term instanceof Term.Variable)) continue;
            variables.put(((Term.Variable)term).value, Option.none());
        }
        this.predicate = new Predicate(name, terms);
        this.variables = Option.some(variables);
    }

    public Fact(Predicate p) {
        this.predicate = p;
        this.variables = Option.none();
    }

    private Fact(Predicate predicate, Option<Map<String, Option<Term>>> variables) {
        this.predicate = predicate;
        this.variables = variables;
    }

    public void validate() throws Error.Language {
        List<String> invalid_variables;
        if (!this.variables.isEmpty() && !(invalid_variables = ((Map)this.variables.get()).entrySet().stream().flatMap(e -> {
            if (((Option)e.getValue()).isEmpty()) {
                return Stream.of((String)e.getKey());
            }
            return Stream.empty();
        }).collect(Collectors.toList())).isEmpty()) {
            throw new Error.Language(new FailedCheck.LanguageError.Builder(invalid_variables));
        }
    }

    public Fact set(String name, Term term) throws Error.Language {
        if (this.variables.isEmpty()) {
            throw new Error.Language(new FailedCheck.LanguageError.UnknownVariable(name));
        }
        Map _variables = (Map)this.variables.get();
        Option r = (Option)_variables.get(name);
        if (r == null) {
            throw new Error.Language(new FailedCheck.LanguageError.UnknownVariable(name));
        }
        _variables.put(name, Option.some((Object)term));
        return this;
    }

    public Fact apply_variables() {
        this.variables.forEach(_variables -> {
            this.predicate.terms = this.predicate.terms.stream().flatMap(t -> {
                if (t instanceof Term.Variable) {
                    Option term = _variables.getOrDefault(((Term.Variable)t).value, Option.none());
                    return (Stream)term.map(_t -> Stream.of(_t)).getOrElse(Stream.empty());
                }
                return Stream.of(t);
            }).collect(Collectors.toList());
        });
        return this;
    }

    public org.biscuitsec.biscuit.datalog.Fact convert(SymbolTable symbols) {
        Fact f = this.clone();
        f.apply_variables();
        return new org.biscuitsec.biscuit.datalog.Fact(f.predicate.convert(symbols));
    }

    public static Fact convert_from(org.biscuitsec.biscuit.datalog.Fact f, SymbolTable symbols) {
        return new Fact(Predicate.convert_from(f.predicate(), symbols));
    }

    public String toString() {
        Fact f = this.clone();
        f.apply_variables();
        return f.predicate.toString();
    }

    public String name() {
        return this.predicate.name;
    }

    public List<Term> terms() {
        return this.predicate.terms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fact fact = (Fact)o;
        return this.predicate != null ? this.predicate.equals(fact.predicate) : fact.predicate == null;
    }

    public int hashCode() {
        return this.predicate != null ? this.predicate.hashCode() : 0;
    }

    public Fact clone() {
        Predicate p = this.predicate.clone();
        Option variables = this.variables.map(_v -> {
            HashMap m = new HashMap();
            m.putAll(_v);
            return m;
        });
        return new Fact(p, (Option<Map<String, Option<Term>>>)variables);
    }
}

