/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.token.builder.Term;

public class Predicate
implements Cloneable {
    String name;
    List<Term> terms;

    public Predicate(String name, List<Term> terms) {
        this.name = name;
        this.terms = terms;
    }

    public String getName() {
        return this.name;
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public org.biscuitsec.biscuit.datalog.Predicate convert(SymbolTable symbols) {
        long name = symbols.insert(this.name);
        ArrayList<org.biscuitsec.biscuit.datalog.Term> terms = new ArrayList<org.biscuitsec.biscuit.datalog.Term>();
        for (Term a : this.terms) {
            terms.add(a.convert(symbols));
        }
        return new org.biscuitsec.biscuit.datalog.Predicate(name, terms);
    }

    public static Predicate convert_from(org.biscuitsec.biscuit.datalog.Predicate p, SymbolTable symbols) {
        String name = symbols.print_symbol((int)p.name());
        ArrayList<Term> terms = new ArrayList<Term>();
        for (org.biscuitsec.biscuit.datalog.Term t : p.terms()) {
            terms.add(t.toTerm(symbols));
        }
        return new Predicate(name, terms);
    }

    public String toString() {
        List i = this.terms.stream().map(term -> term.toString()).collect(Collectors.toList());
        return this.name + "(" + String.join((CharSequence)", ", i) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Predicate predicate = (Predicate)o;
        if (this.name != null ? !this.name.equals(predicate.name) : predicate.name != null) {
            return false;
        }
        return this.terms != null ? this.terms.equals(predicate.terms) : predicate.terms == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.terms != null ? this.terms.hashCode() : 0);
        return result;
    }

    public Predicate clone() {
        String name = this.name;
        ArrayList<Term> terms = new ArrayList<Term>(this.terms.size());
        terms.addAll(this.terms);
        Predicate p = new Predicate(name, terms);
        return p;
    }
}

