/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token.builder;

import java.util.Objects;
import org.biscuitsec.biscuit.crypto.PublicKey;
import org.biscuitsec.biscuit.datalog.SymbolTable;

public class Scope {
    Kind kind;
    PublicKey publicKey;
    String parameter;

    private Scope(Kind kind) {
        this.kind = kind;
        this.publicKey = null;
        this.parameter = "";
    }

    private Scope(Kind kind, PublicKey publicKey) {
        this.kind = kind;
        this.publicKey = publicKey;
        this.parameter = "";
    }

    private Scope(Kind kind, String parameter) {
        this.kind = kind;
        this.publicKey = null;
        this.parameter = parameter;
    }

    public static Scope authority() {
        return new Scope(Kind.Authority);
    }

    public static Scope previous() {
        return new Scope(Kind.Previous);
    }

    public static Scope publicKey(PublicKey publicKey) {
        return new Scope(Kind.PublicKey, publicKey);
    }

    public static Scope parameter(String parameter) {
        return new Scope(Kind.Parameter, parameter);
    }

    public org.biscuitsec.biscuit.datalog.Scope convert(SymbolTable symbols) {
        switch (this.kind) {
            case Authority: {
                return org.biscuitsec.biscuit.datalog.Scope.authority();
            }
            case Previous: {
                return org.biscuitsec.biscuit.datalog.Scope.previous();
            }
            case Parameter: {
                return null;
            }
            case PublicKey: {
                return org.biscuitsec.biscuit.datalog.Scope.publicKey(symbols.insert(this.publicKey));
            }
        }
        return null;
    }

    public static Scope convert_from(org.biscuitsec.biscuit.datalog.Scope scope, SymbolTable symbols) {
        switch (scope.kind()) {
            case Authority: {
                return new Scope(Kind.Authority);
            }
            case Previous: {
                return new Scope(Kind.Previous);
            }
            case PublicKey: {
                return new Scope(Kind.PublicKey, (PublicKey)symbols.get_pk((int)scope.publicKey()).get());
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scope scope = (Scope)o;
        if (this.kind != scope.kind) {
            return false;
        }
        if (!Objects.equals(this.publicKey, scope.publicKey)) {
            return false;
        }
        return Objects.equals(this.parameter, scope.parameter);
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = 31 * result + (this.publicKey != null ? this.publicKey.hashCode() : 0);
        result = 31 * result + (this.parameter != null ? this.parameter.hashCode() : 0);
        return result;
    }

    public String toString() {
        switch (this.kind) {
            case Authority: {
                return "authority";
            }
            case Previous: {
                return "previous";
            }
            case Parameter: {
                return "{" + this.parameter + "}";
            }
            case PublicKey: {
                return this.publicKey.toString();
            }
        }
        return null;
    }

    static enum Kind {
        Authority,
        Previous,
        PublicKey,
        Parameter;

    }
}

