/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token.builder.parser;

import biscuit.format.schema.Schema;
import io.vavr.Tuple2;
import io.vavr.Tuple4;
import io.vavr.control.Either;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.biscuitsec.biscuit.crypto.PublicKey;
import org.biscuitsec.biscuit.datalog.Check;
import org.biscuitsec.biscuit.token.Policy;
import org.biscuitsec.biscuit.token.builder.Check;
import org.biscuitsec.biscuit.token.builder.Expression;
import org.biscuitsec.biscuit.token.builder.Fact;
import org.biscuitsec.biscuit.token.builder.Predicate;
import org.biscuitsec.biscuit.token.builder.Rule;
import org.biscuitsec.biscuit.token.builder.Scope;
import org.biscuitsec.biscuit.token.builder.Term;
import org.biscuitsec.biscuit.token.builder.Utils;
import org.biscuitsec.biscuit.token.builder.parser.Error;
import org.biscuitsec.biscuit.token.builder.parser.ExpressionParser;

public class Parser {
    public static Either<Error, Tuple2<String, Fact>> fact(String s) {
        Either<Error, Tuple2<String, Predicate>> res = Parser.fact_predicate(s);
        if (res.isLeft()) {
            return Either.left((Object)((Error)res.getLeft()));
        }
        Tuple2 t = (Tuple2)res.get();
        if (!((String)t._1).isEmpty()) {
            return Either.left((Object)new Error(s, "the string was not entirely parsed, remaining: " + (String)t._1));
        }
        return Either.right((Object)new Tuple2((Object)((String)t._1), (Object)new Fact((Predicate)t._2)));
    }

    public static Either<Error, Tuple2<String, Rule>> rule(String s) {
        Either<Error, Tuple2<String, Predicate>> res0 = Parser.predicate(s);
        if (res0.isLeft()) {
            return Either.left((Object)((Error)res0.getLeft()));
        }
        Tuple2 t0 = (Tuple2)res0.get();
        s = (String)t0._1;
        Predicate head = (Predicate)t0._2;
        if ((s = Parser.space(s)).length() < 2 || s.charAt(0) != '<' || s.charAt(1) != '-') {
            return Either.left((Object)new Error(s, "rule arrow not found"));
        }
        ArrayList predicates = new ArrayList();
        Either<Error, Tuple4<String, List<Predicate>, List<Expression>, List<Scope>>> bodyRes = Parser.rule_body(s = s.substring(2));
        if (bodyRes.isLeft()) {
            return Either.left((Object)((Error)bodyRes.getLeft()));
        }
        Tuple4 body = (Tuple4)bodyRes.get();
        if (!((String)body._1).isEmpty()) {
            return Either.left((Object)new Error(s, "the string was not entirely parsed, remaining: " + (String)body._1));
        }
        Rule rule = new Rule(head, (List)body._2, (List)body._3, (List)body._4);
        Either<String, Rule> valid = rule.validate_variables();
        if (valid.isLeft()) {
            return Either.left((Object)new Error(s, (String)valid.getLeft()));
        }
        return Either.right((Object)new Tuple2((Object)((String)body._1), (Object)rule));
    }

    public static Either<Error, Tuple2<String, Check>> check(String s) {
        Check.Kind kind;
        if (s.startsWith("check if")) {
            kind = Check.Kind.One;
            s = s.substring("check if".length());
        } else if (s.startsWith("check all")) {
            kind = Check.Kind.All;
            s = s.substring("check all".length());
        } else {
            return Either.left((Object)new Error(s, "missing check prefix"));
        }
        ArrayList queries = new ArrayList();
        Either<Error, Tuple2<String, List<Rule>>> bodyRes = Parser.check_body(s);
        if (bodyRes.isLeft()) {
            return Either.left((Object)((Error)bodyRes.getLeft()));
        }
        Tuple2 t = (Tuple2)bodyRes.get();
        if (!((String)t._1).isEmpty()) {
            return Either.left((Object)new Error(s, "the string was not entirely parsed, remaining: " + (String)t._1));
        }
        return Either.right((Object)new Tuple2((Object)((String)t._1), (Object)new Check(kind, (List)t._2)));
    }

    public static Either<Error, Tuple2<String, Policy>> policy(String s) {
        Policy.Kind p = Policy.Kind.Allow;
        String allow = "allow if";
        String deny = "deny if";
        if (s.startsWith(allow)) {
            s = s.substring(allow.length());
        } else if (s.startsWith(deny)) {
            p = Policy.Kind.Deny;
            s = s.substring(deny.length());
        } else {
            return Either.left((Object)new Error(s, "missing policy prefix"));
        }
        ArrayList queries = new ArrayList();
        Either<Error, Tuple2<String, List<Rule>>> bodyRes = Parser.check_body(s);
        if (bodyRes.isLeft()) {
            return Either.left((Object)((Error)bodyRes.getLeft()));
        }
        Tuple2 t = (Tuple2)bodyRes.get();
        if (!((String)t._1).isEmpty()) {
            return Either.left((Object)new Error(s, "the string was not entirely parsed, remaining: " + (String)t._1));
        }
        return Either.right((Object)new Tuple2((Object)((String)t._1), (Object)new Policy((List)t._2, p)));
    }

    public static Either<Error, Tuple2<String, List<Rule>>> check_body(String s) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        Either<Error, Tuple4<String, List<Predicate>, List<Expression>, List<Scope>>> bodyRes = Parser.rule_body(s);
        if (bodyRes.isLeft()) {
            return Either.left((Object)((Error)bodyRes.getLeft()));
        }
        Tuple4 body = (Tuple4)bodyRes.get();
        s = (String)body._1;
        queries.add(new Rule(new Predicate("query", new ArrayList<Term>()), (List)body._2, (List)body._3, (List)body._4));
        boolean i = false;
        while (s.length() != 0 && (s = Parser.space(s)).startsWith("or")) {
            Either<Error, Tuple4<String, List<Predicate>, List<Expression>, List<Scope>>> bodyRes2 = Parser.rule_body(s = s.substring(2));
            if (bodyRes2.isLeft()) {
                return Either.left((Object)((Error)bodyRes2.getLeft()));
            }
            Tuple4 body2 = (Tuple4)bodyRes2.get();
            s = (String)body2._1;
            queries.add(new Rule(new Predicate("query", new ArrayList<Term>()), (List)body2._2, (List)body2._3, (List)body2._4));
        }
        return Either.right((Object)new Tuple2((Object)s, queries));
    }

    public static Either<Error, Tuple4<String, List<Predicate>, List<Expression>, List<Scope>>> rule_body(String s) {
        Tuple2 t;
        Object res;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        while (true) {
            if ((res = Parser.predicate(s = Parser.space(s))).isRight()) {
                t = (Tuple2)res.get();
                s = (String)t._1;
                predicates.add((Predicate)t._2);
            } else {
                Either<Error, Tuple2<String, Expression>> res2 = Parser.expression(s);
                if (!res2.isRight()) break;
                Tuple2 t2 = (Tuple2)res2.get();
                s = (String)t2._1;
                expressions.add((Expression)t2._2);
            }
            s = Parser.space(s);
            if (s.length() == 0 || s.charAt(0) != ',') break;
            s = s.substring(1);
        }
        if ((res = Parser.scopes(s)).isLeft()) {
            return Either.right((Object)new Tuple4((Object)s, predicates, expressions, new ArrayList()));
        }
        t = (Tuple2)res.get();
        return Either.right((Object)new Tuple4((Object)((String)t._1), predicates, expressions, (Object)((List)t._2)));
    }

    public static Either<Error, Tuple2<String, Predicate>> predicate(String s) {
        Either<Error, Tuple2<String, Term>> res;
        Tuple2<String, String> tn = Parser.take_while(s, c -> Character.isAlphabetic(c.charValue()) || Character.isDigit(c.charValue()) || c.charValue() == '_' || c.charValue() == ':');
        String name = (String)tn._1;
        s = (String)tn._2;
        if ((s = Parser.space(s)).length() == 0 || s.charAt(0) != '(') {
            return Either.left((Object)new Error(s, "opening parens not found for predicate " + name));
        }
        s = s.substring(1);
        ArrayList<Term> terms = new ArrayList<Term>();
        while (!(res = Parser.term(s = Parser.space(s))).isLeft()) {
            Tuple2 t = (Tuple2)res.get();
            s = (String)t._1;
            terms.add((Term)t._2);
            s = Parser.space(s);
            if (s.length() == 0 || s.charAt(0) != ',') break;
            s = s.substring(1);
        }
        s = Parser.space(s);
        if (0 == s.length() || s.charAt(0) != ')') {
            return Either.left((Object)new Error(s, "closing parens not found"));
        }
        String remaining = s.substring(1);
        return Either.right((Object)new Tuple2((Object)remaining, (Object)new Predicate(name, terms)));
    }

    public static Either<Error, Tuple2<String, List<Scope>>> scopes(String s) {
        Either<Error, Tuple2<String, Scope>> res;
        if (!s.startsWith("trusting")) {
            return Either.left((Object)new Error(s, "missing scopes prefix"));
        }
        s = s.substring("trusting".length());
        s = Parser.space(s);
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        while (!(res = Parser.scope(s = Parser.space(s))).isLeft()) {
            Tuple2 t = (Tuple2)res.get();
            s = (String)t._1;
            scopes.add((Scope)t._2);
            s = Parser.space(s);
            if (s.length() == 0 || s.charAt(0) != ',') break;
            s = s.substring(1);
        }
        return Either.right((Object)new Tuple2((Object)s, scopes));
    }

    public static Either<Error, Tuple2<String, Scope>> scope(String s) {
        if (s.startsWith("authority")) {
            s = s.substring("authority".length());
            return Either.right((Object)new Tuple2((Object)s, (Object)Scope.authority()));
        }
        if (s.startsWith("previous")) {
            s = s.substring("previous".length());
            return Either.right((Object)new Tuple2((Object)s, (Object)Scope.previous()));
        }
        if (0 < s.length() && s.charAt(0) == '{') {
            String remaining = s.substring(1);
            Either<Error, Tuple2<String, String>> res = Parser.name(remaining);
            if (res.isLeft()) {
                return Either.left((Object)new Error(s, "unrecognized parameter"));
            }
            Tuple2 t = (Tuple2)res.get();
            if (0 < s.length() && s.charAt(0) == '}') {
                return Either.right((Object)new Tuple2(t._1, (Object)Scope.parameter((String)t._2)));
            }
            return Either.left((Object)new Error(s, "unrecognized parameter end"));
        }
        Either<Error, Tuple2<String, PublicKey>> res2 = Parser.publicKey(s);
        if (res2.isLeft()) {
            return Either.left((Object)new Error(s, "unrecognized public key"));
        }
        Tuple2 t = (Tuple2)res2.get();
        return Either.right((Object)new Tuple2(t._1, (Object)Scope.publicKey((PublicKey)t._2)));
    }

    public static Either<Error, Tuple2<String, PublicKey>> publicKey(String s) {
        if (!s.startsWith("ed25519/")) {
            return Either.left((Object)new Error(s, "unrecognized public key prefix"));
        }
        s = s.substring("ed25519/".length());
        Tuple2<String, byte[]> t = Parser.hex(s);
        return Either.right((Object)new Tuple2(t._1, (Object)new PublicKey(Schema.PublicKey.Algorithm.Ed25519, (byte[])t._2)));
    }

    public static Either<Error, Tuple2<String, Predicate>> fact_predicate(String s) {
        Either<Error, Tuple2<String, Term>> res;
        Tuple2<String, String> tn = Parser.take_while(s, c -> Character.isAlphabetic(c.charValue()) || Character.isDigit(c.charValue()) || c.charValue() == '_' || c.charValue() == ':');
        String name = (String)tn._1;
        s = (String)tn._2;
        if ((s = Parser.space(s)).length() == 0 || s.charAt(0) != '(') {
            return Either.left((Object)new Error(s, "opening parens not found for fact " + name));
        }
        s = s.substring(1);
        ArrayList<Term> terms = new ArrayList<Term>();
        while (!(res = Parser.fact_term(s = Parser.space(s))).isLeft()) {
            Tuple2 t = (Tuple2)res.get();
            s = (String)t._1;
            terms.add((Term)t._2);
            s = Parser.space(s);
            if (s.length() == 0 || s.charAt(0) != ',') break;
            s = s.substring(1);
        }
        s = Parser.space(s);
        if (0 == s.length() || s.charAt(0) != ')') {
            return Either.left((Object)new Error(s, "closing parens not found"));
        }
        String remaining = s.substring(1);
        return Either.right((Object)new Tuple2((Object)remaining, (Object)new Predicate(name, terms)));
    }

    public static Either<Error, Tuple2<String, String>> name(String s) {
        Tuple2<String, String> t = Parser.take_while(s, c -> Character.isAlphabetic(c.charValue()) || c.charValue() == '_');
        String name = (String)t._1;
        String remaining = (String)t._2;
        return Either.right((Object)new Tuple2((Object)remaining, (Object)name));
    }

    public static Either<Error, Tuple2<String, Term>> term(String s) {
        Either<Error, Tuple2<String, Term.Variable>> res5 = Parser.variable(s);
        if (res5.isRight()) {
            Tuple2 t = (Tuple2)res5.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        Either<Error, Tuple2<String, Term.Str>> res2 = Parser.string(s);
        if (res2.isRight()) {
            Tuple2 t = (Tuple2)res2.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        Either<Error, Tuple2<String, Term.Set>> res7 = Parser.set(s);
        if (res7.isRight()) {
            Tuple2 t = (Tuple2)res7.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        Either<Error, Tuple2<String, Term.Bool>> res6 = Parser.bool(s);
        if (res6.isRight()) {
            Tuple2 t = (Tuple2)res6.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        Either<Error, Tuple2<String, Term.Date>> res4 = Parser.date(s);
        if (res4.isRight()) {
            Tuple2 t = (Tuple2)res4.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        Either<Error, Tuple2<String, Term.Integer>> res3 = Parser.integer(s);
        if (res3.isRight()) {
            Tuple2 t = (Tuple2)res3.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        Either<Error, Tuple2<String, Term.Bytes>> res8 = Parser.bytes(s);
        if (res8.isRight()) {
            Tuple2 t = (Tuple2)res8.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        return Either.left((Object)new Error(s, "unrecognized value"));
    }

    public static Either<Error, Tuple2<String, Term>> fact_term(String s) {
        if (s.length() > 0 && s.charAt(0) == '$') {
            return Either.left((Object)new Error(s, "variables are not allowed in facts"));
        }
        Either<Error, Tuple2<String, Term.Str>> res2 = Parser.string(s);
        if (res2.isRight()) {
            Tuple2 t = (Tuple2)res2.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        Either<Error, Tuple2<String, Term.Set>> res7 = Parser.set(s);
        if (res7.isRight()) {
            Tuple2 t = (Tuple2)res7.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        Either<Error, Tuple2<String, Term.Bool>> res6 = Parser.bool(s);
        if (res6.isRight()) {
            Tuple2 t = (Tuple2)res6.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        Either<Error, Tuple2<String, Term.Date>> res4 = Parser.date(s);
        if (res4.isRight()) {
            Tuple2 t = (Tuple2)res4.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        Either<Error, Tuple2<String, Term.Integer>> res3 = Parser.integer(s);
        if (res3.isRight()) {
            Tuple2 t = (Tuple2)res3.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        Either<Error, Tuple2<String, Term.Bytes>> res8 = Parser.bytes(s);
        if (res8.isRight()) {
            Tuple2 t = (Tuple2)res8.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        return Either.left((Object)new Error(s, "unrecognized value"));
    }

    public static Either<Error, Tuple2<String, Term.Str>> string(String s) {
        if (s.charAt(0) != '\"') {
            return Either.left((Object)new Error(s, "not a string"));
        }
        int index = s.length();
        for (int i = 1; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' && s.charAt(i + 1) == '\"') {
                ++i;
                continue;
            }
            if (c != '\"') continue;
            index = i - 1;
            break;
        }
        if (index == s.length()) {
            return Either.left((Object)new Error(s, "end of string not found"));
        }
        if (s.charAt(index + 1) != '\"') {
            return Either.left((Object)new Error(s, "ending double quote not found"));
        }
        String string = s.substring(1, index + 1);
        String remaining = s.substring(index + 2);
        return Either.right((Object)new Tuple2((Object)remaining, (Object)((Term.Str)Utils.string(string))));
    }

    public static Either<Error, Tuple2<String, Term.Integer>> integer(String s) {
        int index = 0;
        if (s.charAt(0) == '-') {
            ++index;
        }
        int index2 = s.length();
        for (int i = index; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) continue;
            index2 = i;
            break;
        }
        if (index2 == 0) {
            return Either.left((Object)new Error(s, "not an integer"));
        }
        Integer i = Integer.parseInt(s.substring(0, index2));
        String remaining = s.substring(index2);
        return Either.right((Object)new Tuple2((Object)remaining, (Object)((Term.Integer)Utils.integer(i.intValue()))));
    }

    public static Either<Error, Tuple2<String, Term.Date>> date(String s) {
        Tuple2<String, String> t = Parser.take_while(s, c -> c.charValue() != ' ' && c.charValue() != ',' && c.charValue() != ')');
        try {
            OffsetDateTime d = OffsetDateTime.parse((CharSequence)t._1);
            String remaining = (String)t._2;
            return Either.right((Object)new Tuple2((Object)remaining, (Object)new Term.Date(d.toEpochSecond())));
        }
        catch (DateTimeParseException e) {
            return Either.left((Object)new Error(s, "not a date"));
        }
    }

    public static Either<Error, Tuple2<String, Term.Variable>> variable(String s) {
        if (s.charAt(0) != '$') {
            return Either.left((Object)new Error(s, "not a variable"));
        }
        Tuple2<String, String> t = Parser.take_while(s.substring(1), c -> Character.isAlphabetic(c.charValue()) || Character.isDigit(c.charValue()) || c.charValue() == '_');
        return Either.right((Object)new Tuple2((Object)((String)t._2), (Object)((Term.Variable)Utils.var((String)t._1))));
    }

    public static Either<Error, Tuple2<String, Term.Bool>> bool(String s) {
        boolean b;
        if (s.startsWith("true")) {
            b = true;
            s = s.substring(4);
        } else if (s.startsWith("false")) {
            b = false;
            s = s.substring(5);
        } else {
            return Either.left((Object)new Error(s, "not a boolean"));
        }
        return Either.right((Object)new Tuple2((Object)s, (Object)new Term.Bool(b)));
    }

    public static Either<Error, Tuple2<String, Term.Set>> set(String s) {
        Either<Error, Tuple2<String, Term>> res;
        if (s.length() == 0 || s.charAt(0) != '[') {
            return Either.left((Object)new Error(s, "not a set"));
        }
        s = s.substring(1);
        HashSet<Term> terms = new HashSet<Term>();
        while (!(res = Parser.fact_term(s = Parser.space(s))).isLeft()) {
            Tuple2 t = (Tuple2)res.get();
            if (t._2 instanceof Term.Variable) {
                return Either.left((Object)new Error(s, "sets cannot contain variables"));
            }
            s = (String)t._1;
            terms.add((Term)t._2);
            s = Parser.space(s);
            if (s.length() == 0 || s.charAt(0) != ',') break;
            s = s.substring(1);
        }
        s = Parser.space(s);
        if (0 == s.length() || s.charAt(0) != ']') {
            return Either.left((Object)new Error(s, "closing square bracket not found"));
        }
        String remaining = s.substring(1);
        return Either.right((Object)new Tuple2((Object)remaining, (Object)new Term.Set(terms)));
    }

    public static Either<Error, Tuple2<String, Term.Bytes>> bytes(String s) {
        if (!s.startsWith("hex:")) {
            return Either.left((Object)new Error(s, "not a bytes array"));
        }
        s = s.substring(4);
        Tuple2<String, byte[]> t = Parser.hex(s);
        return Either.right((Object)new Tuple2((Object)((String)t._1), (Object)new Term.Bytes((byte[])t._2)));
    }

    public static Tuple2<String, byte[]> hex(String s) {
        char c;
        int index = 0;
        for (int i = 0; i < s.length() && "0123456789ABCDEFabcdef".indexOf(c = s.charAt(i)) != -1; ++i) {
            ++index;
        }
        String hex = s.substring(0, index);
        byte[] bytes = Utils.hexStringToByteArray(hex);
        s = s.substring(index);
        return new Tuple2((Object)s, (Object)bytes);
    }

    public static Either<Error, Tuple2<String, Expression>> expression(String s) {
        return ExpressionParser.parse(s);
    }

    public static String space(String s) {
        char c;
        int index = 0;
        for (int i = 0; i < s.length() && ((c = s.charAt(i)) == ' ' || c == '\t' || c == '\r' || c == '\n'); ++i) {
            ++index;
        }
        return s.substring(index);
    }

    public static Tuple2<String, String> take_while(String s, Function<Character, Boolean> f) {
        int index = s.length();
        for (int i = 0; i < s.length(); ++i) {
            Character c = Character.valueOf(s.charAt(i));
            if (f.apply(c).booleanValue()) continue;
            index = i;
            break;
        }
        return new Tuple2((Object)s.substring(0, index), (Object)s.substring(index));
    }
}

