/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.crypto;

import biscuit.format.schema.Schema;
import com.google.protobuf.ByteString;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.biscuitsec.biscuit.crypto.KeyPair;
import org.biscuitsec.biscuit.error.Error;
import org.biscuitsec.biscuit.token.builder.Utils;

public class PublicKey {
    public final EdDSAPublicKey key;
    public final Schema.PublicKey.Algorithm algorithm;

    public PublicKey(Schema.PublicKey.Algorithm algorithm, EdDSAPublicKey public_key) {
        this.key = public_key;
        this.algorithm = algorithm;
    }

    public PublicKey(Schema.PublicKey.Algorithm algorithm, byte[] data) {
        EdDSAPublicKeySpec pubKeySpec = new EdDSAPublicKeySpec(data, (EdDSAParameterSpec)KeyPair.ed25519);
        this.key = new EdDSAPublicKey(pubKeySpec);
        this.algorithm = algorithm;
    }

    public byte[] toBytes() {
        return this.key.getAbyte();
    }

    public String toHex() {
        return Utils.byteArrayToHexString(this.toBytes());
    }

    public PublicKey(Schema.PublicKey.Algorithm algorithm, String hex) {
        byte[] data = Utils.hexStringToByteArray(hex);
        EdDSAPublicKeySpec pubKeySpec = new EdDSAPublicKeySpec(data, (EdDSAParameterSpec)KeyPair.ed25519);
        this.key = new EdDSAPublicKey(pubKeySpec);
        this.algorithm = algorithm;
    }

    public Schema.PublicKey serialize() {
        Schema.PublicKey.Builder publicKey = Schema.PublicKey.newBuilder();
        publicKey.setKey(ByteString.copyFrom((byte[])this.toBytes()));
        publicKey.setAlgorithm(this.algorithm);
        return publicKey.build();
    }

    public static PublicKey deserialize(Schema.PublicKey pk) throws Error.FormatError.DeserializationError {
        if (!pk.hasAlgorithm() || !pk.hasKey() || pk.getAlgorithm() != Schema.PublicKey.Algorithm.Ed25519) {
            throw new Error.FormatError.DeserializationError("Invalid public key");
        }
        return new PublicKey(pk.getAlgorithm(), pk.getKey().toByteArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKey publicKey = (PublicKey)o;
        return this.key.equals((Object)publicKey.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "ed25519/" + this.toHex().toLowerCase();
    }
}

