/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.datalog;

import io.vavr.Tuple2;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.biscuitsec.biscuit.datalog.Fact;
import org.biscuitsec.biscuit.datalog.MatchedVariables;
import org.biscuitsec.biscuit.datalog.Origin;
import org.biscuitsec.biscuit.datalog.Predicate;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.datalog.Term;

public final class Combinator
implements Serializable,
Iterator<Tuple2<Origin, Map<Long, Term>>> {
    private MatchedVariables variables;
    private final Supplier<Stream<Tuple2<Origin, Fact>>> allFacts;
    private final List<Predicate> predicates;
    private final Iterator<Tuple2<Origin, Fact>> currentFacts;
    private Combinator currentIt;
    private final SymbolTable symbols;
    private Origin currentOrigin;
    private Option<Tuple2<Origin, Map<Long, Term>>> nextElement;

    @Override
    public boolean hasNext() {
        if (this.nextElement != null && this.nextElement.isDefined()) {
            return true;
        }
        this.nextElement = this.getNext();
        return this.nextElement.isDefined();
    }

    @Override
    public Tuple2<Origin, Map<Long, Term>> next() {
        if (this.nextElement == null || !this.nextElement.isDefined()) {
            this.nextElement = this.getNext();
        }
        if (this.nextElement == null || !this.nextElement.isDefined()) {
            throw new NoSuchElementException();
        }
        Tuple2 t = (Tuple2)this.nextElement.get();
        this.nextElement = Option.none();
        return t;
    }

    public Option<Tuple2<Origin, Map<Long, Term>>> getNext() {
        if (this.predicates.isEmpty()) {
            Option<Map<Long, Term>> v_opt = this.variables.complete();
            if (v_opt.isEmpty()) {
                return Option.none();
            }
            Map variables = (Map)v_opt.get();
            HashSet<Long> set = new HashSet<Long>();
            set.add(0L);
            this.variables = new MatchedVariables(set);
            return Option.some((Object)new Tuple2((Object)new Origin(), (Object)variables));
        }
        while (true) {
            Tuple2<Origin, Fact> t;
            block10: {
                if (this.currentIt == null) {
                    Predicate predicate = this.predicates.get(0);
                    while (this.currentFacts.hasNext()) {
                        t = this.currentFacts.next();
                        Origin currentOrigin = ((Origin)t._1).clone();
                        Fact fact = (Fact)t._2;
                        MatchedVariables vars = this.variables.clone();
                        boolean matchTerms = true;
                        for (int i = 0; i < predicate.terms().size(); ++i) {
                            Term value;
                            Term term = predicate.terms().get(i);
                            if (!(term instanceof Term.Variable)) continue;
                            long key = ((Term.Variable)term).value();
                            if (!vars.insert(key, value = fact.predicate().terms().get(i))) {
                                matchTerms = false;
                            }
                            if (!matchTerms) break;
                        }
                        if (!matchTerms) continue;
                        if (this.predicates.size() == 1) {
                            Option<Map<Long, Term>> v_opt = vars.complete();
                            if (v_opt.isEmpty()) continue;
                            return Option.some((Object)new Tuple2((Object)currentOrigin, (Object)((Map)v_opt.get())));
                        }
                        this.currentOrigin = currentOrigin;
                        this.currentIt = new Combinator(vars, this.predicates.subList(1, this.predicates.size()), this.allFacts, this.symbols);
                        break block10;
                    }
                    return Option.none();
                }
            }
            if (this.currentIt == null) {
                return Option.none();
            }
            Option<Tuple2<Origin, Map<Long, Term>>> opt = this.currentIt.getNext();
            if (opt.isDefined()) {
                t = (Tuple2<Origin, Fact>)opt.get();
                return Option.some((Object)new Tuple2((Object)((Origin)t._1).union(this.currentOrigin), (Object)((Map)t._2)));
            }
            this.currentOrigin = null;
            this.currentIt = null;
        }
    }

    public Combinator(MatchedVariables variables, List<Predicate> predicates, Supplier<Stream<Tuple2<Origin, Fact>>> all_facts, SymbolTable symbols) {
        this.variables = variables;
        this.allFacts = all_facts;
        this.currentIt = null;
        this.predicates = predicates;
        this.currentFacts = all_facts.get().filter(tuple -> ((Fact)tuple._2).match_predicate((Predicate)predicates.get(0))).iterator();
        this.symbols = symbols;
        this.currentOrigin = null;
        this.nextElement = null;
    }
}

