/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.datalog;

import biscuit.format.schema.Schema;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.biscuitsec.biscuit.datalog.Predicate;
import org.biscuitsec.biscuit.datalog.Term;
import org.biscuitsec.biscuit.error.Error;

public final class Fact
implements Serializable {
    private final Predicate predicate;

    public final Predicate predicate() {
        return this.predicate;
    }

    public boolean match_predicate(Predicate rule_predicate) {
        return this.predicate.match(rule_predicate);
    }

    public Fact(Predicate predicate) {
        this.predicate = predicate;
    }

    public Fact(long name, List<Term> terms) {
        this.predicate = new Predicate(name, terms);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fact fact = (Fact)o;
        return Objects.equals(this.predicate, fact.predicate);
    }

    public int hashCode() {
        return Objects.hash(this.predicate);
    }

    public String toString() {
        return this.predicate.toString();
    }

    public Schema.FactV2 serialize() {
        return Schema.FactV2.newBuilder().setPredicate(this.predicate.serialize()).build();
    }

    public static Either<Error.FormatError, Fact> deserializeV2(Schema.FactV2 fact) {
        Either<Error.FormatError, Predicate> res = Predicate.deserializeV2(fact.getPredicate());
        if (res.isLeft()) {
            Error.FormatError e = (Error.FormatError)res.getLeft();
            return API.Left((Object)e);
        }
        return API.Right((Object)new Fact((Predicate)res.get()));
    }
}

