/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.datalog;

import biscuit.format.schema.Schema;
import io.vavr.API;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.control.Either;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.biscuitsec.biscuit.datalog.Combinator;
import org.biscuitsec.biscuit.datalog.Fact;
import org.biscuitsec.biscuit.datalog.FactSet;
import org.biscuitsec.biscuit.datalog.MatchedVariables;
import org.biscuitsec.biscuit.datalog.Origin;
import org.biscuitsec.biscuit.datalog.Predicate;
import org.biscuitsec.biscuit.datalog.Scope;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.datalog.TemporarySymbolTable;
import org.biscuitsec.biscuit.datalog.Term;
import org.biscuitsec.biscuit.datalog.TrustedOrigins;
import org.biscuitsec.biscuit.datalog.expressions.Expression;
import org.biscuitsec.biscuit.error.Error;

public final class Rule
implements Serializable {
    private final Predicate head;
    private final List<Predicate> body;
    private final List<Expression> expressions;
    private final List<Scope> scopes;

    public final Predicate head() {
        return this.head;
    }

    public final List<Predicate> body() {
        return this.body;
    }

    public final List<Expression> expressions() {
        return this.expressions;
    }

    public List<Scope> scopes() {
        return this.scopes;
    }

    public Stream<Either<Error, Tuple2<Origin, Fact>>> apply(Supplier<Stream<Tuple2<Origin, Fact>>> factsSupplier, Long ruleOrigin, SymbolTable symbols) {
        MatchedVariables variables = this.variablesSet();
        Combinator combinator = new Combinator(variables, this.body, factsSupplier, symbols);
        Spliterator<Tuple2<Origin, Map<Long, Term>>> splitItr = Spliterators.spliteratorUnknownSize(combinator, 16);
        Stream<Tuple2<Origin, Map<Long, Term>>> stream = StreamSupport.stream(splitItr, false);
        return stream.map(t -> {
            Origin origin = (Origin)t._1;
            Map generatedVariables = (Map)t._2;
            TemporarySymbolTable temporarySymbols = new TemporarySymbolTable(symbols);
            for (Expression e : this.expressions) {
                try {
                    Term term = e.evaluate(generatedVariables, temporarySymbols);
                    if (term instanceof Term.Bool) {
                        Term.Bool b = (Term.Bool)term;
                        if (b.value()) continue;
                        return Either.right((Object)new Tuple3((Object)origin, (Object)generatedVariables, (Object)false));
                    }
                    return Either.left((Object)new Error.InvalidType());
                }
                catch (Error error) {
                    return Either.left((Object)error);
                }
            }
            return Either.right((Object)new Tuple3((Object)origin, (Object)generatedVariables, (Object)true));
        }).filter(res -> res.isRight() & (Boolean)((Tuple3)res.get())._3).map(res -> {
            Tuple3 t = (Tuple3)res.get();
            Origin origin = (Origin)t._1;
            Map generatedVariables = (Map)t._2;
            Predicate p = this.head.clone();
            for (int index = 0; index < p.terms().size(); ++index) {
                if (!(p.terms().get(index) instanceof Term.Variable)) continue;
                Term.Variable var = (Term.Variable)p.terms().get(index);
                if (!generatedVariables.containsKey(var.value())) {
                    return Either.left((Object)new Error.InternalError());
                }
                p.terms().set(index, (Term)generatedVariables.get(var.value()));
            }
            origin.add(ruleOrigin);
            return Either.right((Object)new Tuple2((Object)origin, (Object)new Fact(p)));
        });
    }

    private MatchedVariables variablesSet() {
        HashSet<Long> variables_set = new HashSet<Long>();
        for (Predicate pred : this.body) {
            variables_set.addAll(pred.terms().stream().filter(id -> id instanceof Term.Variable).map(id -> ((Term.Variable)id).value()).collect(Collectors.toSet()));
        }
        return new MatchedVariables(variables_set);
    }

    public boolean find_match(FactSet facts, Long origin, TrustedOrigins scope, SymbolTable symbols) throws Error {
        MatchedVariables variables = this.variablesSet();
        if (this.body.isEmpty()) {
            return variables.check_expressions(this.expressions, symbols).isDefined();
        }
        Supplier<Stream<Tuple2<Origin, Fact>>> factsSupplier = () -> facts.stream(scope);
        Stream<Either<Error, Tuple2<Origin, Fact>>> stream = this.apply(factsSupplier, origin, symbols);
        Iterator it = stream.iterator();
        if (!it.hasNext()) {
            return false;
        }
        Either next = (Either)it.next();
        if (next.isRight()) {
            return true;
        }
        throw (Error)next.getLeft();
    }

    public boolean check_match_all(FactSet facts, TrustedOrigins scope, SymbolTable symbols) throws Error {
        MatchedVariables variables = this.variablesSet();
        if (this.body.isEmpty()) {
            return variables.check_expressions(this.expressions, symbols).isDefined();
        }
        Supplier<Stream<Tuple2<Origin, Fact>>> factsSupplier = () -> facts.stream(scope);
        Combinator combinator = new Combinator(variables, this.body, factsSupplier, symbols);
        boolean found = false;
        Combinator it = combinator;
        while (it.hasNext()) {
            Tuple2<Origin, Map<Long, Term>> t = it.next();
            Map generatedVariables = (Map)t._2;
            found = true;
            TemporarySymbolTable temporarySymbols = new TemporarySymbolTable(symbols);
            for (Expression e : this.expressions) {
                Term term = e.evaluate(generatedVariables, temporarySymbols);
                if (term instanceof Term.Bool) {
                    Term.Bool b = (Term.Bool)term;
                    if (b.value()) continue;
                    return false;
                }
                throw new Error.InvalidType();
            }
        }
        return found;
    }

    public Rule(Predicate head, List<Predicate> body, List<Expression> expressions) {
        this.head = head;
        this.body = body;
        this.expressions = expressions;
        this.scopes = new ArrayList<Scope>();
    }

    public Rule(Predicate head, List<Predicate> body, List<Expression> expressions, List<Scope> scopes) {
        this.head = head;
        this.body = body;
        this.expressions = expressions;
        this.scopes = scopes;
    }

    public Schema.RuleV2 serialize() {
        int i;
        Schema.RuleV2.Builder b = Schema.RuleV2.newBuilder().setHead(this.head.serialize());
        for (i = 0; i < this.body.size(); ++i) {
            b.addBody(this.body.get(i).serialize());
        }
        for (i = 0; i < this.expressions.size(); ++i) {
            b.addExpressions(this.expressions.get(i).serialize());
        }
        for (Scope scope : this.scopes) {
            b.addScope(scope.serialize());
        }
        return b.build();
    }

    public static Either<Error.FormatError, Rule> deserializeV2(Schema.RuleV2 rule) {
        ArrayList<Predicate> body = new ArrayList<Predicate>();
        for (Schema.PredicateV2 predicateV2 : rule.getBodyList()) {
            Either<Error.FormatError, Predicate> either = Predicate.deserializeV2(predicateV2);
            if (either.isLeft()) {
                Error.FormatError e = (Error.FormatError)either.getLeft();
                return API.Left((Object)e);
            }
            body.add((Predicate)either.get());
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (Schema.ExpressionV2 expressionV2 : rule.getExpressionsList()) {
            Either<Error.FormatError, Expression> res2 = Expression.deserializeV2(expressionV2);
            if (res2.isLeft()) {
                Error.FormatError e = (Error.FormatError)res2.getLeft();
                return API.Left((Object)e);
            }
            expressions.add((Expression)res2.get());
        }
        ArrayList<Scope> arrayList = new ArrayList<Scope>();
        for (Schema.Scope scope : rule.getScopeList()) {
            Either<Error.FormatError, Scope> res3 = Scope.deserialize(scope);
            if (res3.isLeft()) {
                Error.FormatError e = (Error.FormatError)res3.getLeft();
                return API.Left((Object)e);
            }
            arrayList.add((Scope)res3.get());
        }
        Either<Error.FormatError, Predicate> either = Predicate.deserializeV2(rule.getHead());
        if (either.isLeft()) {
            Error.FormatError e = (Error.FormatError)either.getLeft();
            return API.Left((Object)e);
        }
        return API.Right((Object)new Rule((Predicate)either.get(), body, expressions, arrayList));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        if (!Objects.equals(this.head, rule.head)) {
            return false;
        }
        if (!Objects.equals(this.body, rule.body)) {
            return false;
        }
        if (!Objects.equals(this.expressions, rule.expressions)) {
            return false;
        }
        return Objects.equals(this.scopes, rule.scopes);
    }

    public int hashCode() {
        int result = this.head != null ? this.head.hashCode() : 0;
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.expressions != null ? this.expressions.hashCode() : 0);
        result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Rule{head=" + this.head + ", body=" + this.body + ", expressions=" + this.expressions + ", scopes=" + this.scopes + "}";
    }
}

