/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.datalog.expressions;

import biscuit.format.schema.Schema;
import io.vavr.API;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.datalog.TemporarySymbolTable;
import org.biscuitsec.biscuit.datalog.Term;
import org.biscuitsec.biscuit.datalog.expressions.Op;
import org.biscuitsec.biscuit.error.Error;

public class Expression {
    private final ArrayList<Op> ops;

    public Expression(ArrayList<Op> ops) {
        this.ops = ops;
    }

    public ArrayList<Op> getOps() {
        return this.ops;
    }

    public Term evaluate(Map<Long, Term> variables, TemporarySymbolTable symbols) throws Error.Execution {
        ArrayDeque<Term> stack = new ArrayDeque<Term>(16);
        for (Op op : this.ops) {
            op.evaluate(stack, variables, symbols);
        }
        if (stack.size() == 1) {
            return (Term)stack.pop();
        }
        throw new Error.Execution(this, "execution");
    }

    public Option<String> print(SymbolTable symbols) {
        ArrayDeque<String> stack = new ArrayDeque<String>();
        for (Op op : this.ops) {
            op.print(stack, symbols);
        }
        if (stack.size() == 1) {
            return Option.some((Object)((String)stack.remove()));
        }
        return Option.none();
    }

    public Schema.ExpressionV2 serialize() {
        Schema.ExpressionV2.Builder b = Schema.ExpressionV2.newBuilder();
        for (Op op : this.ops) {
            b.addOps(op.serialize());
        }
        return b.build();
    }

    public static Either<Error.FormatError, Expression> deserializeV2(Schema.ExpressionV2 e) {
        ArrayList<Op> ops = new ArrayList<Op>();
        for (Schema.Op op : e.getOpsList()) {
            Either<Error.FormatError, Op> res = Op.deserializeV2(op);
            if (res.isLeft()) {
                Error.FormatError err = (Error.FormatError)res.getLeft();
                return API.Left((Object)err);
            }
            ops.add((Op)res.get());
        }
        return API.Right((Object)new Expression(ops));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Expression that = (Expression)o;
        return Objects.equals(this.ops, that.ops);
    }

    public int hashCode() {
        return this.ops != null ? this.ops.hashCode() : 0;
    }

    public String toString() {
        return "Expression{ops=" + this.ops + "}";
    }
}

