/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.error;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Objects;

public class FailedCheck {
    public JsonElement toJson() {
        return new JsonObject();
    }

    public static class LanguageError
    extends FailedCheck {

        public static class UnknownVariable
        extends LanguageError {
            String message;

            public UnknownVariable(String message) {
                this.message = message;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                UnknownVariable b = (UnknownVariable)o;
                return this.message == b.message && this.message.equals(b.message);
            }

            public int hashCode() {
                return Objects.hash(this.message);
            }

            public String toString() {
                return "LanguageError.UnknownVariable { message: " + this.message + " }";
            }

            @Override
            public JsonElement toJson() {
                JsonObject authorizer = new JsonObject();
                authorizer.add("UnknownVariable", (JsonElement)new JsonPrimitive(this.message));
                return authorizer;
            }
        }

        public static class Builder
        extends LanguageError {
            List<String> invalid_variables;

            public Builder(List<String> invalid_variables) {
                this.invalid_variables = invalid_variables;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Builder b = (Builder)o;
                return this.invalid_variables == b.invalid_variables && this.invalid_variables.equals(b.invalid_variables);
            }

            public int hashCode() {
                return Objects.hash(this.invalid_variables);
            }

            public String toString() {
                return "InvalidVariables { message: " + this.invalid_variables + " }";
            }

            @Override
            public JsonElement toJson() {
                JsonObject authorizer = new JsonObject();
                JsonArray ja = new JsonArray();
                for (String s : this.invalid_variables) {
                    ja.add(s);
                }
                authorizer.add("InvalidVariables", (JsonElement)ja);
                return authorizer;
            }
        }

        public static class ParseError
        extends LanguageError {
            @Override
            public JsonElement toJson() {
                return new JsonPrimitive("ParseError");
            }
        }
    }

    public static class ParseErrors
    extends FailedCheck {
    }

    public static class FailedAuthorizer
    extends FailedCheck {
        public final long check_id;
        public final String rule;

        public FailedAuthorizer(long check_id, String rule) {
            this.check_id = check_id;
            this.rule = rule;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FailedAuthorizer b = (FailedAuthorizer)o;
            return this.check_id == b.check_id && this.rule.equals(b.rule);
        }

        public int hashCode() {
            return Objects.hash(this.check_id, this.rule);
        }

        public String toString() {
            return "FailedCaveat.FailedAuthorizer { check_id: " + this.check_id + ", rule: " + this.rule + " }";
        }

        @Override
        public JsonElement toJson() {
            JsonObject jo = new JsonObject();
            jo.addProperty("check_id", (Number)this.check_id);
            jo.addProperty("rule", this.rule);
            JsonObject authorizer = new JsonObject();
            authorizer.add("Authorizer", (JsonElement)jo);
            return authorizer;
        }
    }

    public static class FailedBlock
    extends FailedCheck {
        public final long block_id;
        public final long check_id;
        public final String rule;

        public FailedBlock(long block_id, long check_id, String rule) {
            this.block_id = block_id;
            this.check_id = check_id;
            this.rule = rule;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FailedBlock b = (FailedBlock)o;
            return this.block_id == b.block_id && this.check_id == b.check_id && this.rule.equals(b.rule);
        }

        public int hashCode() {
            return Objects.hash(this.block_id, this.check_id, this.rule);
        }

        public String toString() {
            return "Block(FailedBlockCheck " + new Gson().toJson(this.toJson()) + ")";
        }

        @Override
        public JsonElement toJson() {
            JsonObject jo = new JsonObject();
            jo.addProperty("block_id", (Number)this.block_id);
            jo.addProperty("check_id", (Number)this.check_id);
            jo.addProperty("rule", this.rule);
            JsonObject block = new JsonObject();
            block.add("Block", (JsonElement)jo);
            return block;
        }
    }
}

