/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token;

import biscuit.format.schema.Schema;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.biscuitsec.biscuit.crypto.KeyDelegate;
import org.biscuitsec.biscuit.crypto.KeyPair;
import org.biscuitsec.biscuit.crypto.PublicKey;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.error.Error;
import org.biscuitsec.biscuit.token.Authorizer;
import org.biscuitsec.biscuit.token.ThirdPartyBlockContents;
import org.biscuitsec.biscuit.token.UnverifiedBiscuit;
import org.biscuitsec.biscuit.token.builder.Block;
import org.biscuitsec.biscuit.token.format.ExternalSignature;
import org.biscuitsec.biscuit.token.format.SerializedBiscuit;

public class Biscuit
extends UnverifiedBiscuit {
    public static org.biscuitsec.biscuit.token.builder.Biscuit builder(KeyPair root) {
        return new org.biscuitsec.biscuit.token.builder.Biscuit(new SecureRandom(), root);
    }

    public static org.biscuitsec.biscuit.token.builder.Biscuit builder(SecureRandom rng, KeyPair root) {
        return new org.biscuitsec.biscuit.token.builder.Biscuit(rng, root);
    }

    public static org.biscuitsec.biscuit.token.builder.Biscuit builder(SecureRandom rng, KeyPair root, Option<Integer> root_key_id) {
        return new org.biscuitsec.biscuit.token.builder.Biscuit(rng, root, root_key_id);
    }

    public static Biscuit make(SecureRandom rng, KeyPair root, org.biscuitsec.biscuit.token.Block authority) throws Error.FormatError {
        return Biscuit.make(rng, root, (Option<Integer>)Option.none(), authority);
    }

    public static Biscuit make(SecureRandom rng, KeyPair root, Integer root_key_id, org.biscuitsec.biscuit.token.Block authority) throws Error.FormatError {
        return Biscuit.make(rng, root, (Option<Integer>)Option.of((Object)root_key_id), authority);
    }

    private static Biscuit make(SecureRandom rng, KeyPair root, Option<Integer> root_key_id, org.biscuitsec.biscuit.token.Block authority) throws Error.FormatError {
        ArrayList<org.biscuitsec.biscuit.token.Block> blocks = new ArrayList<org.biscuitsec.biscuit.token.Block>();
        KeyPair next = KeyPair.generate(Schema.PublicKey.Algorithm.Ed25519, rng);
        for (PublicKey pk : authority.publicKeys) {
            authority.symbols.insert(pk);
        }
        Either<Error.FormatError, SerializedBiscuit> container = SerializedBiscuit.make(root, root_key_id, authority, next);
        if (container.isLeft()) {
            throw (Error.FormatError)container.getLeft();
        }
        SerializedBiscuit s = (SerializedBiscuit)container.get();
        List<byte[]> revocation_ids = s.revocation_identifiers();
        Option c = Option.some((Object)s);
        return new Biscuit(authority, blocks, authority.symbols, s, revocation_ids, root_key_id);
    }

    Biscuit(org.biscuitsec.biscuit.token.Block authority, List<org.biscuitsec.biscuit.token.Block> blocks, SymbolTable symbols, SerializedBiscuit serializedBiscuit, List<byte[]> revocation_ids) {
        super(authority, blocks, symbols, serializedBiscuit, revocation_ids);
    }

    Biscuit(org.biscuitsec.biscuit.token.Block authority, List<org.biscuitsec.biscuit.token.Block> blocks, SymbolTable symbols, SerializedBiscuit serializedBiscuit, List<byte[]> revocation_ids, Option<Integer> root_key_id) {
        super(authority, blocks, symbols, serializedBiscuit, revocation_ids, root_key_id);
    }

    @Deprecated
    public static Biscuit from_b64(String data, PublicKey root) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes(Base64.getUrlDecoder().decode(data), root);
    }

    public static Biscuit from_b64url(String data, PublicKey root) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes(Base64.getUrlDecoder().decode(data), root);
    }

    public static Biscuit from_b64url(String data, KeyDelegate delegate) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes(Base64.getUrlDecoder().decode(data), delegate);
    }

    public static Biscuit from_bytes(byte[] data, PublicKey root) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes_with_symbols(data, root, Biscuit.default_symbol_table());
    }

    public static Biscuit from_bytes(byte[] data, KeyDelegate delegate) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes_with_symbols(data, delegate, Biscuit.default_symbol_table());
    }

    public static Biscuit from_bytes_with_symbols(byte[] data, PublicKey root, SymbolTable symbols) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        SerializedBiscuit ser = SerializedBiscuit.from_bytes(data, root);
        return Biscuit.from_serialized_biscuit(ser, symbols);
    }

    public static Biscuit from_bytes_with_symbols(byte[] data, KeyDelegate delegate, SymbolTable symbols) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        SerializedBiscuit ser = SerializedBiscuit.from_bytes(data, delegate);
        return Biscuit.from_serialized_biscuit(ser, symbols);
    }

    static Biscuit from_serialized_biscuit(SerializedBiscuit ser, SymbolTable symbols) throws Error {
        Tuple2<org.biscuitsec.biscuit.token.Block, ArrayList<org.biscuitsec.biscuit.token.Block>> t = ser.extractBlocks(symbols);
        org.biscuitsec.biscuit.token.Block authority = (org.biscuitsec.biscuit.token.Block)t._1;
        ArrayList blocks = (ArrayList)t._2;
        List<byte[]> revocation_ids = ser.revocation_identifiers();
        return new Biscuit(authority, blocks, symbols, ser, revocation_ids);
    }

    public Authorizer authorizer() throws Error.FailedLogic {
        return Authorizer.make(this);
    }

    @Override
    public byte[] serialize() throws Error.FormatError.SerializationError {
        return this.serializedBiscuit.serialize();
    }

    @Deprecated
    public String serialize_b64() throws Error.FormatError.SerializationError {
        return Base64.getUrlEncoder().encodeToString(this.serialize());
    }

    @Override
    public String serialize_b64url() throws Error.FormatError.SerializationError {
        return Base64.getUrlEncoder().encodeToString(this.serialize());
    }

    @Override
    public Biscuit attenuate(Block block) throws Error {
        SecureRandom rng = new SecureRandom();
        KeyPair keypair = KeyPair.generate(Schema.PublicKey.Algorithm.Ed25519, rng);
        SymbolTable builderSymbols = new SymbolTable(this.symbols);
        return this.attenuate(rng, keypair, block.build(builderSymbols));
    }

    @Override
    public Biscuit attenuate(SecureRandom rng, KeyPair keypair, Block block) throws Error {
        SymbolTable builderSymbols = new SymbolTable(this.symbols);
        return this.attenuate(rng, keypair, block.build(builderSymbols));
    }

    @Override
    public Biscuit attenuate(SecureRandom rng, KeyPair keypair, org.biscuitsec.biscuit.token.Block block) throws Error {
        Biscuit copiedBiscuit = this.copy();
        if (!Collections.disjoint(copiedBiscuit.symbols.symbols, block.symbols.symbols)) {
            throw new Error.SymbolTableOverlap();
        }
        Either<Error.FormatError, SerializedBiscuit> containerRes = copiedBiscuit.serializedBiscuit.append(keypair, block, (Option<ExternalSignature>)Option.none());
        if (containerRes.isLeft()) {
            throw (Error.FormatError)containerRes.getLeft();
        }
        SerializedBiscuit container = (SerializedBiscuit)containerRes.get();
        SymbolTable symbols = new SymbolTable(copiedBiscuit.symbols);
        for (String string : block.symbols.symbols) {
            symbols.add(string);
        }
        for (PublicKey publicKey : block.publicKeys) {
            symbols.insert(publicKey);
        }
        ArrayList<org.biscuitsec.biscuit.token.Block> blocks = new ArrayList<org.biscuitsec.biscuit.token.Block>();
        for (org.biscuitsec.biscuit.token.Block b : copiedBiscuit.blocks) {
            blocks.add(b);
        }
        blocks.add(block);
        List<byte[]> list = container.revocation_identifiers();
        return new Biscuit(copiedBiscuit.authority, blocks, symbols, container, list);
    }

    @Override
    public Biscuit appendThirdPartyBlock(PublicKey externalKey, ThirdPartyBlockContents blockResponse) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        UnverifiedBiscuit b = super.appendThirdPartyBlock(externalKey, blockResponse);
        return Biscuit.from_serialized_biscuit(b.serializedBiscuit, b.symbols);
    }

    @Override
    public String print() {
        StringBuilder s = new StringBuilder();
        s.append("Biscuit {\n\tsymbols: ");
        s.append(this.symbols.getAllSymbols());
        s.append("\n\tpublic keys: ");
        s.append(this.symbols.publicKeys());
        s.append("\n\tauthority: ");
        s.append(this.authority.print(this.symbols));
        s.append("\n\tblocks: [\n");
        for (org.biscuitsec.biscuit.token.Block b : this.blocks) {
            s.append("\t\t");
            if (b.externalKey.isDefined()) {
                s.append(b.print(b.symbols));
            } else {
                s.append(b.print(this.symbols));
            }
            s.append("\n");
        }
        s.append("\t]\n}");
        return s.toString();
    }

    @Override
    public Biscuit copy() throws Error {
        return Biscuit.from_serialized_biscuit(this.serializedBiscuit, this.symbols);
    }
}

