/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token;

import biscuit.format.schema.Schema;
import com.google.protobuf.InvalidProtocolBufferException;
import io.vavr.API;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.biscuitsec.biscuit.crypto.PublicKey;
import org.biscuitsec.biscuit.datalog.Check;
import org.biscuitsec.biscuit.datalog.Fact;
import org.biscuitsec.biscuit.datalog.Rule;
import org.biscuitsec.biscuit.datalog.SchemaVersion;
import org.biscuitsec.biscuit.datalog.Scope;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.datalog.expressions.Expression;
import org.biscuitsec.biscuit.datalog.expressions.Op;
import org.biscuitsec.biscuit.error.Error;
import org.biscuitsec.biscuit.token.format.SerializedBiscuit;

public class Block {
    final SymbolTable symbols;
    final String context;
    final List<Fact> facts;
    final List<Rule> rules;
    final List<Check> checks;
    final List<Scope> scopes;
    final List<PublicKey> publicKeys;
    Option<PublicKey> externalKey;
    long version;

    public Block(SymbolTable base_symbols) {
        this.symbols = base_symbols;
        this.context = "";
        this.facts = new ArrayList<Fact>();
        this.rules = new ArrayList<Rule>();
        this.checks = new ArrayList<Check>();
        this.scopes = new ArrayList<Scope>();
        this.publicKeys = new ArrayList<PublicKey>();
        this.externalKey = Option.none();
    }

    public Block(SymbolTable base_symbols, String context, List<Fact> facts, List<Rule> rules, List<Check> checks, List<Scope> scopes, List<PublicKey> publicKeys, Option<PublicKey> externalKey, int version) {
        this.symbols = base_symbols;
        this.context = context;
        this.facts = facts;
        this.rules = rules;
        this.checks = checks;
        this.scopes = scopes;
        this.publicKeys = publicKeys;
        this.externalKey = externalKey;
    }

    public SymbolTable symbols() {
        return this.symbols;
    }

    public List<PublicKey> publicKeys() {
        return this.publicKeys;
    }

    public void setExternalKey(PublicKey externalKey) {
        this.externalKey = Option.some((Object)externalKey);
    }

    public String print(SymbolTable symbol_table) {
        SymbolTable local_symbols;
        StringBuilder s = new StringBuilder();
        if (this.externalKey.isDefined()) {
            local_symbols = new SymbolTable(this.symbols);
            for (PublicKey pk : symbol_table.publicKeys()) {
                local_symbols.insert(pk);
            }
        } else {
            local_symbols = symbol_table;
        }
        s.append("Block");
        s.append(" {\n\t\tsymbols: ");
        s.append(this.symbols.symbols);
        s.append("\n\t\tsymbol public keys: ");
        s.append(this.symbols.publicKeys());
        s.append("\n\t\tblock public keys: ");
        s.append(this.publicKeys);
        s.append("\n\t\tcontext: ");
        s.append(this.context);
        if (this.externalKey.isDefined()) {
            s.append("\n\t\texternal key: ");
            s.append(((PublicKey)this.externalKey.get()).toString());
        }
        s.append("\n\t\tscopes: [");
        for (Scope scope : this.scopes) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_scope(scope));
        }
        s.append("\n\t\t]\n\t\tfacts: [");
        for (Fact f : this.facts) {
            s.append("\n\t\t\t");
            s.append(local_symbols.print_fact(f));
        }
        s.append("\n\t\t]\n\t\trules: [");
        for (Rule r : this.rules) {
            s.append("\n\t\t\t");
            s.append(local_symbols.print_rule(r));
        }
        s.append("\n\t\t]\n\t\tchecks: [");
        for (Check c : this.checks) {
            s.append("\n\t\t\t");
            s.append(local_symbols.print_check(c));
        }
        s.append("\n\t\t]\n\t}");
        return s.toString();
    }

    public String printCode(SymbolTable symbol_table) {
        SymbolTable local_symbols;
        StringBuilder s = new StringBuilder();
        if (this.externalKey.isDefined()) {
            local_symbols = new SymbolTable(this.symbols);
            for (PublicKey pk : symbol_table.publicKeys()) {
                local_symbols.insert(pk);
            }
        } else {
            local_symbols = symbol_table;
        }
        for (Scope scope : this.scopes) {
            s.append("trusting " + local_symbols.print_scope(scope) + "\n");
        }
        for (Fact f : this.facts) {
            s.append(local_symbols.print_fact(f) + ";\n");
        }
        for (Rule r : this.rules) {
            s.append(local_symbols.print_rule(r) + ";\n");
        }
        for (Check c : this.checks) {
            s.append(local_symbols.print_check(c) + ";\n");
        }
        return s.toString();
    }

    public Schema.Block serialize() {
        int i;
        Schema.Block.Builder b = Schema.Block.newBuilder();
        for (i = 0; i < this.symbols.symbols.size(); ++i) {
            b.addSymbols(this.symbols.symbols.get(i));
        }
        if (!this.context.isEmpty()) {
            b.setContext(this.context);
        }
        for (i = 0; i < this.facts.size(); ++i) {
            b.addFactsV2(this.facts.get(i).serialize());
        }
        for (i = 0; i < this.rules.size(); ++i) {
            b.addRulesV2(this.rules.get(i).serialize());
        }
        for (i = 0; i < this.checks.size(); ++i) {
            b.addChecksV2(this.checks.get(i).serialize());
        }
        for (Scope scope : this.scopes) {
            b.addScope(scope.serialize());
        }
        for (PublicKey pk : this.publicKeys) {
            b.addPublicKeys(pk.serialize());
        }
        b.setVersion(this.getSchemaVersion());
        return b.build();
    }

    int getSchemaVersion() {
        boolean containsScopes = !this.scopes.isEmpty();
        boolean containsCheckAll = false;
        boolean containsV4 = false;
        for (Rule r : this.rules) {
            containsScopes |= !r.scopes().isEmpty();
            for (Expression e : r.expressions()) {
                containsV4 |= this.containsV4Op(e);
            }
        }
        for (Check c : this.checks) {
            containsCheckAll |= c.kind() == Check.Kind.All;
            for (Rule q : c.queries()) {
                containsScopes |= !q.scopes().isEmpty();
                for (Expression e : q.expressions()) {
                    containsV4 |= this.containsV4Op(e);
                }
            }
        }
        if (this.externalKey.isDefined()) {
            return SerializedBiscuit.MAX_SCHEMA_VERSION;
        }
        if (containsScopes || containsCheckAll || containsV4) {
            return 4;
        }
        return SerializedBiscuit.MIN_SCHEMA_VERSION;
    }

    boolean containsV4Op(Expression e) {
        for (Op op : e.getOps()) {
            Op.BinaryOp o;
            if (!(op instanceof Op.Binary) || (o = ((Op.Binary)op).getOp()) != Op.BinaryOp.BitwiseAnd && o != Op.BinaryOp.BitwiseOr && o != Op.BinaryOp.BitwiseXor && o != Op.BinaryOp.NotEqual) continue;
            return true;
        }
        return false;
    }

    public static Either<Error.FormatError, Block> deserialize(Schema.Block b, Option<PublicKey> externalKey) {
        Object res;
        int version = b.getVersion();
        if (version < SerializedBiscuit.MIN_SCHEMA_VERSION || version > SerializedBiscuit.MAX_SCHEMA_VERSION) {
            return API.Left((Object)new Error.FormatError.Version(SerializedBiscuit.MIN_SCHEMA_VERSION, SerializedBiscuit.MAX_SCHEMA_VERSION, version));
        }
        SymbolTable symbols = new SymbolTable();
        for (String s : b.getSymbolsList()) {
            symbols.add(s);
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ArrayList<Check> checks = new ArrayList<Check>();
        for (Schema.FactV2 factV2 : b.getFactsV2List()) {
            Either<Error.FormatError, Fact> either = Fact.deserializeV2(factV2);
            if (either.isLeft()) {
                Error.FormatError e = (Error.FormatError)either.getLeft();
                return API.Left((Object)e);
            }
            facts.add((Fact)either.get());
        }
        for (Schema.RuleV2 ruleV2 : b.getRulesV2List()) {
            Either<Error.FormatError, Rule> either = Rule.deserializeV2(ruleV2);
            if (either.isLeft()) {
                Error.FormatError e = (Error.FormatError)either.getLeft();
                return API.Left((Object)e);
            }
            rules.add((Rule)either.get());
        }
        for (Schema.CheckV2 checkV2 : b.getChecksV2List()) {
            Either<Error.FormatError, Check> either = Check.deserializeV2(checkV2);
            if (either.isLeft()) {
                Error.FormatError e = (Error.FormatError)either.getLeft();
                return API.Left((Object)e);
            }
            checks.add((Check)either.get());
        }
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        for (Schema.Scope scope : b.getScopeList()) {
            res = Scope.deserialize(scope);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            scopes.add((Scope)res.get());
        }
        ArrayList<PublicKey> arrayList = new ArrayList<PublicKey>();
        for (Schema.PublicKey pk : b.getPublicKeysList()) {
            try {
                PublicKey key = PublicKey.deserialize(pk);
                arrayList.add(key);
                symbols.publicKeys().add(key);
            }
            catch (Error.FormatError e) {
                return API.Left((Object)e);
            }
        }
        SchemaVersion schemaVersion = new SchemaVersion(facts, rules, checks, scopes);
        res = schemaVersion.checkCompatibility(version);
        if (res.isLeft()) {
            Error.FormatError e = (Error.FormatError)res.getLeft();
            return API.Left((Object)e);
        }
        return API.Right((Object)new Block(symbols, b.getContext(), facts, rules, checks, scopes, arrayList, externalKey, version));
    }

    public static Either<Error.FormatError, Block> from_bytes(byte[] slice, Option<PublicKey> externalKey) {
        try {
            Schema.Block data = Schema.Block.parseFrom(slice);
            return Block.deserialize(data, externalKey);
        }
        catch (InvalidProtocolBufferException e) {
            return API.Left((Object)new Error.FormatError.DeserializationError(e.toString()));
        }
    }

    public Either<Error.FormatError, byte[]> to_bytes() {
        Schema.Block b = this.serialize();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            b.writeTo(stream);
            byte[] data = stream.toByteArray();
            return API.Right((Object)data);
        }
        catch (IOException e) {
            return API.Left((Object)new Error.FormatError.SerializationError(e.toString()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        if (!Objects.equals(this.symbols, block.symbols)) {
            return false;
        }
        if (!Objects.equals(this.context, block.context)) {
            return false;
        }
        if (!Objects.equals(this.facts, block.facts)) {
            return false;
        }
        if (!Objects.equals(this.rules, block.rules)) {
            return false;
        }
        if (!Objects.equals(this.checks, block.checks)) {
            return false;
        }
        if (!Objects.equals(this.scopes, block.scopes)) {
            return false;
        }
        if (!Objects.equals(this.publicKeys, block.publicKeys)) {
            return false;
        }
        return Objects.equals(this.externalKey, block.externalKey);
    }

    public int hashCode() {
        int result = this.symbols != null ? this.symbols.hashCode() : 0;
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        result = 31 * result + (this.facts != null ? this.facts.hashCode() : 0);
        result = 31 * result + (this.rules != null ? this.rules.hashCode() : 0);
        result = 31 * result + (this.checks != null ? this.checks.hashCode() : 0);
        result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
        result = 31 * result + (this.publicKeys != null ? this.publicKeys.hashCode() : 0);
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Block{symbols=" + this.symbols + ", context='" + this.context + "', facts=" + this.facts + ", rules=" + this.rules + ", checks=" + this.checks + ", scopes=" + this.scopes + ", publicKeys=" + this.publicKeys + ", externalKey=" + this.externalKey + "}";
    }
}

