/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token.builder;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.datalog.Term;
import org.biscuitsec.biscuit.token.builder.Utils;

public abstract class Term {
    public abstract org.biscuitsec.biscuit.datalog.Term convert(SymbolTable var1);

    public static Term convert_from(org.biscuitsec.biscuit.datalog.Term id, SymbolTable symbols) {
        return id.toTerm(symbols);
    }

    public static class Set
    extends Term {
        final java.util.Set<Term> value;

        public Set(java.util.Set<Term> value) {
            this.value = value;
        }

        @Override
        public org.biscuitsec.biscuit.datalog.Term convert(SymbolTable symbols) {
            HashSet<org.biscuitsec.biscuit.datalog.Term> s = new HashSet<org.biscuitsec.biscuit.datalog.Term>();
            for (Term t : this.value) {
                s.add(t.convert(symbols));
            }
            return new Term.Set(s);
        }

        public java.util.Set<Term> getValue() {
            return Collections.unmodifiableSet(this.value);
        }

        public String toString() {
            return this.value.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Set set = (Set)o;
            return Objects.equals(this.value, set.value);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }

    public static class Bool
    extends Term {
        final boolean value;

        public Bool(boolean value) {
            this.value = value;
        }

        @Override
        public org.biscuitsec.biscuit.datalog.Term convert(SymbolTable symbols) {
            return new Term.Bool(this.value);
        }

        public boolean getValue() {
            return this.value;
        }

        public String toString() {
            if (this.value) {
                return "true";
            }
            return "false";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bool bool = (Bool)o;
            return this.value == bool.value;
        }

        public int hashCode() {
            return Boolean.hashCode(this.value);
        }
    }

    public static class Date
    extends Term {
        final long value;

        public Date(long value) {
            this.value = value;
        }

        @Override
        public org.biscuitsec.biscuit.datalog.Term convert(SymbolTable symbols) {
            return new Term.Date(this.value);
        }

        public long getValue() {
            return this.value;
        }

        public String toString() {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_INSTANT;
            return Instant.ofEpochSecond(this.value).atOffset(ZoneOffset.ofTotalSeconds(0)).format(dateTimeFormatter);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Date date = (Date)o;
            return this.value == date.value;
        }

        public int hashCode() {
            return Long.hashCode(this.value);
        }
    }

    public static class Bytes
    extends Term {
        final byte[] value;

        public Bytes(byte[] value) {
            this.value = value;
        }

        @Override
        public org.biscuitsec.biscuit.datalog.Term convert(SymbolTable symbols) {
            return new Term.Bytes(this.value);
        }

        public byte[] getValue() {
            return Arrays.copyOf(this.value, this.value.length);
        }

        public String toString() {
            return "hex:" + Utils.byteArrayToHexString(this.value).toLowerCase();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bytes bytes = (Bytes)o;
            return Arrays.equals(this.value, bytes.value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }
    }

    public static class Integer
    extends Term {
        final long value;

        public Integer(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        @Override
        public org.biscuitsec.biscuit.datalog.Term convert(SymbolTable symbols) {
            return new Term.Integer(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Integer integer = (Integer)o;
            return this.value == integer.value;
        }

        public int hashCode() {
            return Long.hashCode(this.value);
        }
    }

    public static class Variable
    extends Term {
        final String value;

        public Variable(String value) {
            this.value = value;
        }

        @Override
        public org.biscuitsec.biscuit.datalog.Term convert(SymbolTable symbols) {
            return new Term.Variable(symbols.insert(this.value));
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "$" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return this.value.equals(variable.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static class Str
    extends Term {
        final String value;

        public Str(String value) {
            this.value = value;
        }

        @Override
        public org.biscuitsec.biscuit.datalog.Term convert(SymbolTable symbols) {
            return new Term.Str(symbols.insert(this.value));
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "\"" + this.value + "\"";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Str s = (Str)o;
            return Objects.equals(this.value, s.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

