/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.datalog;

import biscuit.format.schema.Schema;
import io.vavr.API;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.biscuitsec.biscuit.datalog.Rule;
import org.biscuitsec.biscuit.error.Error;

public class Check {
    private final Kind kind;
    private final List<Rule> queries;

    public Check(Kind kind, List<Rule> queries) {
        this.kind = kind;
        this.queries = queries;
    }

    public Kind kind() {
        return this.kind;
    }

    public List<Rule> queries() {
        return this.queries;
    }

    public Schema.CheckV2 serialize() {
        Schema.CheckV2.Builder b = Schema.CheckV2.newBuilder();
        switch (this.kind) {
            case All: {
                b.setKind(Schema.CheckV2.Kind.All);
            }
        }
        for (int i = 0; i < this.queries.size(); ++i) {
            b.addQueries(this.queries.get(i).serialize());
        }
        return b.build();
    }

    public static Either<Error.FormatError, Check> deserializeV2(Schema.CheckV2 check) {
        Kind kind;
        ArrayList<Rule> queries = new ArrayList<Rule>();
        switch (check.getKind()) {
            case One: {
                kind = Kind.One;
                break;
            }
            case All: {
                kind = Kind.All;
                break;
            }
            default: {
                kind = Kind.One;
            }
        }
        for (Schema.RuleV2 query : check.getQueriesList()) {
            Either<Error.FormatError, Rule> res = Rule.deserializeV2(query);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            queries.add((Rule)res.get());
        }
        return API.Right((Object)new Check(kind, queries));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Check check = (Check)o;
        if (this.kind != check.kind) {
            return false;
        }
        return Objects.equals(this.queries, check.queries);
    }

    public int hashCode() {
        int result = this.kind != null ? this.kind.hashCode() : 0;
        result = 31 * result + (this.queries != null ? this.queries.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Check{kind=" + this.kind + ", queries=" + this.queries + "}";
    }

    public static enum Kind {
        One,
        All;

    }
}

