/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.datalog;

import io.vavr.API;
import io.vavr.control.Either;
import java.util.List;
import org.biscuitsec.biscuit.datalog.Check;
import org.biscuitsec.biscuit.datalog.Fact;
import org.biscuitsec.biscuit.datalog.Rule;
import org.biscuitsec.biscuit.datalog.Scope;
import org.biscuitsec.biscuit.datalog.expressions.Expression;
import org.biscuitsec.biscuit.datalog.expressions.Op;
import org.biscuitsec.biscuit.error.Error;
import org.biscuitsec.biscuit.token.format.SerializedBiscuit;

public class SchemaVersion {
    private boolean containsScopes;
    private boolean containsCheckAll;
    private boolean containsV4;

    public SchemaVersion(List<Fact> facts, List<Rule> rules, List<Check> checks, List<Scope> scopes) {
        boolean bl = this.containsScopes = !scopes.isEmpty();
        if (!this.containsScopes) {
            for (Rule r : rules) {
                if (r.scopes().isEmpty()) continue;
                this.containsScopes = true;
                break;
            }
        }
        if (!this.containsScopes) {
            block1: for (Check check : checks) {
                for (Rule query : check.queries()) {
                    if (query.scopes().isEmpty()) continue;
                    this.containsScopes = true;
                    continue block1;
                }
            }
        }
        this.containsCheckAll = false;
        for (Check check : checks) {
            if (check.kind() != Check.Kind.All) continue;
            this.containsCheckAll = true;
            break;
        }
        this.containsV4 = false;
        block4: for (Check check : checks) {
            for (Rule query : check.queries()) {
                if (!SchemaVersion.containsV4Ops(query.expressions())) continue;
                this.containsV4 = true;
                continue block4;
            }
        }
    }

    public int version() {
        if (this.containsScopes || this.containsV4 || this.containsCheckAll) {
            return 4;
        }
        return SerializedBiscuit.MIN_SCHEMA_VERSION;
    }

    public Either<Error.FormatError, Void> checkCompatibility(int version) {
        if (version < 4) {
            if (this.containsScopes) {
                return API.Left((Object)new Error.FormatError.DeserializationError("v3 blocks must not have scopes"));
            }
            if (this.containsV4) {
                return API.Left((Object)new Error.FormatError.DeserializationError("v3 blocks must not have v4 operators (bitwise operators or !="));
            }
            if (this.containsCheckAll) {
                return API.Left((Object)new Error.FormatError.DeserializationError("v3 blocks must not use check all"));
            }
        }
        return API.Right(null);
    }

    public static boolean containsV4Ops(List<Expression> expressions) {
        for (Expression e : expressions) {
            for (Op op : e.getOps()) {
                if (!(op instanceof Op.Binary)) continue;
                Op.Binary b = (Op.Binary)op;
                switch (b.getOp()) {
                    case BitwiseAnd: 
                    case BitwiseOr: 
                    case BitwiseXor: 
                    case NotEqual: {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

