/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.datalog;

import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.List;
import org.biscuitsec.biscuit.datalog.SymbolTable;

public class TemporarySymbolTable {
    SymbolTable base;
    int offset;
    List<String> symbols;

    public TemporarySymbolTable(SymbolTable base) {
        this.offset = 1024 + base.currentOffset();
        this.base = base;
        this.symbols = new ArrayList<String>();
    }

    public Option<String> get_s(int i) {
        if (i >= this.offset) {
            if (i - this.offset < this.symbols.size()) {
                return Option.some((Object)this.symbols.get(i - this.offset));
            }
            return Option.none();
        }
        return this.base.get_s(i);
    }

    public long insert(String symbol) {
        Option<Long> opt = this.base.get(symbol);
        if (opt.isDefined()) {
            return (Long)opt.get();
        }
        int index = this.symbols.indexOf(symbol);
        if (index != -1) {
            return this.offset + index;
        }
        this.symbols.add(symbol);
        return this.symbols.size() - 1 + this.offset;
    }
}

