/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.datalog;

import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.biscuitsec.biscuit.datalog.Fact;
import org.biscuitsec.biscuit.datalog.FactSet;
import org.biscuitsec.biscuit.datalog.Origin;
import org.biscuitsec.biscuit.datalog.Rule;
import org.biscuitsec.biscuit.datalog.RuleSet;
import org.biscuitsec.biscuit.datalog.RunLimits;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.datalog.TrustedOrigins;
import org.biscuitsec.biscuit.error.Error;

public class World
implements Serializable {
    private final FactSet facts;
    private final RuleSet rules;

    public void add_fact(Origin origin, Fact fact) {
        this.facts.add(origin, fact);
    }

    public void add_rule(Long origin, TrustedOrigins scope, Rule rule) {
        this.rules.add(origin, scope, rule);
    }

    public void clearRules() {
        this.rules.clear();
    }

    public void run(SymbolTable symbols) throws Error {
        this.run(new RunLimits(), symbols);
    }

    public void run(RunLimits limits, SymbolTable symbols) throws Error {
        int iterations = 0;
        Instant limit = Instant.now().plus(limits.maxTime);
        do {
            FactSet newFacts = new FactSet();
            for (Map.Entry<TrustedOrigins, List<Tuple2<Long, Rule>>> entry : this.rules.rules.entrySet()) {
                for (Tuple2<Long, Rule> t : entry.getValue()) {
                    Supplier<Stream<Tuple2<Origin, Fact>>> factsSupplier = () -> this.facts.stream((TrustedOrigins)entry.getKey());
                    Stream<Either<Error, Tuple2<Origin, Fact>>> stream = ((Rule)t._2).apply(factsSupplier, (Long)t._1, symbols);
                    Iterator it = stream.iterator();
                    while (it.hasNext()) {
                        Either res = (Either)it.next();
                        if (Instant.now().compareTo(limit) >= 0) {
                            throw new Error.Timeout();
                        }
                        if (res.isRight()) {
                            Tuple2 t2 = (Tuple2)res.get();
                            newFacts.add((Origin)t2._1, (Fact)t2._2);
                            continue;
                        }
                        throw (Error)res.getLeft();
                    }
                }
            }
            int len = this.facts.size();
            this.facts.merge(newFacts);
            if (this.facts.size() == len) {
                return;
            }
            if (this.facts.size() < limits.maxFacts) continue;
            throw new Error.TooManyFacts();
        } while (++iterations < limits.maxIterations);
        throw new Error.TooManyIterations();
    }

    public final FactSet facts() {
        return this.facts;
    }

    public RuleSet rules() {
        return this.rules;
    }

    public final FactSet query_rule(Rule rule, Long origin, TrustedOrigins scope, SymbolTable symbols) throws Error {
        FactSet newFacts = new FactSet();
        Supplier<Stream<Tuple2<Origin, Fact>>> factsSupplier = () -> this.facts.stream(scope);
        Stream<Either<Error, Tuple2<Origin, Fact>>> stream = rule.apply(factsSupplier, origin, symbols);
        Iterator it = stream.iterator();
        while (it.hasNext()) {
            Either res = (Either)it.next();
            if (res.isRight()) {
                Tuple2 t2 = (Tuple2)res.get();
                newFacts.add((Origin)t2._1, (Fact)t2._2);
                continue;
            }
            throw (Error)res.getLeft();
        }
        return newFacts;
    }

    public final boolean query_match(Rule rule, Long origin, TrustedOrigins scope, SymbolTable symbols) throws Error {
        return rule.find_match(this.facts, origin, scope, symbols);
    }

    public final boolean query_match_all(Rule rule, TrustedOrigins scope, SymbolTable symbols) throws Error {
        return rule.check_match_all(this.facts, scope, symbols);
    }

    public World() {
        this.facts = new FactSet();
        this.rules = new RuleSet();
    }

    public World(FactSet facts) {
        this.facts = facts.clone();
        this.rules = new RuleSet();
    }

    public World(FactSet facts, RuleSet rules) {
        this.facts = facts.clone();
        this.rules = rules.clone();
    }

    public World(World w) {
        this.facts = w.facts.clone();
        this.rules = w.rules.clone();
    }

    public String print(SymbolTable symbol_table) {
        StringBuilder s = new StringBuilder();
        s.append("World {\n\t\tfacts: [");
        for (Map.Entry<Origin, HashSet<Fact>> entry : this.facts.facts().entrySet()) {
            s.append("\n\t\t\t" + entry.getKey() + ":");
            for (Fact f : entry.getValue()) {
                s.append("\n\t\t\t\t");
                s.append(symbol_table.print_fact(f));
            }
        }
        s.append("\n\t\t]\n\t\trules: [");
        Iterator it = this.rules.stream().iterator();
        while (it.hasNext()) {
            Rule r = (Rule)it.next();
            s.append("\n\t\t\t");
            s.append(symbol_table.print_rule(r));
        }
        s.append("\n\t\t]\n\t}");
        return s.toString();
    }
}

