/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token;

import io.vavr.API;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.biscuitsec.biscuit.crypto.PublicKey;
import org.biscuitsec.biscuit.datalog.FactSet;
import org.biscuitsec.biscuit.datalog.Origin;
import org.biscuitsec.biscuit.datalog.RuleSet;
import org.biscuitsec.biscuit.datalog.RunLimits;
import org.biscuitsec.biscuit.datalog.Scope;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.datalog.TrustedOrigins;
import org.biscuitsec.biscuit.datalog.World;
import org.biscuitsec.biscuit.error.Error;
import org.biscuitsec.biscuit.error.FailedCheck;
import org.biscuitsec.biscuit.error.LogicError;
import org.biscuitsec.biscuit.token.Biscuit;
import org.biscuitsec.biscuit.token.Block;
import org.biscuitsec.biscuit.token.Policy;
import org.biscuitsec.biscuit.token.builder.Check;
import org.biscuitsec.biscuit.token.builder.Expression;
import org.biscuitsec.biscuit.token.builder.Fact;
import org.biscuitsec.biscuit.token.builder.Predicate;
import org.biscuitsec.biscuit.token.builder.Rule;
import org.biscuitsec.biscuit.token.builder.Term;
import org.biscuitsec.biscuit.token.builder.Utils;
import org.biscuitsec.biscuit.token.builder.parser.Error;
import org.biscuitsec.biscuit.token.builder.parser.Parser;

public class Authorizer {
    Biscuit token;
    List<Check> checks;
    List<Policy> policies;
    List<Scope> scopes;
    HashMap<Long, List<Long>> publicKeyToBlockId;
    World world;
    SymbolTable symbols;

    private Authorizer(Biscuit token, World w) throws Error.FailedLogic {
        this.token = token;
        this.world = w;
        this.symbols = new SymbolTable(this.token.symbols);
        this.checks = new ArrayList<Check>();
        this.policies = new ArrayList<Policy>();
        this.scopes = new ArrayList<Scope>();
        this.publicKeyToBlockId = new HashMap();
        this.update_on_token();
    }

    public Authorizer() {
        this.world = new World();
        this.symbols = Biscuit.default_symbol_table();
        this.checks = new ArrayList<Check>();
        this.policies = new ArrayList<Policy>();
        this.scopes = new ArrayList<Scope>();
        this.publicKeyToBlockId = new HashMap();
    }

    private Authorizer(Biscuit token, List<Check> checks, List<Policy> policies, World world, SymbolTable symbols) {
        this.token = token;
        this.checks = checks;
        this.policies = policies;
        this.world = world;
        this.symbols = symbols;
        this.scopes = new ArrayList<Scope>();
        this.publicKeyToBlockId = new HashMap();
    }

    public static Authorizer make(Biscuit token) throws Error.FailedLogic {
        return new Authorizer(token, new World());
    }

    public Authorizer clone() {
        return new Authorizer(this.token, new ArrayList<Check>(this.checks), new ArrayList<Policy>(this.policies), new World(this.world), new SymbolTable(this.symbols));
    }

    public void update_on_token() throws Error.FailedLogic {
        if (this.token != null) {
            for (long i = 0L; i < (long)this.token.blocks.size(); ++i) {
                Block block = (Block)this.token.blocks.get((int)i);
                if (!block.externalKey.isDefined()) continue;
                PublicKey pk = (PublicKey)block.externalKey.get();
                long newKeyId = this.symbols.insert(pk);
                if (!this.publicKeyToBlockId.containsKey(newKeyId)) {
                    ArrayList<Long> l = new ArrayList<Long>();
                    l.add(i + 1L);
                    this.publicKeyToBlockId.put(newKeyId, l);
                    continue;
                }
                this.publicKeyToBlockId.get(newKeyId).add(i + 1L);
            }
            TrustedOrigins authorityTrustedOrigins = TrustedOrigins.fromScopes(this.token.authority.scopes, TrustedOrigins.defaultOrigins(), 0L, this.publicKeyToBlockId);
            for (org.biscuitsec.biscuit.datalog.Fact fact : this.token.authority.facts) {
                org.biscuitsec.biscuit.datalog.Fact converted_fact = Fact.convert_from(fact, this.token.symbols).convert(this.symbols);
                this.world.add_fact(new Origin(0), converted_fact);
            }
            for (org.biscuitsec.biscuit.datalog.Rule rule : this.token.authority.rules) {
                Rule _rule = Rule.convert_from(rule, this.token.symbols);
                org.biscuitsec.biscuit.datalog.Rule converted_rule = _rule.convert(this.symbols);
                Either<String, Rule> res = _rule.validate_variables();
                if (res.isLeft()) {
                    throw new Error.FailedLogic(new LogicError.InvalidBlockRule(0L, this.token.symbols.print_rule(converted_rule)));
                }
                TrustedOrigins ruleTrustedOrigins = TrustedOrigins.fromScopes(converted_rule.scopes(), authorityTrustedOrigins, 0L, this.publicKeyToBlockId);
                this.world.add_rule(0L, ruleTrustedOrigins, converted_rule);
            }
            for (long i = 0L; i < (long)this.token.blocks.size(); ++i) {
                Block block = (Block)this.token.blocks.get((int)i);
                TrustedOrigins blockTrustedOrigins = TrustedOrigins.fromScopes(block.scopes, TrustedOrigins.defaultOrigins(), i + 1L, this.publicKeyToBlockId);
                SymbolTable blockSymbols = this.token.symbols;
                if (block.externalKey.isDefined()) {
                    blockSymbols = new SymbolTable(block.symbols.symbols, block.publicKeys());
                }
                for (org.biscuitsec.biscuit.datalog.Fact fact : block.facts) {
                    org.biscuitsec.biscuit.datalog.Fact converted_fact = Fact.convert_from(fact, blockSymbols).convert(this.symbols);
                    this.world.add_fact(new Origin(i + 1L), converted_fact);
                }
                for (org.biscuitsec.biscuit.datalog.Rule rule : block.rules) {
                    Rule _rule = Rule.convert_from(rule, blockSymbols);
                    org.biscuitsec.biscuit.datalog.Rule converted_rule = _rule.convert(this.symbols);
                    Either<String, Rule> res = _rule.validate_variables();
                    if (res.isLeft()) {
                        throw new Error.FailedLogic(new LogicError.InvalidBlockRule(0L, this.symbols.print_rule(converted_rule)));
                    }
                    TrustedOrigins ruleTrustedOrigins = TrustedOrigins.fromScopes(converted_rule.scopes(), blockTrustedOrigins, i + 1L, this.publicKeyToBlockId);
                    this.world.add_rule(i + 1L, ruleTrustedOrigins, converted_rule);
                }
            }
        }
    }

    public Authorizer add_token(Biscuit token) throws Error.FailedLogic {
        if (this.token != null) {
            throw new Error.FailedLogic(new LogicError.AuthorizerNotEmpty());
        }
        this.token = token;
        this.update_on_token();
        return this;
    }

    public Authorizer add_fact(Fact fact) {
        this.world.add_fact(Origin.authorizer(), fact.convert(this.symbols));
        return this;
    }

    public Authorizer add_fact(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Fact>> res = Parser.fact(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_fact((Fact)t._2);
    }

    public Authorizer add_rule(Rule rule) {
        org.biscuitsec.biscuit.datalog.Rule r = rule.convert(this.symbols);
        TrustedOrigins ruleTrustedOrigins = TrustedOrigins.fromScopes(r.scopes(), this.authorizerTrustedOrigins(), Long.MAX_VALUE, this.publicKeyToBlockId);
        this.world.add_rule(Long.MAX_VALUE, ruleTrustedOrigins, r);
        return this;
    }

    public TrustedOrigins authorizerTrustedOrigins() {
        return TrustedOrigins.fromScopes(this.scopes, TrustedOrigins.defaultOrigins(), Long.MAX_VALUE, this.publicKeyToBlockId);
    }

    public Authorizer add_rule(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Rule>> res = Parser.rule(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_rule((Rule)t._2);
    }

    public Authorizer add_check(Check check) {
        this.checks.add(check);
        return this;
    }

    public Authorizer add_check(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Check>> res = Parser.check(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_check((Check)t._2);
    }

    public Authorizer set_time() throws Error.Language {
        this.world.add_fact(Origin.authorizer(), Utils.fact("time", List.of(Utils.date(new Date()))).convert(this.symbols));
        return this;
    }

    public List<String> get_revocation_ids() throws org.biscuitsec.biscuit.error.Error {
        ArrayList<String> ids = new ArrayList<String>();
        Rule getRevocationIds = Utils.rule("revocation_id", List.of(Utils.var("id")), List.of(Utils.pred("revocation_id", List.of(Utils.var("id")))));
        this.query(getRevocationIds).stream().forEach(fact -> fact.terms().stream().forEach(id -> {
            if (id instanceof Term.Str) {
                ids.add(((Term.Str)id).getValue());
            }
        }));
        return ids;
    }

    public Authorizer allow() {
        ArrayList<Rule> q = new ArrayList<Rule>();
        q.add(Utils.constrained_rule("allow", new ArrayList<Term>(), new ArrayList<Predicate>(), List.of(new Expression.Value(new Term.Bool(true)))));
        this.policies.add(new Policy(q, Policy.Kind.Allow));
        return this;
    }

    public Authorizer deny() {
        ArrayList<Rule> q = new ArrayList<Rule>();
        q.add(Utils.constrained_rule("deny", new ArrayList<Term>(), new ArrayList<Predicate>(), List.of(new Expression.Value(new Term.Bool(true)))));
        this.policies.add(new Policy(q, Policy.Kind.Deny));
        return this;
    }

    public Authorizer add_policy(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Policy>> res = Parser.policy(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        this.policies.add((Policy)t._2);
        return this;
    }

    public Authorizer add_policy(Policy p) {
        this.policies.add(p);
        return this;
    }

    public Authorizer add_scope(Scope s) {
        this.scopes.add(s);
        return this;
    }

    public Set<Fact> query(Rule query) throws org.biscuitsec.biscuit.error.Error {
        return this.query(query, new RunLimits());
    }

    public Set<Fact> query(String s) throws org.biscuitsec.biscuit.error.Error {
        Either<Error, Tuple2<String, Rule>> res = Parser.rule(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.query((Rule)t._2);
    }

    public Set<Fact> query(Rule query, RunLimits limits) throws org.biscuitsec.biscuit.error.Error {
        this.world.run(limits, this.symbols);
        org.biscuitsec.biscuit.datalog.Rule rule = query.convert(this.symbols);
        TrustedOrigins ruleTrustedorigins = TrustedOrigins.fromScopes(rule.scopes(), TrustedOrigins.defaultOrigins(), Long.MAX_VALUE, this.publicKeyToBlockId);
        FactSet facts = this.world.query_rule(rule, Long.MAX_VALUE, ruleTrustedorigins, this.symbols);
        HashSet<Fact> s = new HashSet<Fact>();
        Iterator it = facts.stream().iterator();
        while (it.hasNext()) {
            org.biscuitsec.biscuit.datalog.Fact f = (org.biscuitsec.biscuit.datalog.Fact)it.next();
            s.add(Fact.convert_from(f, this.symbols));
        }
        return s;
    }

    public Set<Fact> query(String s, RunLimits limits) throws org.biscuitsec.biscuit.error.Error {
        Either<Error, Tuple2<String, Rule>> res = Parser.rule(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.query((Rule)t._2, limits);
    }

    public Long authorize() throws org.biscuitsec.biscuit.error.Error {
        return this.authorize(new RunLimits());
    }

    public Long authorize(RunLimits limits) throws org.biscuitsec.biscuit.error.Error {
        boolean successful;
        int i;
        Instant timeLimit = Instant.now().plus(limits.maxTime);
        LinkedList<FailedCheck> errors = new LinkedList<FailedCheck>();
        Option policy_result = Option.none();
        TrustedOrigins authorizerTrustedOrigins = this.authorizerTrustedOrigins();
        this.world.run(limits, this.symbols);
        for (i = 0; i < this.checks.size(); ++i) {
            org.biscuitsec.biscuit.datalog.Check c = this.checks.get(i).convert(this.symbols);
            successful = false;
            for (int j = 0; j < c.queries().size(); ++j) {
                boolean res = false;
                org.biscuitsec.biscuit.datalog.Rule query = c.queries().get(j);
                TrustedOrigins ruleTrustedOrigins = TrustedOrigins.fromScopes(query.scopes(), authorizerTrustedOrigins, Long.MAX_VALUE, this.publicKeyToBlockId);
                switch (c.kind()) {
                    case One: {
                        res = this.world.query_match(query, Long.MAX_VALUE, ruleTrustedOrigins, this.symbols);
                        break;
                    }
                    case All: {
                        res = this.world.query_match_all(query, ruleTrustedOrigins, this.symbols);
                    }
                }
                if (Instant.now().compareTo(timeLimit) >= 0) {
                    throw new Error.Timeout();
                }
                if (!res) continue;
                successful = true;
                break;
            }
            if (successful) continue;
            errors.add(new FailedCheck.FailedAuthorizer(i, this.symbols.print_check(c)));
        }
        if (this.token != null) {
            TrustedOrigins authorityTrustedOrigins = TrustedOrigins.fromScopes(this.token.authority.scopes, TrustedOrigins.defaultOrigins(), 0L, this.publicKeyToBlockId);
            for (int j = 0; j < this.token.authority.checks.size(); ++j) {
                successful = false;
                Check c = Check.convert_from(this.token.authority.checks.get(j), this.token.symbols);
                org.biscuitsec.biscuit.datalog.Check check = c.convert(this.symbols);
                for (int k = 0; k < check.queries().size(); ++k) {
                    boolean res = false;
                    org.biscuitsec.biscuit.datalog.Rule query = check.queries().get(k);
                    TrustedOrigins ruleTrustedOrigins = TrustedOrigins.fromScopes(query.scopes(), authorityTrustedOrigins, 0L, this.publicKeyToBlockId);
                    switch (check.kind()) {
                        case One: {
                            res = this.world.query_match(query, 0L, ruleTrustedOrigins, this.symbols);
                            break;
                        }
                        case All: {
                            res = this.world.query_match_all(query, ruleTrustedOrigins, this.symbols);
                        }
                    }
                    if (Instant.now().compareTo(timeLimit) >= 0) {
                        throw new Error.Timeout();
                    }
                    if (!res) continue;
                    successful = true;
                    break;
                }
                if (successful) continue;
                errors.add(new FailedCheck.FailedBlock(0L, j, this.symbols.print_check(check)));
            }
        }
        block16: for (i = 0; i < this.policies.size(); ++i) {
            Policy policy = this.policies.get(i);
            for (int j = 0; j < policy.queries.size(); ++j) {
                org.biscuitsec.biscuit.datalog.Rule query = policy.queries.get(j).convert(this.symbols);
                TrustedOrigins policyTrustedOrigins = TrustedOrigins.fromScopes(query.scopes(), authorizerTrustedOrigins, Long.MAX_VALUE, this.publicKeyToBlockId);
                boolean res = this.world.query_match(query, Long.MAX_VALUE, policyTrustedOrigins, this.symbols);
                if (Instant.now().compareTo(timeLimit) >= 0) {
                    throw new Error.Timeout();
                }
                if (!res) continue;
                if (this.policies.get((int)i).kind == Policy.Kind.Allow) {
                    policy_result = Option.some((Object)API.Right((Object)i));
                    break block16;
                }
                policy_result = Option.some((Object)API.Left((Object)i));
                break block16;
            }
        }
        if (this.token != null) {
            for (i = 0; i < this.token.blocks.size(); ++i) {
                Block b = (Block)this.token.blocks.get(i);
                TrustedOrigins blockTrustedOrigins = TrustedOrigins.fromScopes(b.scopes, TrustedOrigins.defaultOrigins(), i + 1, this.publicKeyToBlockId);
                SymbolTable blockSymbols = this.token.symbols;
                if (b.externalKey.isDefined()) {
                    blockSymbols = new SymbolTable(b.symbols.symbols, b.publicKeys());
                }
                for (int j = 0; j < b.checks.size(); ++j) {
                    boolean successful2 = false;
                    Check c = Check.convert_from(b.checks.get(j), blockSymbols);
                    org.biscuitsec.biscuit.datalog.Check check = c.convert(this.symbols);
                    for (int k = 0; k < check.queries().size(); ++k) {
                        boolean res = false;
                        org.biscuitsec.biscuit.datalog.Rule query = check.queries().get(k);
                        TrustedOrigins ruleTrustedOrigins = TrustedOrigins.fromScopes(query.scopes(), blockTrustedOrigins, i + 1, this.publicKeyToBlockId);
                        switch (check.kind()) {
                            case One: {
                                res = this.world.query_match(query, (long)i + 1L, ruleTrustedOrigins, this.symbols);
                                break;
                            }
                            case All: {
                                res = this.world.query_match_all(query, ruleTrustedOrigins, this.symbols);
                            }
                        }
                        if (Instant.now().compareTo(timeLimit) >= 0) {
                            throw new Error.Timeout();
                        }
                        if (!res) continue;
                        successful2 = true;
                        break;
                    }
                    if (successful2) continue;
                    errors.add(new FailedCheck.FailedBlock(i + 1, j, this.symbols.print_check(check)));
                }
            }
        }
        if (policy_result.isDefined()) {
            Either e = (Either)policy_result.get();
            if (e.isRight()) {
                if (errors.isEmpty()) {
                    return ((Integer)e.get()).longValue();
                }
                throw new Error.FailedLogic(new LogicError.Unauthorized(new LogicError.MatchedPolicy.Allow(((Integer)e.get()).intValue()), errors));
            }
            throw new Error.FailedLogic(new LogicError.Unauthorized(new LogicError.MatchedPolicy.Deny(((Integer)e.getLeft()).intValue()), errors));
        }
        throw new Error.FailedLogic(new LogicError.NoMatchingPolicy(errors));
    }

    public String print_world() {
        int j;
        StringBuilder facts = new StringBuilder();
        for (Map.Entry<Origin, HashSet<org.biscuitsec.biscuit.datalog.Fact>> entry : this.world.facts().facts().entrySet()) {
            facts.append("\n\t\t" + entry.getKey() + ":");
            for (org.biscuitsec.biscuit.datalog.Fact f : entry.getValue()) {
                facts.append("\n\t\t\t");
                facts.append(this.symbols.print_fact(f));
            }
        }
        List rules = this.world.rules().stream().map(r -> this.symbols.print_rule((org.biscuitsec.biscuit.datalog.Rule)r)).collect(Collectors.toList());
        ArrayList<CallSite> checks = new ArrayList<CallSite>();
        for (j = 0; j < this.checks.size(); ++j) {
            checks.add((CallSite)((Object)("Authorizer[" + j + "]: " + this.checks.get(j).toString())));
        }
        if (this.token != null) {
            for (j = 0; j < this.token.authority.checks.size(); ++j) {
                checks.add((CallSite)((Object)("Block[0][" + j + "]: " + this.token.symbols.print_check(this.token.authority.checks.get(j)))));
            }
            for (int i = 0; i < this.token.blocks.size(); ++i) {
                Block b = (Block)this.token.blocks.get(i);
                SymbolTable blockSymbols = this.token.symbols;
                if (b.externalKey.isDefined()) {
                    blockSymbols = new SymbolTable(b.symbols.symbols, b.publicKeys());
                }
                for (int j2 = 0; j2 < b.checks.size(); ++j2) {
                    checks.add((CallSite)((Object)("Block[" + (i + 1) + "][" + j2 + "]: " + blockSymbols.print_check(b.checks.get(j2)))));
                }
            }
        }
        return "World {\n\tfacts: [" + facts.toString() + "\n\t],\n\trules: [\n\t\t" + String.join((CharSequence)",\n\t\t", rules) + "\n\t],\n\tchecks: [\n\t\t" + String.join((CharSequence)",\n\t\t", checks) + "\n\t]\n}";
    }

    public FactSet facts() {
        return this.world.facts();
    }

    public RuleSet rules() {
        return this.world.rules();
    }

    public List<Tuple2<Long, List<Check>>> checks() {
        ArrayList<Tuple2<Long, List<Check>>> allChecks = new ArrayList<Tuple2<Long, List<Check>>>();
        if (!this.checks.isEmpty()) {
            allChecks.add(new Tuple2((Object)Long.MAX_VALUE, this.checks));
        }
        ArrayList<Check> authorityChecks = new ArrayList<Check>();
        for (org.biscuitsec.biscuit.datalog.Check check : this.token.authority.checks) {
            authorityChecks.add(Check.convert_from(check, this.token.symbols));
        }
        if (!authorityChecks.isEmpty()) {
            allChecks.add(new Tuple2((Object)0L, authorityChecks));
        }
        long count = 1L;
        for (Block block : this.token.blocks) {
            ArrayList<Check> blockChecks = new ArrayList<Check>();
            if (block.externalKey.isDefined()) {
                SymbolTable blockSymbols = new SymbolTable(block.symbols.symbols, block.publicKeys());
                for (org.biscuitsec.biscuit.datalog.Check check : block.checks) {
                    blockChecks.add(Check.convert_from(check, blockSymbols));
                }
            } else {
                for (org.biscuitsec.biscuit.datalog.Check check : block.checks) {
                    blockChecks.add(Check.convert_from(check, this.token.symbols));
                }
            }
            if (!blockChecks.isEmpty()) {
                allChecks.add((Tuple2<Long, List<Check>>)new Tuple2((Object)count, blockChecks));
            }
            ++count;
        }
        return allChecks;
    }

    public List<Policy> policies() {
        return this.policies;
    }
}

