/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token;

import biscuit.format.schema.Schema;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.biscuitsec.biscuit.crypto.PublicKey;
import org.biscuitsec.biscuit.error.Error;

public class ThirdPartyBlockContents {
    byte[] payload;
    byte[] signature;
    PublicKey publicKey;

    ThirdPartyBlockContents(byte[] payload, byte[] signature, PublicKey publicKey) {
        this.payload = payload;
        this.signature = signature;
        this.publicKey = publicKey;
    }

    public Schema.ThirdPartyBlockContents serialize() throws Error.FormatError.SerializationError {
        Schema.ThirdPartyBlockContents.Builder b = Schema.ThirdPartyBlockContents.newBuilder();
        b.setPayload(ByteString.copyFrom((byte[])this.payload));
        b.setExternalSignature(b.getExternalSignatureBuilder().setSignature(ByteString.copyFrom((byte[])this.signature)).setPublicKey(this.publicKey.serialize()).build());
        return b.build();
    }

    public static ThirdPartyBlockContents deserialize(Schema.ThirdPartyBlockContents b) throws Error.FormatError.DeserializationError {
        byte[] payload = b.getPayload().toByteArray();
        byte[] signature = b.getExternalSignature().getSignature().toByteArray();
        PublicKey publicKey = PublicKey.deserialize(b.getExternalSignature().getPublicKey());
        return new ThirdPartyBlockContents(payload, signature, publicKey);
    }

    public static ThirdPartyBlockContents fromBytes(byte[] slice) throws InvalidProtocolBufferException, Error.FormatError.DeserializationError {
        return ThirdPartyBlockContents.deserialize(Schema.ThirdPartyBlockContents.parseFrom(slice));
    }

    public byte[] toBytes() throws IOException, Error.FormatError.SerializationError {
        Schema.ThirdPartyBlockContents b = this.serialize();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        b.writeTo(stream);
        return stream.toByteArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThirdPartyBlockContents that = (ThirdPartyBlockContents)o;
        if (!Arrays.equals(this.payload, that.payload)) {
            return false;
        }
        if (!Arrays.equals(this.signature, that.signature)) {
            return false;
        }
        return Objects.equals(this.publicKey, that.publicKey);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.payload);
        result = 31 * result + Arrays.hashCode(this.signature);
        result = 31 * result + (this.publicKey != null ? this.publicKey.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ThirdPartyBlockContents{payload=" + Arrays.toString(this.payload) + ", signature=" + Arrays.toString(this.signature) + ", publicKey=" + this.publicKey + "}";
    }
}

