/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token;

import biscuit.format.schema.Schema;
import com.google.protobuf.InvalidProtocolBufferException;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Objects;
import org.biscuitsec.biscuit.crypto.KeyPair;
import org.biscuitsec.biscuit.crypto.PublicKey;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.error.Error;
import org.biscuitsec.biscuit.token.ThirdPartyBlockContents;
import org.biscuitsec.biscuit.token.builder.Block;

public class ThirdPartyBlockRequest {
    PublicKey previousKey;

    ThirdPartyBlockRequest(PublicKey previousKey) {
        this.previousKey = previousKey;
    }

    public Either<Error.FormatError, ThirdPartyBlockContents> createBlock(KeyPair keyPair, Block blockBuilder) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        SymbolTable symbols = new SymbolTable();
        org.biscuitsec.biscuit.token.Block block = blockBuilder.build(symbols, (Option<PublicKey>)Option.some((Object)keyPair.public_key()));
        Either<Error.FormatError, byte[]> res = block.to_bytes();
        if (res.isLeft()) {
            return Either.left((Object)((Error.FormatError)res.getLeft()));
        }
        byte[] serializedBlock = (byte[])res.get();
        Signature sgr = KeyPair.generateSignature(keyPair.public_key().algorithm);
        sgr.initSign((PrivateKey)keyPair.private_key);
        sgr.update(serializedBlock);
        ByteBuffer algo_buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        algo_buf.putInt(Schema.PublicKey.Algorithm.Ed25519.getNumber());
        algo_buf.flip();
        sgr.update(algo_buf);
        sgr.update(this.previousKey.toBytes());
        byte[] signature = sgr.sign();
        PublicKey publicKey = keyPair.public_key();
        return Either.right((Object)new ThirdPartyBlockContents(serializedBlock, signature, publicKey));
    }

    public Schema.ThirdPartyBlockRequest serialize() throws Error.FormatError.SerializationError {
        Schema.ThirdPartyBlockRequest.Builder b = Schema.ThirdPartyBlockRequest.newBuilder();
        b.setPreviousKey(this.previousKey.serialize());
        return b.build();
    }

    public static ThirdPartyBlockRequest deserialize(Schema.ThirdPartyBlockRequest b) throws Error.FormatError.DeserializationError {
        PublicKey previousKey = PublicKey.deserialize(b.getPreviousKey());
        return new ThirdPartyBlockRequest(previousKey);
    }

    public static ThirdPartyBlockRequest fromBytes(byte[] slice) throws InvalidProtocolBufferException, Error.FormatError.DeserializationError {
        return ThirdPartyBlockRequest.deserialize(Schema.ThirdPartyBlockRequest.parseFrom(slice));
    }

    public byte[] toBytes() throws IOException, Error.FormatError.SerializationError {
        Schema.ThirdPartyBlockRequest b = this.serialize();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        b.writeTo(stream);
        return stream.toByteArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThirdPartyBlockRequest that = (ThirdPartyBlockRequest)o;
        return Objects.equals(this.previousKey, that.previousKey);
    }

    public int hashCode() {
        return this.previousKey != null ? this.previousKey.hashCode() : 0;
    }

    public String toString() {
        return "ThirdPartyBlockRequest{previousKey=" + this.previousKey + "}";
    }
}

