/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token.builder;

import io.vavr.Tuple2;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.biscuitsec.biscuit.crypto.KeyPair;
import org.biscuitsec.biscuit.crypto.PublicKey;
import org.biscuitsec.biscuit.datalog.SchemaVersion;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.error.Error;
import org.biscuitsec.biscuit.token.UnverifiedBiscuit;
import org.biscuitsec.biscuit.token.builder.Block;
import org.biscuitsec.biscuit.token.builder.Check;
import org.biscuitsec.biscuit.token.builder.Fact;
import org.biscuitsec.biscuit.token.builder.Rule;
import org.biscuitsec.biscuit.token.builder.Scope;
import org.biscuitsec.biscuit.token.builder.Utils;
import org.biscuitsec.biscuit.token.builder.parser.Error;
import org.biscuitsec.biscuit.token.builder.parser.Parser;

public class Biscuit {
    SecureRandom rng;
    KeyPair root;
    String context;
    List<Fact> facts;
    List<Rule> rules;
    List<Check> checks;
    List<Scope> scopes;
    Option<Integer> root_key_id;

    public Biscuit(SecureRandom rng, KeyPair root) {
        this.rng = rng;
        this.root = root;
        this.context = "";
        this.facts = new ArrayList<Fact>();
        this.rules = new ArrayList<Rule>();
        this.checks = new ArrayList<Check>();
        this.scopes = new ArrayList<Scope>();
        this.root_key_id = Option.none();
    }

    public Biscuit(SecureRandom rng, KeyPair root, Option<Integer> root_key_id) {
        this.rng = rng;
        this.root = root;
        this.context = "";
        this.facts = new ArrayList<Fact>();
        this.rules = new ArrayList<Rule>();
        this.checks = new ArrayList<Check>();
        this.scopes = new ArrayList<Scope>();
        this.root_key_id = root_key_id;
    }

    public Biscuit(SecureRandom rng, KeyPair root, Option<Integer> root_key_id, Block block) {
        this.rng = rng;
        this.root = root;
        this.root_key_id = root_key_id;
        this.context = block.context;
        this.facts = block.facts;
        this.rules = block.rules;
        this.checks = block.checks;
        this.scopes = block.scopes;
    }

    public Biscuit add_authority_fact(Fact f) throws Error.Language {
        f.validate();
        this.facts.add(f);
        return this;
    }

    public Biscuit add_authority_fact(String s) throws Error.Parser, Error.Language {
        Either<Error, Tuple2<String, Fact>> res = Parser.fact(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_authority_fact((Fact)t._2);
    }

    public Biscuit add_authority_rule(Rule rule) {
        this.rules.add(rule);
        return this;
    }

    public Biscuit add_authority_rule(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Rule>> res = Parser.rule(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_authority_rule((Rule)t._2);
    }

    public Biscuit add_authority_check(Check c) {
        this.checks.add(c);
        return this;
    }

    public Biscuit add_authority_check(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Check>> res = Parser.check(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_authority_check((Check)t._2);
    }

    public Biscuit set_context(String context) {
        this.context = context;
        return this;
    }

    public Biscuit add_scope(Scope scope) {
        this.scopes.add(scope);
        return this;
    }

    public void set_root_key_id(Integer i) {
        this.root_key_id = Option.some((Object)i);
    }

    public org.biscuitsec.biscuit.token.Biscuit build() throws org.biscuitsec.biscuit.error.Error {
        return this.build(UnverifiedBiscuit.default_symbol_table());
    }

    private org.biscuitsec.biscuit.token.Biscuit build(SymbolTable symbols) throws org.biscuitsec.biscuit.error.Error {
        int symbol_start = symbols.currentOffset();
        int publicKeyStart = symbols.currentPublicKeyOffset();
        ArrayList<org.biscuitsec.biscuit.datalog.Fact> facts = new ArrayList<org.biscuitsec.biscuit.datalog.Fact>();
        for (Fact fact : this.facts) {
            facts.add(fact.convert(symbols));
        }
        ArrayList<org.biscuitsec.biscuit.datalog.Rule> rules = new ArrayList<org.biscuitsec.biscuit.datalog.Rule>();
        for (Rule rule : this.rules) {
            rules.add(rule.convert(symbols));
        }
        ArrayList<org.biscuitsec.biscuit.datalog.Check> arrayList = new ArrayList<org.biscuitsec.biscuit.datalog.Check>();
        for (Check check : this.checks) {
            arrayList.add(check.convert(symbols));
        }
        ArrayList<org.biscuitsec.biscuit.datalog.Scope> arrayList2 = new ArrayList<org.biscuitsec.biscuit.datalog.Scope>();
        for (Scope s : this.scopes) {
            arrayList2.add(s.convert(symbols));
        }
        SchemaVersion schemaVersion = new SchemaVersion(facts, rules, arrayList, arrayList2);
        SymbolTable block_symbols = new SymbolTable();
        for (int i = symbol_start; i < symbols.symbols.size(); ++i) {
            block_symbols.add(symbols.symbols.get(i));
        }
        ArrayList<PublicKey> publicKeys = new ArrayList<PublicKey>();
        for (int i = publicKeyStart; i < symbols.currentPublicKeyOffset(); ++i) {
            publicKeys.add(symbols.publicKeys().get(i));
        }
        org.biscuitsec.biscuit.token.Block authority_block = new org.biscuitsec.biscuit.token.Block(block_symbols, this.context, facts, rules, arrayList, arrayList2, publicKeys, (Option<PublicKey>)Option.none(), schemaVersion.version());
        if (this.root_key_id.isDefined()) {
            return org.biscuitsec.biscuit.token.Biscuit.make(this.rng, this.root, (Integer)this.root_key_id.get(), authority_block);
        }
        return org.biscuitsec.biscuit.token.Biscuit.make(this.rng, this.root, authority_block);
    }

    public Biscuit add_right(String resource, String right) throws Error.Language {
        return this.add_authority_fact(Utils.fact("right", Arrays.asList(Utils.string(resource), Utils.s(right))));
    }
}

