/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token.builder;

import io.vavr.Tuple2;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.biscuitsec.biscuit.crypto.PublicKey;
import org.biscuitsec.biscuit.datalog.Check;
import org.biscuitsec.biscuit.datalog.SchemaVersion;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.error.Error;
import org.biscuitsec.biscuit.token.UnverifiedBiscuit;
import org.biscuitsec.biscuit.token.builder.Check;
import org.biscuitsec.biscuit.token.builder.Expression;
import org.biscuitsec.biscuit.token.builder.Fact;
import org.biscuitsec.biscuit.token.builder.Rule;
import org.biscuitsec.biscuit.token.builder.Scope;
import org.biscuitsec.biscuit.token.builder.Utils;
import org.biscuitsec.biscuit.token.builder.parser.Error;
import org.biscuitsec.biscuit.token.builder.parser.Parser;

public class Block {
    String context = "";
    List<Fact> facts = new ArrayList<Fact>();
    List<Rule> rules = new ArrayList<Rule>();
    List<Check> checks = new ArrayList<Check>();
    List<Scope> scopes = new ArrayList<Scope>();

    public Block add_fact(Fact f) {
        this.facts.add(f);
        return this;
    }

    public Block add_fact(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Fact>> res = Parser.fact(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_fact((Fact)t._2);
    }

    public Block add_rule(Rule rule) {
        this.rules.add(rule);
        return this;
    }

    public Block add_rule(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Rule>> res = Parser.rule(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_rule((Rule)t._2);
    }

    public Block add_check(Check check) {
        this.checks.add(check);
        return this;
    }

    public Block add_check(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Check>> res = Parser.check(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_check((Check)t._2);
    }

    public Block add_scope(Scope scope) {
        this.scopes.add(scope);
        return this;
    }

    public Block set_context(String context) {
        this.context = context;
        return this;
    }

    public org.biscuitsec.biscuit.token.Block build() {
        return this.build(UnverifiedBiscuit.default_symbol_table(), (Option<PublicKey>)Option.none());
    }

    public org.biscuitsec.biscuit.token.Block build(Option<PublicKey> externalKey) {
        return this.build(UnverifiedBiscuit.default_symbol_table(), externalKey);
    }

    public org.biscuitsec.biscuit.token.Block build(SymbolTable symbols) {
        return this.build(symbols, (Option<PublicKey>)Option.none());
    }

    public org.biscuitsec.biscuit.token.Block build(SymbolTable symbols, Option<PublicKey> externalKey) {
        if (externalKey.isDefined()) {
            symbols = new SymbolTable();
        }
        int symbol_start = symbols.currentOffset();
        int publicKeyStart = symbols.currentPublicKeyOffset();
        ArrayList<org.biscuitsec.biscuit.datalog.Fact> facts = new ArrayList<org.biscuitsec.biscuit.datalog.Fact>();
        for (Fact fact : this.facts) {
            facts.add(fact.convert(symbols));
        }
        ArrayList<org.biscuitsec.biscuit.datalog.Rule> rules = new ArrayList<org.biscuitsec.biscuit.datalog.Rule>();
        for (Rule rule : this.rules) {
            rules.add(rule.convert(symbols));
        }
        ArrayList<org.biscuitsec.biscuit.datalog.Check> arrayList = new ArrayList<org.biscuitsec.biscuit.datalog.Check>();
        for (Check check : this.checks) {
            arrayList.add(check.convert(symbols));
        }
        ArrayList<org.biscuitsec.biscuit.datalog.Scope> arrayList2 = new ArrayList<org.biscuitsec.biscuit.datalog.Scope>();
        for (Scope s : this.scopes) {
            arrayList2.add(s.convert(symbols));
        }
        SchemaVersion schemaVersion = new SchemaVersion(facts, rules, arrayList, arrayList2);
        SymbolTable block_symbols = new SymbolTable();
        for (int i = symbol_start; i < symbols.symbols.size(); ++i) {
            block_symbols.add(symbols.symbols.get(i));
        }
        ArrayList<PublicKey> publicKeys = new ArrayList<PublicKey>();
        for (int i = publicKeyStart; i < symbols.currentPublicKeyOffset(); ++i) {
            publicKeys.add(symbols.publicKeys().get(i));
        }
        return new org.biscuitsec.biscuit.token.Block(block_symbols, this.context, facts, rules, arrayList, arrayList2, publicKeys, externalKey, schemaVersion.version());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        if (!Objects.equals(this.context, block.context)) {
            return false;
        }
        if (!Objects.equals(this.facts, block.facts)) {
            return false;
        }
        if (!Objects.equals(this.rules, block.rules)) {
            return false;
        }
        if (!Objects.equals(this.checks, block.checks)) {
            return false;
        }
        return Objects.equals(this.scopes, block.scopes);
    }

    public int hashCode() {
        int result = this.context != null ? this.context.hashCode() : 0;
        result = 31 * result + (this.facts != null ? this.facts.hashCode() : 0);
        result = 31 * result + (this.rules != null ? this.rules.hashCode() : 0);
        result = 31 * result + (this.checks != null ? this.checks.hashCode() : 0);
        result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
        return result;
    }

    public Block check_right(String right) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        queries.add(Utils.rule("check_right", Arrays.asList(Utils.s(right)), Arrays.asList(Utils.pred("resource", Arrays.asList(Utils.var("resource"))), Utils.pred("operation", Arrays.asList(Utils.s(right))), Utils.pred("right", Arrays.asList(Utils.var("resource"), Utils.s(right))))));
        return this.add_check(new Check(Check.Kind.One, queries));
    }

    public Block resource_prefix(String prefix) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        queries.add(Utils.constrained_rule("prefix", Arrays.asList(Utils.var("resource")), Arrays.asList(Utils.pred("resource", Arrays.asList(Utils.var("resource")))), Arrays.asList(new Expression.Binary(Expression.Op.Prefix, new Expression.Value(Utils.var("resource")), new Expression.Value(Utils.string(prefix))))));
        return this.add_check(new Check(Check.Kind.One, queries));
    }

    public Block resource_suffix(String suffix) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        queries.add(Utils.constrained_rule("suffix", Arrays.asList(Utils.var("resource")), Arrays.asList(Utils.pred("resource", Arrays.asList(Utils.var("resource")))), Arrays.asList(new Expression.Binary(Expression.Op.Suffix, new Expression.Value(Utils.var("resource")), new Expression.Value(Utils.string(suffix))))));
        return this.add_check(new Check(Check.Kind.One, queries));
    }

    public Block expiration_date(Date d) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        queries.add(Utils.constrained_rule("expiration", Arrays.asList(Utils.var("date")), Arrays.asList(Utils.pred("time", Arrays.asList(Utils.var("date")))), Arrays.asList(new Expression.Binary(Expression.Op.LessOrEqual, new Expression.Value(Utils.var("date")), new Expression.Value(Utils.date(d))))));
        return this.add_check(new Check(Check.Kind.One, queries));
    }
}

