/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token.builder;

import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.error.Error;
import org.biscuitsec.biscuit.error.FailedCheck;
import org.biscuitsec.biscuit.token.builder.Expression;
import org.biscuitsec.biscuit.token.builder.Predicate;
import org.biscuitsec.biscuit.token.builder.Scope;
import org.biscuitsec.biscuit.token.builder.Term;

public class Rule
implements Cloneable {
    Predicate head;
    List<Predicate> body;
    List<Expression> expressions;
    Option<Map<String, Option<Term>>> variables;
    List<Scope> scopes;

    public Rule(Predicate head, List<Predicate> body, List<Expression> expressions, List<Scope> scopes) {
        HashMap<String, Option> variables = new HashMap<String, Option>();
        this.head = head;
        this.body = body;
        this.expressions = expressions;
        this.scopes = scopes;
        for (Term t : head.terms) {
            if (!(t instanceof Term.Variable)) continue;
            variables.put(((Term.Variable)t).value, Option.none());
        }
        for (Predicate p : body) {
            for (Term t : p.terms) {
                if (!(t instanceof Term.Variable)) continue;
                variables.put(((Term.Variable)t).value, Option.none());
            }
        }
        for (Expression e : expressions) {
            if (!(e instanceof Expression.Value)) continue;
            Expression.Value ev = (Expression.Value)e;
            if (!(ev.value instanceof Term.Variable)) continue;
            variables.put(((Term.Variable)ev.value).value, Option.none());
        }
        this.variables = Option.some(variables);
    }

    public Rule clone() {
        Predicate head = this.head.clone();
        ArrayList<Predicate> body = new ArrayList<Predicate>();
        body.addAll(this.body);
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.addAll(this.expressions);
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        scopes.addAll(this.scopes);
        return new Rule(head, body, expressions, scopes);
    }

    public void set(String name, Term term) throws Error.Language {
        if (this.variables.isDefined()) {
            Option t = Option.of((Object)((Option)((Map)this.variables.get()).get(name)));
            if (!t.isDefined()) {
                throw new Error.Language(new FailedCheck.LanguageError.UnknownVariable("name"));
            }
        } else {
            throw new Error.Language(new FailedCheck.LanguageError.UnknownVariable("name"));
        }
        ((Map)this.variables.get()).put(name, Option.some((Object)term));
    }

    public void apply_variables() {
        this.variables.forEach(_variables -> {
            this.head.terms = this.head.terms.stream().flatMap(t -> {
                if (t instanceof Term.Variable) {
                    Option term = _variables.getOrDefault(((Term.Variable)t).value, Option.none());
                    return (Stream)term.map(_t -> Stream.of(_t)).getOrElse(Stream.of(t));
                }
                return Stream.of(t);
            }).collect(Collectors.toList());
            for (Predicate p : this.body) {
                p.terms = p.terms.stream().flatMap(t -> {
                    if (t instanceof Term.Variable) {
                        Option term = _variables.getOrDefault(((Term.Variable)t).value, Option.none());
                        return (Stream)term.map(_t -> Stream.of(_t)).getOrElse(Stream.of(t));
                    }
                    return Stream.of(t);
                }).collect(Collectors.toList());
            }
            this.expressions = this.expressions.stream().flatMap(e -> {
                if (e instanceof Expression.Value) {
                    Option t;
                    Expression.Value ev = (Expression.Value)e;
                    if (ev.value instanceof Term.Variable && (t = _variables.getOrDefault(((Term.Variable)ev.value).value, Option.none())).isDefined()) {
                        return Stream.of(new Expression.Value((Term)t.get()));
                    }
                }
                return Stream.of(e);
            }).collect(Collectors.toList());
        });
    }

    public Either<String, Rule> validate_variables() {
        Set<String> free_variables = this.head.terms.stream().flatMap(t -> {
            if (t instanceof Term.Variable) {
                return Stream.of(((Term.Variable)t).value);
            }
            return Stream.empty();
        }).collect(Collectors.toSet());
        for (Expression e : this.expressions) {
            e.gatherVariables(free_variables);
        }
        if (free_variables.isEmpty()) {
            return Either.right((Object)this);
        }
        for (Predicate p : this.body) {
            for (Term term : p.terms) {
                if (!(term instanceof Term.Variable)) continue;
                free_variables.remove(((Term.Variable)term).value);
                if (!free_variables.isEmpty()) continue;
                return Either.right((Object)this);
            }
        }
        return Either.left((Object)("rule head or expressions contains variables that are not used in predicates of the rule's body: " + free_variables.toString()));
    }

    public org.biscuitsec.biscuit.datalog.Rule convert(SymbolTable symbols) {
        Rule r = this.clone();
        r.apply_variables();
        org.biscuitsec.biscuit.datalog.Predicate head = r.head.convert(symbols);
        ArrayList<org.biscuitsec.biscuit.datalog.Predicate> body = new ArrayList<org.biscuitsec.biscuit.datalog.Predicate>();
        ArrayList<org.biscuitsec.biscuit.datalog.expressions.Expression> expressions = new ArrayList<org.biscuitsec.biscuit.datalog.expressions.Expression>();
        ArrayList<org.biscuitsec.biscuit.datalog.Scope> scopes = new ArrayList<org.biscuitsec.biscuit.datalog.Scope>();
        for (Predicate p : r.body) {
            body.add(p.convert(symbols));
        }
        for (Expression e : r.expressions) {
            expressions.add(e.convert(symbols));
        }
        for (Scope s : r.scopes) {
            scopes.add(s.convert(symbols));
        }
        return new org.biscuitsec.biscuit.datalog.Rule(head, body, expressions, scopes);
    }

    public static Rule convert_from(org.biscuitsec.biscuit.datalog.Rule r, SymbolTable symbols) {
        Predicate head = Predicate.convert_from(r.head(), symbols);
        ArrayList<Predicate> body = new ArrayList<Predicate>();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        for (org.biscuitsec.biscuit.datalog.Predicate p : r.body()) {
            body.add(Predicate.convert_from(p, symbols));
        }
        for (org.biscuitsec.biscuit.datalog.expressions.Expression e : r.expressions()) {
            expressions.add(Expression.convert_from(e, symbols));
        }
        for (org.biscuitsec.biscuit.datalog.Scope s : r.scopes()) {
            scopes.add(Scope.convert_from(s, symbols));
        }
        return new Rule(head, body, expressions, scopes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        if (this.head != null ? !this.head.equals(rule.head) : rule.head != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(rule.body) : rule.body != null) {
            return false;
        }
        if (this.scopes != null ? !this.scopes.equals(rule.scopes) : rule.scopes != null) {
            return false;
        }
        return this.expressions != null ? this.expressions.equals(rule.expressions) : rule.expressions == null;
    }

    public int hashCode() {
        int result = this.head != null ? this.head.hashCode() : 0;
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.expressions != null ? this.expressions.hashCode() : 0);
        result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
        return result;
    }

    public String bodyToString() {
        List e;
        Rule r = this.clone();
        r.apply_variables();
        Object res = "";
        if (!r.body.isEmpty()) {
            List b = r.body.stream().map(pred -> pred.toString()).collect(Collectors.toList());
            res = (String)res + String.join((CharSequence)", ", b);
        }
        if (!r.expressions.isEmpty()) {
            if (!r.body.isEmpty()) {
                res = (String)res + ", ";
            }
            e = r.expressions.stream().map(expression -> expression.toString()).collect(Collectors.toList());
            res = (String)res + String.join((CharSequence)", ", e);
        }
        if (!r.scopes.isEmpty()) {
            if (!r.body.isEmpty() || !r.expressions.isEmpty()) {
                res = (String)res + " ";
            }
            e = r.scopes.stream().map(scope -> scope.toString()).collect(Collectors.toList());
            res = (String)res + "trusting " + String.join((CharSequence)", ", e);
        }
        return res;
    }

    public String toString() {
        Rule r = this.clone();
        r.apply_variables();
        return r.head.toString() + " <- " + this.bodyToString();
    }
}

