/*
 * Decompiled with CFR 0.152.
 */
package org.biscuitsec.biscuit.token.format;

import biscuit.format.schema.Schema;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.vavr.API;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import net.i2p.crypto.eddsa.EdDSAEngine;
import org.biscuitsec.biscuit.crypto.KeyDelegate;
import org.biscuitsec.biscuit.crypto.KeyPair;
import org.biscuitsec.biscuit.datalog.SymbolTable;
import org.biscuitsec.biscuit.error.Error;
import org.biscuitsec.biscuit.token.Block;
import org.biscuitsec.biscuit.token.format.ExternalSignature;
import org.biscuitsec.biscuit.token.format.Proof;
import org.biscuitsec.biscuit.token.format.SignedBlock;

public class SerializedBiscuit {
    public SignedBlock authority;
    public List<SignedBlock> blocks;
    public Proof proof;
    public Option<Integer> root_key_id;
    public static int MIN_SCHEMA_VERSION = 3;
    public static int MAX_SCHEMA_VERSION = 5;

    public static SerializedBiscuit from_bytes(byte[] slice, org.biscuitsec.biscuit.crypto.PublicKey root) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        try {
            Schema.Biscuit data = Schema.Biscuit.parseFrom(slice);
            return SerializedBiscuit.from_bytes_inner(data, root);
        }
        catch (InvalidProtocolBufferException e) {
            throw new Error.FormatError.DeserializationError(e.toString());
        }
    }

    public static SerializedBiscuit from_bytes(byte[] slice, KeyDelegate delegate) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        try {
            Option<org.biscuitsec.biscuit.crypto.PublicKey> root;
            Schema.Biscuit data = Schema.Biscuit.parseFrom(slice);
            Option root_key_id = Option.none();
            if (data.hasRootKeyId()) {
                root_key_id = Option.some((Object)data.getRootKeyId());
            }
            if ((root = delegate.root_key((Option<Integer>)root_key_id)).isEmpty()) {
                throw new InvalidKeyException("unknown root key id");
            }
            return SerializedBiscuit.from_bytes_inner(data, (org.biscuitsec.biscuit.crypto.PublicKey)root.get());
        }
        catch (InvalidProtocolBufferException e) {
            throw new Error.FormatError.DeserializationError(e.toString());
        }
    }

    static SerializedBiscuit from_bytes_inner(Schema.Biscuit data, org.biscuitsec.biscuit.crypto.PublicKey root) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        Either<Error, Void> res;
        SerializedBiscuit b = SerializedBiscuit.deserialize(data);
        if (data.hasRootKeyId()) {
            b.root_key_id = Option.some((Object)data.getRootKeyId());
        }
        if ((res = b.verify(root)).isLeft()) {
            throw (Error)res.getLeft();
        }
        return b;
    }

    public static SerializedBiscuit unsafe_deserialize(byte[] slice) throws Error.FormatError.DeserializationError {
        try {
            Schema.Biscuit data = Schema.Biscuit.parseFrom(slice);
            return SerializedBiscuit.deserialize(data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new Error.FormatError.DeserializationError(e.toString());
        }
    }

    private static SerializedBiscuit deserialize(Schema.Biscuit data) throws Error.FormatError.DeserializationError {
        if (data.getAuthority().hasExternalSignature()) {
            throw new Error.FormatError.DeserializationError("the authority block must not contain an external signature");
        }
        SignedBlock authority = new SignedBlock(data.getAuthority().getBlock().toByteArray(), org.biscuitsec.biscuit.crypto.PublicKey.deserialize(data.getAuthority().getNextKey()), data.getAuthority().getSignature().toByteArray(), (Option<ExternalSignature>)Option.none());
        ArrayList<SignedBlock> blocks = new ArrayList<SignedBlock>();
        for (Schema.SignedBlock block : data.getBlocksList()) {
            Option external = Option.none();
            if (block.hasExternalSignature() && block.getExternalSignature().hasPublicKey() && block.getExternalSignature().hasSignature()) {
                Schema.ExternalSignature ex = block.getExternalSignature();
                external = Option.some((Object)new ExternalSignature(org.biscuitsec.biscuit.crypto.PublicKey.deserialize(ex.getPublicKey()), ex.getSignature().toByteArray()));
            }
            blocks.add(new SignedBlock(block.getBlock().toByteArray(), org.biscuitsec.biscuit.crypto.PublicKey.deserialize(block.getNextKey()), block.getSignature().toByteArray(), (Option<ExternalSignature>)external));
        }
        Option secretKey = Option.none();
        if (data.getProof().hasNextSecret()) {
            secretKey = Option.some((Object)new KeyPair(data.getProof().getNextSecret().toByteArray()));
        }
        Option signature = Option.none();
        if (data.getProof().hasFinalSignature()) {
            signature = Option.some((Object)data.getProof().getFinalSignature().toByteArray());
        }
        if (secretKey.isEmpty() && signature.isEmpty()) {
            throw new Error.FormatError.DeserializationError("empty proof");
        }
        Proof proof = new Proof((Option<KeyPair>)secretKey, (Option<byte[]>)signature);
        return new SerializedBiscuit(authority, blocks, proof);
    }

    public byte[] serialize() throws Error.FormatError.SerializationError {
        Schema.Biscuit.Builder biscuitBuilder = Schema.Biscuit.newBuilder();
        Schema.SignedBlock.Builder authorityBuilder = Schema.SignedBlock.newBuilder();
        SignedBlock block = this.authority;
        authorityBuilder.setBlock(ByteString.copyFrom((byte[])block.block));
        authorityBuilder.setNextKey(block.key.serialize());
        authorityBuilder.setSignature(ByteString.copyFrom((byte[])block.signature));
        biscuitBuilder.setAuthority(authorityBuilder.build());
        for (SignedBlock block2 : this.blocks) {
            Schema.SignedBlock.Builder blockBuilder = Schema.SignedBlock.newBuilder();
            blockBuilder.setBlock(ByteString.copyFrom((byte[])block2.block));
            blockBuilder.setNextKey(block2.key.serialize());
            blockBuilder.setSignature(ByteString.copyFrom((byte[])block2.signature));
            if (block2.externalSignature.isDefined()) {
                ExternalSignature externalSignature = (ExternalSignature)block2.externalSignature.get();
                Schema.ExternalSignature.Builder externalSignatureBuilder = Schema.ExternalSignature.newBuilder();
                externalSignatureBuilder.setPublicKey(externalSignature.key.serialize());
                externalSignatureBuilder.setSignature(ByteString.copyFrom((byte[])externalSignature.signature));
                blockBuilder.setExternalSignature(externalSignatureBuilder.build());
            }
            biscuitBuilder.addBlocks(blockBuilder.build());
        }
        Schema.Proof.Builder proofBuilder = Schema.Proof.newBuilder();
        if (!this.proof.secretKey.isEmpty()) {
            proofBuilder.setNextSecret(ByteString.copyFrom((byte[])((KeyPair)this.proof.secretKey.get()).toBytes()));
        } else {
            proofBuilder.setFinalSignature(ByteString.copyFrom((byte[])((byte[])this.proof.signature.get())));
        }
        biscuitBuilder.setProof(proofBuilder.build());
        if (!this.root_key_id.isEmpty()) {
            biscuitBuilder.setRootKeyId((Integer)this.root_key_id.get());
        }
        Schema.Biscuit biscuit = biscuitBuilder.build();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            biscuit.writeTo(stream);
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new Error.FormatError.SerializationError(e.toString());
        }
    }

    public static Either<Error.FormatError, SerializedBiscuit> make(KeyPair root, Block authority, KeyPair next) {
        return SerializedBiscuit.make(root, (Option<Integer>)Option.none(), authority, next);
    }

    public static Either<Error.FormatError, SerializedBiscuit> make(KeyPair root, Option<Integer> root_key_id, Block authority, KeyPair next) {
        Schema.Block b = authority.serialize();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            b.writeTo(stream);
            byte[] block = stream.toByteArray();
            org.biscuitsec.biscuit.crypto.PublicKey next_key = next.public_key();
            ByteBuffer algo_buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            algo_buf.putInt(next_key.algorithm.getNumber());
            algo_buf.flip();
            Signature sgr = KeyPair.generateSignature(root.public_key().algorithm);
            sgr.initSign((PrivateKey)root.private_key);
            sgr.update(block);
            sgr.update(algo_buf);
            sgr.update(next_key.toBytes());
            byte[] signature = sgr.sign();
            SignedBlock signedBlock = new SignedBlock(block, next_key, signature, (Option<ExternalSignature>)Option.none());
            Proof proof = new Proof(next);
            return API.Right((Object)new SerializedBiscuit(signedBlock, new ArrayList<SignedBlock>(), proof, root_key_id));
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            return API.Left((Object)new Error.FormatError.SerializationError(e.toString()));
        }
    }

    public Either<Error.FormatError, SerializedBiscuit> append(KeyPair next, Block newBlock, Option<ExternalSignature> externalSignature) {
        if (this.proof.secretKey.isEmpty()) {
            return API.Left((Object)new Error.FormatError.SerializationError("the token is sealed"));
        }
        Schema.Block b = newBlock.serialize();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            b.writeTo(stream);
            byte[] block = stream.toByteArray();
            org.biscuitsec.biscuit.crypto.PublicKey next_key = next.public_key();
            ByteBuffer algo_buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            algo_buf.putInt(next_key.algorithm.getNumber());
            algo_buf.flip();
            EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance(KeyPair.ed25519.getHashAlgorithm()));
            sgr.initSign((PrivateKey)((KeyPair)this.proof.secretKey.get()).private_key);
            sgr.update(block);
            if (externalSignature.isDefined()) {
                sgr.update(((ExternalSignature)externalSignature.get()).signature);
            }
            sgr.update(algo_buf);
            sgr.update(next_key.toBytes());
            byte[] signature = sgr.sign();
            SignedBlock signedBlock = new SignedBlock(block, next_key, signature, externalSignature);
            ArrayList<SignedBlock> blocks = new ArrayList<SignedBlock>();
            for (SignedBlock bl : this.blocks) {
                blocks.add(bl);
            }
            blocks.add(signedBlock);
            Proof proof = new Proof(next);
            return API.Right((Object)new SerializedBiscuit(this.authority, blocks, proof, this.root_key_id));
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            return API.Left((Object)new Error.FormatError.SerializationError(e.toString()));
        }
    }

    public Either<Error, Void> verify(org.biscuitsec.biscuit.crypto.PublicKey root) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        SignedBlock b2;
        org.biscuitsec.biscuit.crypto.PublicKey current_key = root;
        ByteBuffer algo_buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        Either<Error, org.biscuitsec.biscuit.crypto.PublicKey> res = SerializedBiscuit.verifyBlockSignature(this.authority, current_key);
        if (!res.isRight()) {
            return API.Left((Object)((Error)res.getLeft()));
        }
        current_key = (org.biscuitsec.biscuit.crypto.PublicKey)res.get();
        for (SignedBlock b2 : this.blocks) {
            Either<Error, org.biscuitsec.biscuit.crypto.PublicKey> res2 = SerializedBiscuit.verifyBlockSignature(b2, current_key);
            if (res2.isRight()) {
                current_key = (org.biscuitsec.biscuit.crypto.PublicKey)res2.get();
                continue;
            }
            return API.Left((Object)((Error)res2.getLeft()));
        }
        if (!this.proof.secretKey.isEmpty()) {
            if (((KeyPair)this.proof.secretKey.get()).public_key().equals(current_key)) {
                return API.Right(null);
            }
            return API.Left((Object)new Error.FormatError.Signature.InvalidSignature("signature error: Verification equation was not satisfied"));
        }
        byte[] finalSignature = (byte[])this.proof.signature.get();
        b2 = this.blocks.isEmpty() ? this.authority : this.blocks.get(this.blocks.size() - 1);
        byte[] block = b2.block;
        org.biscuitsec.biscuit.crypto.PublicKey next_key = b2.key;
        byte[] signature = b2.signature;
        algo_buf.clear();
        algo_buf.putInt(next_key.algorithm.getNumber());
        algo_buf.flip();
        EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance(KeyPair.ed25519.getHashAlgorithm()));
        sgr.initVerify((PublicKey)current_key.key);
        sgr.update(block);
        sgr.update(algo_buf);
        sgr.update(next_key.toBytes());
        sgr.update(signature);
        if (sgr.verify(finalSignature)) {
            return API.Right(null);
        }
        return API.Left((Object)new Error.FormatError.SealedSignature());
    }

    static Either<Error, org.biscuitsec.biscuit.crypto.PublicKey> verifyBlockSignature(SignedBlock signedBlock, org.biscuitsec.biscuit.crypto.PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        byte[] block = signedBlock.block;
        org.biscuitsec.biscuit.crypto.PublicKey next_key = signedBlock.key;
        byte[] signature = signedBlock.signature;
        if (signature.length != 64) {
            return Either.left((Object)new Error.FormatError.InvalidSignatureSize(signature.length));
        }
        ByteBuffer algo_buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        algo_buf.putInt(next_key.algorithm.getNumber());
        algo_buf.flip();
        Signature sgr = KeyPair.generateSignature(publicKey.algorithm);
        sgr.initVerify((PublicKey)publicKey.key);
        sgr.update(block);
        if (signedBlock.externalSignature.isDefined()) {
            sgr.update(((ExternalSignature)signedBlock.externalSignature.get()).signature);
        }
        sgr.update(algo_buf);
        sgr.update(next_key.toBytes());
        if (!sgr.verify(signature)) {
            return API.Left((Object)new Error.FormatError.Signature.InvalidSignature("signature error: Verification equation was not satisfied"));
        }
        if (signedBlock.externalSignature.isDefined()) {
            ByteBuffer algo_buf2 = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            algo_buf2.putInt(publicKey.algorithm.getNumber());
            algo_buf2.flip();
            EdDSAEngine sgr2 = new EdDSAEngine(MessageDigest.getInstance(KeyPair.ed25519.getHashAlgorithm()));
            sgr2.initVerify((PublicKey)((ExternalSignature)signedBlock.externalSignature.get()).key.key);
            sgr2.update(block);
            sgr2.update(algo_buf2);
            sgr2.update(publicKey.toBytes());
            if (!sgr2.verify(((ExternalSignature)signedBlock.externalSignature.get()).signature)) {
                return API.Left((Object)new Error.FormatError.Signature.InvalidSignature("external signature error: Verification equation was not satisfied"));
            }
        }
        return API.Right((Object)next_key);
    }

    public Tuple2<Block, ArrayList<Block>> extractBlocks(SymbolTable symbols) throws Error {
        ArrayList<Option> blockExternalKeys = new ArrayList<Option>();
        Either<Error.FormatError, Block> authRes = Block.from_bytes(this.authority.block, (Option<org.biscuitsec.biscuit.crypto.PublicKey>)Option.none());
        if (authRes.isLeft()) {
            throw (Error.FormatError)authRes.getLeft();
        }
        Block authority = (Block)authRes.get();
        for (org.biscuitsec.biscuit.crypto.PublicKey pk : authority.publicKeys()) {
            symbols.insert(pk);
        }
        blockExternalKeys.add(Option.none());
        for (String s : authority.symbols().symbols) {
            symbols.add(s);
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (SignedBlock bdata : this.blocks) {
            Either<Error.FormatError, Block> blockRes;
            Option externalKey = Option.none();
            if (bdata.externalSignature.isDefined()) {
                externalKey = Option.some((Object)((ExternalSignature)bdata.externalSignature.get()).key);
            }
            if ((blockRes = Block.from_bytes(bdata.block, (Option<org.biscuitsec.biscuit.crypto.PublicKey>)externalKey)).isLeft()) {
                throw (Error.FormatError)blockRes.getLeft();
            }
            Block block = (Block)blockRes.get();
            if (bdata.externalSignature.isDefined()) {
                blockExternalKeys.add(Option.some((Object)((ExternalSignature)bdata.externalSignature.get()).key));
            } else {
                blockExternalKeys.add(Option.none());
                for (String s : block.symbols().symbols) {
                    symbols.add(s);
                }
                for (org.biscuitsec.biscuit.crypto.PublicKey pk : block.publicKeys()) {
                    symbols.insert(pk);
                }
            }
            blocks.add(block);
        }
        return new Tuple2((Object)authority, blocks);
    }

    public Either<Error, Void> seal() throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        if (this.proof.secretKey.isEmpty()) {
            return API.Left((Object)new Error.Sealed());
        }
        SignedBlock block = this.blocks.isEmpty() ? this.authority : this.blocks.get(this.blocks.size() - 1);
        EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance(KeyPair.ed25519.getHashAlgorithm()));
        ByteBuffer algo_buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        algo_buf.putInt(block.key.algorithm.getNumber());
        algo_buf.flip();
        sgr.initSign((PrivateKey)((KeyPair)this.proof.secretKey.get()).private_key);
        sgr.update(block.block);
        sgr.update(algo_buf);
        sgr.update(block.key.toBytes());
        sgr.update(block.signature);
        byte[] signature = sgr.sign();
        this.proof.secretKey = Option.none();
        this.proof.signature = Option.some((Object)signature);
        return API.Right(null);
    }

    public List<byte[]> revocation_identifiers() {
        ArrayList<byte[]> l = new ArrayList<byte[]>();
        l.add(this.authority.signature);
        for (SignedBlock block : this.blocks) {
            l.add(block.signature);
        }
        return l;
    }

    SerializedBiscuit(SignedBlock authority, List<SignedBlock> blocks, Proof proof) {
        this.authority = authority;
        this.blocks = blocks;
        this.proof = proof;
        this.root_key_id = Option.none();
    }

    SerializedBiscuit(SignedBlock authority, List<SignedBlock> blocks, Proof proof, Option<Integer> root_key_id) {
        this.authority = authority;
        this.blocks = blocks;
        this.proof = proof;
        this.root_key_id = root_key_id;
    }
}

