/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.feeprovider;

import akka.actor.ActorSystem;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import org.bitcoins.commons.jsonmodels.wallet.MempoolSpaceResult;
import org.bitcoins.commons.serializers.JsonSerializers$;
import org.bitcoins.core.config.BitcoinNetwork;
import org.bitcoins.core.config.MainNet$;
import org.bitcoins.core.config.RegTest$;
import org.bitcoins.core.config.SigNet$;
import org.bitcoins.core.config.TestNet3$;
import org.bitcoins.core.wallet.fee.SatoshisPerVirtualByte;
import org.bitcoins.feeprovider.CachedHttpFeeRateProvider;
import org.bitcoins.feeprovider.MempoolSpaceProvider$;
import org.bitcoins.feeprovider.MempoolSpaceTarget;
import org.bitcoins.feeprovider.MempoolSpaceTarget$FastestFeeTarget$;
import org.bitcoins.feeprovider.MempoolSpaceTarget$HalfHourFeeTarget$;
import org.bitcoins.feeprovider.MempoolSpaceTarget$HourFeeTarget$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001\u0002\u0010 \u0001\u001aB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005M\u0001\tE\t\u0015!\u0003G\u0011!i\u0005A!b\u0001\n\u0007r\u0005\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u000ba\u0003A\u0011A-\t\u000f}\u0003!\u0019!C!A\"11\u000e\u0001Q\u0001\n\u0005DQ\u0001\u001c\u0001\u0005B5D\u0011\"a\u0001\u0001\u0003\u0003%\t!!\u0002\t\u0013\u0005=\u0001!%A\u0005\u0002\u0005E\u0001\"CA\u0014\u0001E\u0005I\u0011AA\u0015\u0011%\ti\u0003AA\u0001\n\u0003\ny\u0003C\u0005\u0002@\u0001\t\t\u0011\"\u0001\u0002B!I\u0011\u0011\n\u0001\u0002\u0002\u0013\u0005\u00111\n\u0005\n\u0003/\u0002\u0011\u0011!C!\u00033B\u0011\"a\u001a\u0001\u0003\u0003%\t!!\u001b\t\u0013\u0005M\u0004!!A\u0005B\u0005U\u0004\"CA<\u0001\u0005\u0005I\u0011IA=\u0011%\tY\bAA\u0001\n\u0003\nihB\u0004\u0002\u0002~A\t!a!\u0007\ryy\u0002\u0012AAC\u0011\u0019Av\u0003\"\u0001\u0002\u0014\"9\u0011QS\f\u0005B\u0005]\u0005bBAK/\u0011\u0005\u0011\u0011\u0015\u0005\n\u0003W;\u0012\u0011!CA\u0003[C\u0011\"a.\u0018\u0003\u0003%\t)!/\t\u0013\u0005-w#!A\u0005\n\u00055'\u0001F'f[B|w\u000e\\*qC\u000e,\u0007K]8wS\u0012,'O\u0003\u0002!C\u0005Ya-Z3qe>4\u0018\u000eZ3s\u0015\t\u00113%\u0001\u0005cSR\u001cw.\u001b8t\u0015\u0005!\u0013aA8sO\u000e\u00011\u0003\u0002\u0001(km\u00022\u0001K\u0015,\u001b\u0005y\u0012B\u0001\u0016 \u0005e\u0019\u0015m\u00195fI\"#H\u000f\u001d$fKJ\u000bG/\u001a)s_ZLG-\u001a:\u0011\u00051\u001aT\"A\u0017\u000b\u00059z\u0013a\u00014fK*\u0011\u0001'M\u0001\u0007o\u0006dG.\u001a;\u000b\u0005I\n\u0013\u0001B2pe\u0016L!\u0001N\u0017\u0003-M\u000bGo\\:iSN\u0004VM\u001d,jeR,\u0018\r\u001c\"zi\u0016\u0004\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00027y%\u0011Qh\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007i\u0006\u0014x-\u001a;\u0016\u0003\u0001\u0003\"\u0001K!\n\u0005\t{\"AE'f[B|w\u000e\\*qC\u000e,G+\u0019:hKR\fq\u0001^1sO\u0016$\b%A\u0004oKR<xN]6\u0016\u0003\u0019\u0003\"a\u0012&\u000e\u0003!S!!S\u0019\u0002\r\r|gNZ5h\u0013\tY\u0005J\u0001\bCSR\u001cw.\u001b8OKR<xN]6\u0002\u00119,Go^8sW\u0002\naa]=ti\u0016lW#A(\u0011\u0005A+V\"A)\u000b\u0005I\u001b\u0016!B1di>\u0014(\"\u0001+\u0002\t\u0005\\7.Y\u0005\u0003-F\u00131\"Q2u_J\u001c\u0016p\u001d;f[\u000691/_:uK6\u0004\u0013A\u0002\u001fj]&$h\bF\u0002[;z#\"a\u0017/\u0011\u0005!\u0002\u0001\"B'\b\u0001\by\u0005\"\u0002 \b\u0001\u0004\u0001\u0005\"\u0002#\b\u0001\u00041\u0015aA;sSV\t\u0011\r\u0005\u0002cS6\t1M\u0003\u0002eK\u0006)Qn\u001c3fY*\u0011amZ\u0001\tg\u000e\fG.\u00193tY*\u0011\u0001nU\u0001\u0005QR$\b/\u0003\u0002kG\n\u0019QK]5\u0002\tU\u0014\u0018\u000eI\u0001\nG>tg/\u001a:uKJ$\"A\u001c;\u0011\u0007=\u00148&D\u0001q\u0015\t\tx'\u0001\u0003vi&d\u0017BA:q\u0005\r!&/\u001f\u0005\u0006k*\u0001\rA^\u0001\u0004gR\u0014\bCA<\u007f\u001d\tAH\u0010\u0005\u0002zo5\t!P\u0003\u0002|K\u00051AH]8pizJ!!`\u001c\u0002\rA\u0013X\rZ3g\u0013\ry\u0018\u0011\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u<\u0014\u0001B2paf$b!a\u0002\u0002\f\u00055AcA.\u0002\n!)Qj\u0003a\u0002\u001f\"9ah\u0003I\u0001\u0002\u0004\u0001\u0005b\u0002#\f!\u0003\u0005\rAR\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019BK\u0002A\u0003+Y#!a\u0006\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003C9\u0014AC1o]>$\u0018\r^5p]&!\u0011QEA\u000e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tYCK\u0002G\u0003+\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0019!\u0011\t\u0019$!\u0010\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\tA\u0001\\1oO*\u0011\u00111H\u0001\u0005U\u00064\u0018-C\u0002\u0000\u0003k\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0011\u0011\u0007Y\n)%C\u0002\u0002H]\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0014\u0002TA\u0019a'a\u0014\n\u0007\u0005EsGA\u0002B]fD\u0011\"!\u0016\u0011\u0003\u0003\u0005\r!a\u0011\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\u0006\u0005\u0004\u0002^\u0005\r\u0014QJ\u0007\u0003\u0003?R1!!\u00198\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003K\nyF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA6\u0003c\u00022ANA7\u0013\r\tyg\u000e\u0002\b\u0005>|G.Z1o\u0011%\t)FEA\u0001\u0002\u0004\ti%\u0001\u0005iCND7i\u001c3f)\t\t\u0019%\u0001\u0005u_N#(/\u001b8h)\t\t\t$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003W\ny\bC\u0005\u0002VU\t\t\u00111\u0001\u0002N\u0005!R*Z7q_>d7\u000b]1dKB\u0013xN^5eKJ\u0004\"\u0001K\f\u0014\r]\t9)!$<!\r1\u0014\u0011R\u0005\u0004\u0003\u0017;$AB!osJ+g\r\u0005\u0003)\u0003\u001f[\u0016bAAI?\t\u0011b)Z3Qe>4\u0018\u000eZ3s\r\u0006\u001cGo\u001c:z)\t\t\u0019)A\bge>l'\t\\8dWR\u000b'oZ3u)\u0011\tI*!(\u0015\u0007m\u000bY\nC\u0003N3\u0001\u000fq\nC\u0004\u0002 f\u0001\r!a\u0011\u0002\r\tdwnY6t)\u0019\t\u0019+a*\u0002*R\u00191,!*\t\u000b5S\u00029A(\t\u000f\u0005}%\u00041\u0001\u0002D!)AI\u0007a\u0001\r\u0006)\u0011\r\u001d9msR1\u0011qVAZ\u0003k#2aWAY\u0011\u0015i5\u0004q\u0001P\u0011\u0015q4\u00041\u0001A\u0011\u0015!5\u00041\u0001G\u0003\u001d)h.\u00199qYf$B!a/\u0002HB)a'!0\u0002B&\u0019\u0011qX\u001c\u0003\r=\u0003H/[8o!\u00151\u00141\u0019!G\u0013\r\t)m\u000e\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005%G$!AA\u0002m\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005=\u0007\u0003BA\u001a\u0003#LA!a5\u00026\t1qJ\u00196fGR\u0004")
public class MempoolSpaceProvider
extends CachedHttpFeeRateProvider<SatoshisPerVirtualByte>
implements Product,
Serializable {
    private final MempoolSpaceTarget target;
    private final BitcoinNetwork network;
    private final ActorSystem system;
    private final Uri uri;

    public static Option<Tuple2<MempoolSpaceTarget, BitcoinNetwork>> unapply(MempoolSpaceProvider mempoolSpaceProvider) {
        return MempoolSpaceProvider$.MODULE$.unapply(mempoolSpaceProvider);
    }

    public static MempoolSpaceProvider apply(MempoolSpaceTarget mempoolSpaceTarget, BitcoinNetwork bitcoinNetwork, ActorSystem actorSystem) {
        return MempoolSpaceProvider$.MODULE$.apply(mempoolSpaceTarget, bitcoinNetwork, actorSystem);
    }

    public static MempoolSpaceProvider fromBlockTarget(int n, BitcoinNetwork bitcoinNetwork, ActorSystem actorSystem) {
        return MempoolSpaceProvider$.MODULE$.fromBlockTarget(n, bitcoinNetwork, actorSystem);
    }

    public static MempoolSpaceProvider fromBlockTarget(int n, ActorSystem actorSystem) {
        return MempoolSpaceProvider$.MODULE$.fromBlockTarget(n, actorSystem);
    }

    public MempoolSpaceTarget target() {
        return this.target;
    }

    public BitcoinNetwork network() {
        return this.network;
    }

    @Override
    public ActorSystem system() {
        return this.system;
    }

    @Override
    public Uri uri() {
        return this.uri;
    }

    @Override
    public Try<SatoshisPerVirtualByte> converter(String str) {
        Success success;
        JsValue json = Json$.MODULE$.parse(str);
        JsResult jsResult = json.validate(JsonSerializers$.MODULE$.mempoolSpaceResultReads());
        if (jsResult instanceof JsSuccess) {
            Success success2;
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            MempoolSpaceResult response = (MempoolSpaceResult)jsSuccess.value();
            MempoolSpaceTarget mempoolSpaceTarget = this.target();
            if (MempoolSpaceTarget$FastestFeeTarget$.MODULE$.equals(mempoolSpaceTarget)) {
                success2 = new Success((Object)response.fastestFee());
            } else if (MempoolSpaceTarget$HalfHourFeeTarget$.MODULE$.equals(mempoolSpaceTarget)) {
                success2 = new Success((Object)response.halfHourFee());
            } else if (MempoolSpaceTarget$HourFeeTarget$.MODULE$.equals(mempoolSpaceTarget)) {
                success2 = new Success((Object)response.hourFee());
            } else {
                throw new MatchError((Object)mempoolSpaceTarget);
            }
            success = success2;
        } else if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            Seq error = jsError.errors();
            success = new Failure((Throwable)new RuntimeException(new StringBuilder(40).append("Unexpected error when parsing response: ").append(error).toString()));
        } else {
            throw new MatchError((Object)jsResult);
        }
        return success;
    }

    public MempoolSpaceProvider copy(MempoolSpaceTarget target, BitcoinNetwork network, ActorSystem system) {
        return new MempoolSpaceProvider(target, network, system);
    }

    public MempoolSpaceTarget copy$default$1() {
        return this.target();
    }

    public BitcoinNetwork copy$default$2() {
        return this.network();
    }

    public String productPrefix() {
        return "MempoolSpaceProvider";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        MempoolSpaceTarget mempoolSpaceTarget;
        int n = x$1;
        switch (n) {
            case 0: {
                mempoolSpaceTarget = this.target();
                break;
            }
            case 1: {
                mempoolSpaceTarget = this.network();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return mempoolSpaceTarget;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MempoolSpaceProvider;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MempoolSpaceProvider)) return false;
        boolean bl = true;
        if (!bl) return false;
        MempoolSpaceProvider mempoolSpaceProvider = (MempoolSpaceProvider)x$1;
        MempoolSpaceTarget mempoolSpaceTarget = this.target();
        MempoolSpaceTarget mempoolSpaceTarget2 = mempoolSpaceProvider.target();
        if (mempoolSpaceTarget == null) {
            if (mempoolSpaceTarget2 != null) {
                return false;
            }
        } else if (!mempoolSpaceTarget.equals(mempoolSpaceTarget2)) return false;
        BitcoinNetwork bitcoinNetwork = this.network();
        BitcoinNetwork bitcoinNetwork2 = mempoolSpaceProvider.network();
        if (bitcoinNetwork == null) {
            if (bitcoinNetwork2 != null) {
                return false;
            }
        } else if (!bitcoinNetwork.equals(bitcoinNetwork2)) return false;
        if (!mempoolSpaceProvider.canEqual(this)) return false;
        return true;
    }

    public MempoolSpaceProvider(MempoolSpaceTarget target, BitcoinNetwork network, ActorSystem system) {
        Uri uri;
        this.target = target;
        this.network = network;
        this.system = system;
        Product.$init$((Product)this);
        BitcoinNetwork bitcoinNetwork = network;
        if (MainNet$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/api/v1/fees/recommended");
        } else if (TestNet3$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/testnet/api/v1/fees/recommended");
        } else if (SigNet$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/signet/api/v1/fees/recommended");
        } else if (RegTest$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/testnet/api/v1/fees/recommended");
        } else {
            throw new MatchError((Object)bitcoinNetwork);
        }
        this.uri = uri;
    }
}

