/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.feeprovider;

import akka.actor.ActorSystem;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import org.bitcoins.commons.jsonmodels.wallet.MempoolSpaceResult;
import org.bitcoins.commons.serializers.JsonSerializers$;
import org.bitcoins.core.config.BitcoinNetwork;
import org.bitcoins.core.config.MainNet$;
import org.bitcoins.core.config.RegTest$;
import org.bitcoins.core.config.SigNet$;
import org.bitcoins.core.config.TestNet3$;
import org.bitcoins.core.wallet.fee.SatoshisPerVirtualByte;
import org.bitcoins.feeprovider.CachedHttpFeeRateProvider;
import org.bitcoins.feeprovider.MempoolSpaceProvider$;
import org.bitcoins.feeprovider.MempoolSpaceTarget;
import org.bitcoins.feeprovider.MempoolSpaceTarget$FastestFeeTarget$;
import org.bitcoins.feeprovider.MempoolSpaceTarget$HalfHourFeeTarget$;
import org.bitcoins.feeprovider.MempoolSpaceTarget$HourFeeTarget$;
import org.bitcoins.tor.Socks5ProxyParams;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001B\u0011#\u0001&B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\"Aq\t\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005P\u0001\tE\t\u0015!\u0003J\u0011!\u0001\u0006A!f\u0001\n\u0003\t\u0006\u0002C.\u0001\u0005#\u0005\u000b\u0011\u0002*\t\u0011q\u0003!Q1A\u0005DuC\u0001B\u001a\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\u0006O\u0002!\t\u0001\u001b\u0005\b_\u0002\u0011\r\u0011\"\u0011q\u0011\u0019Y\b\u0001)A\u0005c\")A\u0010\u0001C!{\"I\u00111\u0005\u0001\u0002\u0002\u0013\u0005\u0011Q\u0005\u0005\n\u0003c\u0001\u0011\u0013!C\u0001\u0003gA\u0011\"!\u0013\u0001#\u0003%\t!a\u0013\t\u0013\u0005=\u0003!%A\u0005\u0002\u0005E\u0003\"CA+\u0001\u0005\u0005I\u0011IA,\u0011%\t9\u0007AA\u0001\n\u0003\tI\u0007C\u0005\u0002r\u0001\t\t\u0011\"\u0001\u0002t!I\u0011q\u0010\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0011\u0005\n\u0003\u001f\u0003\u0011\u0011!C\u0001\u0003#C\u0011\"a'\u0001\u0003\u0003%\t%!(\t\u0013\u0005}\u0005!!A\u0005B\u0005\u0005\u0006\"CAR\u0001\u0005\u0005I\u0011IAS\u000f\u001d\tIK\tE\u0001\u0003W3a!\t\u0012\t\u0002\u00055\u0006BB4\u001b\t\u0003\tY\fC\u0004\u0002>j!\t%a0\t\u000f\u0005u&\u0004\"\u0001\u0002L\"I\u0011q\u001b\u000e\u0002\u0002\u0013\u0005\u0015\u0011\u001c\u0005\n\u0003KT\u0012\u0011!CA\u0003OD\u0011\"!>\u001b\u0003\u0003%I!a>\u0003)5+W\u000e]8pYN\u0003\u0018mY3Qe>4\u0018\u000eZ3s\u0015\t\u0019C%A\u0006gK\u0016\u0004(o\u001c<jI\u0016\u0014(BA\u0013'\u0003!\u0011\u0017\u000e^2pS:\u001c(\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001Q\u0003H\u0010\t\u0004W1rS\"\u0001\u0012\n\u00055\u0012#!G\"bG\",G\r\u0013;ua\u001a+WMU1uKB\u0013xN^5eKJ\u0004\"a\f\u001c\u000e\u0003AR!!\r\u001a\u0002\u0007\u0019,WM\u0003\u00024i\u00051q/\u00197mKRT!!\u000e\u0013\u0002\t\r|'/Z\u0005\u0003oA\u0012acU1u_ND\u0017n\u001d)feZK'\u000f^;bY\nKH/\u001a\t\u0003sqj\u0011A\u000f\u0006\u0002w\u0005)1oY1mC&\u0011QH\u000f\u0002\b!J|G-^2u!\tIt(\u0003\u0002Au\ta1+\u001a:jC2L'0\u00192mK\u00061A/\u0019:hKR,\u0012a\u0011\t\u0003W\u0011K!!\u0012\u0012\u0003%5+W\u000e]8pYN\u0003\u0018mY3UCJ<W\r^\u0001\bi\u0006\u0014x-\u001a;!\u0003\u001dqW\r^<pe.,\u0012!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019R\naaY8oM&<\u0017B\u0001(L\u00059\u0011\u0015\u000e^2pS:tU\r^<pe.\f\u0001B\\3uo>\u00148\u000eI\u0001\faJ|\u00070\u001f)be\u0006l7/F\u0001S!\rI4+V\u0005\u0003)j\u0012aa\u00149uS>t\u0007C\u0001,Z\u001b\u00059&B\u0001-%\u0003\r!xN]\u0005\u00035^\u0013\u0011cU8dWN,\u0004K]8ysB\u000b'/Y7t\u00031\u0001(o\u001c=z!\u0006\u0014\u0018-\\:!\u0003\u0019\u0019\u0018p\u001d;f[V\ta\f\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u0006)\u0011m\u0019;pe*\t1-\u0001\u0003bW.\f\u0017BA3a\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u000fML8\u000f^3nA\u00051A(\u001b8jiz\"B!\u001b7n]R\u0011!n\u001b\t\u0003W\u0001AQ\u0001X\u0005A\u0004yCQ!Q\u0005A\u0002\rCQaR\u0005A\u0002%CQ\u0001U\u0005A\u0002I\u000b1!\u001e:j+\u0005\t\bC\u0001:z\u001b\u0005\u0019(B\u0001;v\u0003\u0015iw\u000eZ3m\u0015\t1x/\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\tA(-\u0001\u0003iiR\u0004\u0018B\u0001>t\u0005\r)&/[\u0001\u0005kJL\u0007%A\u0005d_:4XM\u001d;feR\u0019a0!\u0003\u0011\t}\f)AL\u0007\u0003\u0003\u0003Q1!a\u0001;\u0003\u0011)H/\u001b7\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u0004)JL\bbBA\u0006\u0019\u0001\u0007\u0011QB\u0001\u0004gR\u0014\b\u0003BA\b\u0003;qA!!\u0005\u0002\u001aA\u0019\u00111\u0003\u001e\u000e\u0005\u0005U!bAA\fQ\u00051AH]8pizJ1!a\u0007;\u0003\u0019\u0001&/\u001a3fM&!\u0011qDA\u0011\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0004\u001e\u0002\t\r|\u0007/\u001f\u000b\t\u0003O\tY#!\f\u00020Q\u0019!.!\u000b\t\u000bqk\u00019\u00010\t\u000f\u0005k\u0001\u0013!a\u0001\u0007\"9q)\u0004I\u0001\u0002\u0004I\u0005b\u0002)\u000e!\u0003\u0005\rAU\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)DK\u0002D\u0003oY#!!\u000f\u0011\t\u0005m\u0012QI\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007R\u0014AC1o]>$\u0018\r^5p]&!\u0011qIA\u001f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiEK\u0002J\u0003o\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002T)\u001a!+a\u000e\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u0006\u0005\u0003\u0002\\\u0005\u0015TBAA/\u0015\u0011\ty&!\u0019\u0002\t1\fgn\u001a\u0006\u0003\u0003G\nAA[1wC&!\u0011qDA/\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY\u0007E\u0002:\u0003[J1!a\u001c;\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)(a\u001f\u0011\u0007e\n9(C\u0002\u0002zi\u00121!\u00118z\u0011%\tihEA\u0001\u0002\u0004\tY'A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0007\u0003b!!\"\u0002\f\u0006UTBAAD\u0015\r\tIIO\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAG\u0003\u000f\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111SAM!\rI\u0014QS\u0005\u0004\u0003/S$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003{*\u0012\u0011!a\u0001\u0003k\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003W\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00033\na!Z9vC2\u001cH\u0003BAJ\u0003OC\u0011\"! \u0019\u0003\u0003\u0005\r!!\u001e\u0002)5+W\u000e]8pYN\u0003\u0018mY3Qe>4\u0018\u000eZ3s!\tY#d\u0005\u0004\u001b\u0003_\u000b)L\u0010\t\u0004s\u0005E\u0016bAAZu\t1\u0011I\\=SK\u001a\u0004BaKA\\U&\u0019\u0011\u0011\u0018\u0012\u0003%\u0019+W\r\u0015:pm&$WM\u001d$bGR|'/\u001f\u000b\u0003\u0003W\u000bqB\u001a:p[\ncwnY6UCJ<W\r\u001e\u000b\u0007\u0003\u0003\f)-!3\u0015\u0007)\f\u0019\rC\u0003]9\u0001\u000fa\fC\u0004\u0002Hr\u0001\r!a\u001b\u0002\r\tdwnY6t\u0011\u0015\u0001F\u00041\u0001S)!\ti-!5\u0002T\u0006UGc\u00016\u0002P\")A,\ba\u0002=\"9\u0011qY\u000fA\u0002\u0005-\u0004\"B$\u001e\u0001\u0004I\u0005\"\u0002)\u001e\u0001\u0004\u0011\u0016!B1qa2LH\u0003CAn\u0003?\f\t/a9\u0015\u0007)\fi\u000eC\u0003]=\u0001\u000fa\fC\u0003B=\u0001\u00071\tC\u0003H=\u0001\u0007\u0011\nC\u0003Q=\u0001\u0007!+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005%\u0018\u0011\u001f\t\u0005sM\u000bY\u000f\u0005\u0004:\u0003[\u001c\u0015JU\u0005\u0004\u0003_T$A\u0002+va2,7\u0007\u0003\u0005\u0002t~\t\t\u00111\u0001k\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002zB!\u00111LA~\u0013\u0011\ti0!\u0018\u0003\r=\u0013'.Z2u\u0001")
public class MempoolSpaceProvider
extends CachedHttpFeeRateProvider<SatoshisPerVirtualByte>
implements Product,
Serializable {
    private final MempoolSpaceTarget target;
    private final BitcoinNetwork network;
    private final Option<Socks5ProxyParams> proxyParams;
    private final ActorSystem system;
    private final Uri uri;

    public static Option<Tuple3<MempoolSpaceTarget, BitcoinNetwork, Option<Socks5ProxyParams>>> unapply(MempoolSpaceProvider mempoolSpaceProvider) {
        return MempoolSpaceProvider$.MODULE$.unapply(mempoolSpaceProvider);
    }

    public static MempoolSpaceProvider apply(MempoolSpaceTarget mempoolSpaceTarget, BitcoinNetwork bitcoinNetwork, Option<Socks5ProxyParams> option, ActorSystem actorSystem) {
        return MempoolSpaceProvider$.MODULE$.apply(mempoolSpaceTarget, bitcoinNetwork, option, actorSystem);
    }

    public static MempoolSpaceProvider fromBlockTarget(int n, BitcoinNetwork bitcoinNetwork, Option<Socks5ProxyParams> option, ActorSystem actorSystem) {
        return MempoolSpaceProvider$.MODULE$.fromBlockTarget(n, bitcoinNetwork, option, actorSystem);
    }

    public static MempoolSpaceProvider fromBlockTarget(int n, Option<Socks5ProxyParams> option, ActorSystem actorSystem) {
        return MempoolSpaceProvider$.MODULE$.fromBlockTarget(n, (Option)option, actorSystem);
    }

    public MempoolSpaceTarget target() {
        return this.target;
    }

    public BitcoinNetwork network() {
        return this.network;
    }

    @Override
    public Option<Socks5ProxyParams> proxyParams() {
        return this.proxyParams;
    }

    @Override
    public ActorSystem system() {
        return this.system;
    }

    @Override
    public Uri uri() {
        return this.uri;
    }

    @Override
    public Try<SatoshisPerVirtualByte> converter(String str) {
        Success success;
        JsValue json = Json$.MODULE$.parse(str);
        JsResult jsResult = json.validate(JsonSerializers$.MODULE$.mempoolSpaceResultReads());
        if (jsResult instanceof JsSuccess) {
            Success success2;
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            MempoolSpaceResult response = (MempoolSpaceResult)jsSuccess.value();
            MempoolSpaceTarget mempoolSpaceTarget = this.target();
            if (MempoolSpaceTarget$FastestFeeTarget$.MODULE$.equals(mempoolSpaceTarget)) {
                success2 = new Success((Object)response.fastestFee());
            } else if (MempoolSpaceTarget$HalfHourFeeTarget$.MODULE$.equals(mempoolSpaceTarget)) {
                success2 = new Success((Object)response.halfHourFee());
            } else if (MempoolSpaceTarget$HourFeeTarget$.MODULE$.equals(mempoolSpaceTarget)) {
                success2 = new Success((Object)response.hourFee());
            } else {
                throw new MatchError((Object)mempoolSpaceTarget);
            }
            success = success2;
        } else if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            Seq error = jsError.errors();
            success = new Failure((Throwable)new RuntimeException(new StringBuilder(40).append("Unexpected error when parsing response: ").append(error).toString()));
        } else {
            throw new MatchError((Object)jsResult);
        }
        return success;
    }

    public MempoolSpaceProvider copy(MempoolSpaceTarget target, BitcoinNetwork network, Option<Socks5ProxyParams> proxyParams, ActorSystem system) {
        return new MempoolSpaceProvider(target, network, proxyParams, system);
    }

    public MempoolSpaceTarget copy$default$1() {
        return this.target();
    }

    public BitcoinNetwork copy$default$2() {
        return this.network();
    }

    public Option<Socks5ProxyParams> copy$default$3() {
        return this.proxyParams();
    }

    public String productPrefix() {
        return "MempoolSpaceProvider";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<Socks5ProxyParams> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.target();
                break;
            }
            case 1: {
                option = this.network();
                break;
            }
            case 2: {
                option = this.proxyParams();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return option;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MempoolSpaceProvider;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MempoolSpaceProvider)) return false;
        boolean bl = true;
        if (!bl) return false;
        MempoolSpaceProvider mempoolSpaceProvider = (MempoolSpaceProvider)x$1;
        MempoolSpaceTarget mempoolSpaceTarget = this.target();
        MempoolSpaceTarget mempoolSpaceTarget2 = mempoolSpaceProvider.target();
        if (mempoolSpaceTarget == null) {
            if (mempoolSpaceTarget2 != null) {
                return false;
            }
        } else if (!mempoolSpaceTarget.equals(mempoolSpaceTarget2)) return false;
        BitcoinNetwork bitcoinNetwork = this.network();
        BitcoinNetwork bitcoinNetwork2 = mempoolSpaceProvider.network();
        if (bitcoinNetwork == null) {
            if (bitcoinNetwork2 != null) {
                return false;
            }
        } else if (!bitcoinNetwork.equals(bitcoinNetwork2)) return false;
        Option<Socks5ProxyParams> option = this.proxyParams();
        Option<Socks5ProxyParams> option2 = mempoolSpaceProvider.proxyParams();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!mempoolSpaceProvider.canEqual(this)) return false;
        return true;
    }

    public MempoolSpaceProvider(MempoolSpaceTarget target, BitcoinNetwork network, Option<Socks5ProxyParams> proxyParams, ActorSystem system) {
        Uri uri;
        this.target = target;
        this.network = network;
        this.proxyParams = proxyParams;
        this.system = system;
        Product.$init$((Product)this);
        BitcoinNetwork bitcoinNetwork = network;
        if (MainNet$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/api/v1/fees/recommended");
        } else if (TestNet3$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/testnet/api/v1/fees/recommended");
        } else if (SigNet$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/signet/api/v1/fees/recommended");
        } else if (RegTest$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/testnet/api/v1/fees/recommended");
        } else {
            throw new MatchError((Object)bitcoinNetwork);
        }
        this.uri = uri;
    }
}

