/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.feeprovider;

import akka.actor.ActorSystem;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import java.io.Serializable;
import org.bitcoins.commons.jsonmodels.wallet.BitcoinerLiveEstimate;
import org.bitcoins.commons.jsonmodels.wallet.BitcoinerLiveResult;
import org.bitcoins.commons.serializers.JsonSerializers$;
import org.bitcoins.core.wallet.fee.SatoshisPerVirtualByte;
import org.bitcoins.feeprovider.BitcoinerLiveFeeRateProvider$;
import org.bitcoins.feeprovider.CachedHttpFeeRateProvider;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005ef\u0001B\u000f\u001f\u0001\u0016B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BC\u0002\u0013\r3\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003E\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u001d\u0019\u0006A1A\u0005\nQCa!\u0018\u0001!\u0002\u0013)\u0006b\u00020\u0001\u0005\u0004%\te\u0018\u0005\u0007U\u0002\u0001\u000b\u0011\u00021\t\u000b-\u0004A\u0011\t7\t\u0013\u0005=\u0001!!A\u0005\u0002\u0005E\u0001\"CA\r\u0001E\u0005I\u0011AA\u000e\u0011%\t\t\u0004AA\u0001\n\u0003\n\u0019\u0004\u0003\u0005\u0002D\u0001\t\t\u0011\"\u0001>\u0011%\t)\u0005AA\u0001\n\u0003\t9\u0005C\u0005\u0002T\u0001\t\t\u0011\"\u0011\u0002V!I\u0011q\f\u0001\u0002\u0002\u0013\u0005\u0011\u0011\r\u0005\n\u0003W\u0002\u0011\u0011!C!\u0003[B\u0011\"!\u001d\u0001\u0003\u0003%\t%a\u001d\t\u0013\u0005U\u0004!!A\u0005B\u0005]\u0004\"CA=\u0001\u0005\u0005I\u0011IA>\u000f%\tyHHA\u0001\u0012\u0003\t\tI\u0002\u0005\u001e=\u0005\u0005\t\u0012AAB\u0011\u0019iu\u0003\"\u0001\u0002\u0016\"I\u0011QO\f\u0002\u0002\u0013\u0015\u0013q\u000f\u0005\n\u0003/;\u0012\u0011!CA\u00033C\u0011\"!)\u0018\u0003\u0003%\t)a)\t\u0013\u0005=v#!A\u0005\n\u0005E&\u0001\b\"ji\u000e|\u0017N\\3s\u0019&4XMR3f%\u0006$X\r\u0015:pm&$WM\u001d\u0006\u0003?\u0001\n1BZ3faJ|g/\u001b3fe*\u0011\u0011EI\u0001\tE&$8m\\5og*\t1%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001M)\u0002\u0004CA\u0014)\u001b\u0005q\u0012BA\u0015\u001f\u0005e\u0019\u0015m\u00195fI\"#H\u000f\u001d$fKJ\u000bG/\u001a)s_ZLG-\u001a:\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011'\u000f\b\u0003e]r!a\r\u001c\u000e\u0003QR!!\u000e\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0013B\u0001\u001d-\u0003\u001d\u0001\u0018mY6bO\u0016L!AO\u001e\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005ab\u0013aB7j]V$Xm]\u000b\u0002}A\u00111fP\u0005\u0003\u00012\u00121!\u00138u\u0003!i\u0017N\\;uKN\u0004\u0013AB:zgR,W.F\u0001E!\t)%*D\u0001G\u0015\t9\u0005*A\u0003bGR|'OC\u0001J\u0003\u0011\t7n[1\n\u0005-3%aC!di>\u00148+_:uK6\fqa]=ti\u0016l\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u001fJ#\"\u0001U)\u0011\u0005\u001d\u0002\u0001\"\u0002\"\u0006\u0001\b!\u0005\"\u0002\u001f\u0006\u0001\u0004q\u0014!\u00072ji\u000e|\u0017N\\3s\u0019&4XMV1mS\u0012l\u0015N\\;uKN,\u0012!\u0016\t\u0004-nsT\"A,\u000b\u0005aK\u0016!C5n[V$\u0018M\u00197f\u0015\tQF&\u0001\u0006d_2dWm\u0019;j_:L!\u0001X,\u0003\rY+7\r^8s\u0003i\u0011\u0017\u000e^2pS:,'\u000fT5wKZ\u000bG.\u001b3NS:,H/Z:!\u0003\r)(/[\u000b\u0002AB\u0011\u0011\r[\u0007\u0002E*\u00111\rZ\u0001\u0006[>$W\r\u001c\u0006\u0003K\u001a\f\u0001b]2bY\u0006$7\u000f\u001c\u0006\u0003O\"\u000bA\u0001\u001b;ua&\u0011\u0011N\u0019\u0002\u0004+JL\u0017\u0001B;sS\u0002\n\u0011bY8om\u0016\u0014H/\u001a:\u0015\u00055l\bc\u00018rg6\tqN\u0003\u0002qY\u0005!Q\u000f^5m\u0013\t\u0011xNA\u0002Uef\u0004\"\u0001^>\u000e\u0003UT!A^<\u0002\u0007\u0019,WM\u0003\u0002ys\u00061q/\u00197mKRT!A\u001f\u0011\u0002\t\r|'/Z\u0005\u0003yV\u0014acU1u_ND\u0017n\u001d)feZK'\u000f^;bY\nKH/\u001a\u0005\u0006}*\u0001\ra`\u0001\u0004gR\u0014\b\u0003BA\u0001\u0003\u0013qA!a\u0001\u0002\u0006A\u00111\u0007L\u0005\u0004\u0003\u000fa\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\u00055!AB*ue&twMC\u0002\u0002\b1\nAaY8qsR!\u00111CA\f)\r\u0001\u0016Q\u0003\u0005\u0006\u0005.\u0001\u001d\u0001\u0012\u0005\by-\u0001\n\u00111\u0001?\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\b+\u0007y\nyb\u000b\u0002\u0002\"A!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012!C;oG\",7m[3e\u0015\r\tY\u0003L\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0018\u0003K\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0007\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0012\u0001\u00026bm\u0006LA!a\u0003\u0002:\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA%\u0003\u001f\u00022aKA&\u0013\r\ti\u0005\f\u0002\u0004\u0003:L\b\u0002CA)\u001f\u0005\u0005\t\u0019\u0001 \u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\u0006\u0005\u0004\u0002Z\u0005m\u0013\u0011J\u0007\u00023&\u0019\u0011QL-\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003G\nI\u0007E\u0002,\u0003KJ1!a\u001a-\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0015\u0012\u0003\u0003\u0005\r!!\u0013\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003k\ty\u0007\u0003\u0005\u0002RI\t\t\u00111\u0001?\u0003!A\u0017m\u001d5D_\u0012,G#\u0001 \u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u000e\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019'! \t\u0013\u0005ES#!AA\u0002\u0005%\u0013\u0001\b\"ji\u000e|\u0017N\\3s\u0019&4XMR3f%\u0006$X\r\u0015:pm&$WM\u001d\t\u0003O]\u0019RaFAC\u0003\u0017\u00032aKAD\u0013\r\tI\t\f\u0002\u0007\u0003:L(+\u001a4\u0011\t\u00055\u00151S\u0007\u0003\u0003\u001fSA!!%\u0002>\u0005\u0011\u0011n\\\u0005\u0004u\u0005=ECAAA\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\tY*a(\u0015\u0007A\u000bi\nC\u0003C5\u0001\u000fA\tC\u0003=5\u0001\u0007a(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u0015\u00161\u0016\t\u0005W\u0005\u001df(C\u0002\u0002*2\u0012aa\u00149uS>t\u0007\u0002CAW7\u0005\u0005\t\u0019\u0001)\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u00024B!\u0011qGA[\u0013\u0011\t9,!\u000f\u0003\r=\u0013'.Z2u\u0001")
public class BitcoinerLiveFeeRateProvider
extends CachedHttpFeeRateProvider
implements Product,
Serializable {
    private final int minutes;
    private final ActorSystem system;
    private final Vector<Object> bitcoinerLiveValidMinutes;
    private final Uri uri;

    public static Option<Object> unapply(BitcoinerLiveFeeRateProvider bitcoinerLiveFeeRateProvider) {
        return BitcoinerLiveFeeRateProvider$.MODULE$.unapply(bitcoinerLiveFeeRateProvider);
    }

    public static BitcoinerLiveFeeRateProvider apply(int n, ActorSystem actorSystem) {
        return BitcoinerLiveFeeRateProvider$.MODULE$.apply(n, actorSystem);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public int minutes() {
        return this.minutes;
    }

    @Override
    public ActorSystem system() {
        return this.system;
    }

    private Vector<Object> bitcoinerLiveValidMinutes() {
        return this.bitcoinerLiveValidMinutes;
    }

    @Override
    public Uri uri() {
        return this.uri;
    }

    public Try<SatoshisPerVirtualByte> converter(String str) {
        Success success;
        JsValue json = Json$.MODULE$.parse(str);
        JsResult jsResult = json.validate(JsonSerializers$.MODULE$.bitcoinerLiveResultReads());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            BitcoinerLiveResult response = (BitcoinerLiveResult)jsSuccess.value();
            success = new Success((Object)((BitcoinerLiveEstimate)response.estimates().apply((Object)BoxesRunTime.boxToInteger((int)this.minutes()))).sat_per_vbyte());
        } else if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            Seq error = jsError.errors();
            success = new Failure((Throwable)new RuntimeException(new StringBuilder(40).append("Unexpected error when parsing response: ").append(error).toString()));
        } else {
            throw new MatchError((Object)jsResult);
        }
        return success;
    }

    public BitcoinerLiveFeeRateProvider copy(int minutes, ActorSystem system) {
        return new BitcoinerLiveFeeRateProvider(minutes, system);
    }

    public int copy$default$1() {
        return this.minutes();
    }

    public String productPrefix() {
        return "BitcoinerLiveFeeRateProvider";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.minutes());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitcoinerLiveFeeRateProvider;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "minutes";
                break;
            }
            case 1: {
                string = "system";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.minutes());
        return Statics.finalizeHash((int)n, (int)1);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitcoinerLiveFeeRateProvider)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitcoinerLiveFeeRateProvider bitcoinerLiveFeeRateProvider = (BitcoinerLiveFeeRateProvider)x$1;
        if (this.minutes() != bitcoinerLiveFeeRateProvider.minutes()) return false;
        if (!bitcoinerLiveFeeRateProvider.canEqual(this)) return false;
        return true;
    }

    public BitcoinerLiveFeeRateProvider(int minutes, ActorSystem system) {
        this.minutes = minutes;
        this.system = system;
        Product.$init$((Product)this);
        this.bitcoinerLiveValidMinutes = (Vector)package$.MODULE$.Vector().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{30, 60, 120, 180, 360, 720, 1440}));
        Predef$.MODULE$.require(this.bitcoinerLiveValidMinutes().contains((Object)BoxesRunTime.boxToInteger((int)minutes)), (Function0 & Serializable)() -> new StringBuilder(40).append(this.minutes()).append(" is not a valid selection, must be from ").append(this.bitcoinerLiveValidMinutes()).toString());
        this.uri = Uri$.MODULE$.apply("https://bitcoiner.live/api/fees/estimates/latest");
    }
}

