/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.feeprovider;

import akka.actor.ActorSystem;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import java.io.Serializable;
import org.bitcoins.commons.jsonmodels.wallet.BitGoResult;
import org.bitcoins.commons.serializers.JsonSerializers$;
import org.bitcoins.core.package$;
import org.bitcoins.core.wallet.fee.SatoshisPerKiloByte;
import org.bitcoins.feeprovider.BitGoFeeRateProvider$;
import org.bitcoins.feeprovider.CachedHttpFeeRateProvider;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u00055g\u0001\u0002\u000f\u001e\u0001\u0012B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u000f\"Aa\n\u0001BC\u0002\u0013\rs\n\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003Q\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u001dy\u0006A1A\u0005B\u0001Daa\u001b\u0001!\u0002\u0013\t\u0007\"\u00027\u0001\t\u0003j\u0007\"\u0002@\u0001\t\u0013y\b\"CA\b\u0001\u0005\u0005I\u0011AA\t\u0011%\tI\u0002AI\u0001\n\u0003\tY\u0002C\u0005\u00022\u0001\t\t\u0011\"\u0011\u00024!I\u00111\t\u0001\u0002\u0002\u0013\u0005\u0011Q\t\u0005\n\u0003\u000f\u0002\u0011\u0011!C\u0001\u0003\u0013B\u0011\"!\u0016\u0001\u0003\u0003%\t%a\u0016\t\u0013\u0005\u0015\u0004!!A\u0005\u0002\u0005\u001d\u0004\"CA9\u0001\u0005\u0005I\u0011IA:\u0011%\t9\bAA\u0001\n\u0003\nI\bC\u0005\u0002|\u0001\t\t\u0011\"\u0011\u0002~!I\u0011q\u0010\u0001\u0002\u0002\u0013\u0005\u0013\u0011Q\u0004\b\u0003\u000bk\u0002\u0012AAD\r\u0019aR\u0004#\u0001\u0002\n\"1\u0011L\u0006C\u0001\u0003CCq!a)\u0017\t\u0003\n)\u000bC\u0005\u00020Z\t\t\u0011\"!\u00022\"I\u0011\u0011\u0018\f\u0002\u0002\u0013\u0005\u00151\u0018\u0005\n\u0003\u00074\u0012\u0011!C\u0005\u0003\u000b\u0014ACQ5u\u000f>4U-\u001a*bi\u0016\u0004&o\u001c<jI\u0016\u0014(B\u0001\u0010 \u0003-1W-\u001a9s_ZLG-\u001a:\u000b\u0005\u0001\n\u0013\u0001\u00032ji\u000e|\u0017N\\:\u000b\u0003\t\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u00134sA\u0019aeJ\u0015\u000e\u0003uI!\u0001K\u000f\u00033\r\u000b7\r[3e\u0011R$\bOR3f%\u0006$X\r\u0015:pm&$WM\u001d\t\u0003UEj\u0011a\u000b\u0006\u0003Y5\n1AZ3f\u0015\tqs&\u0001\u0004xC2dW\r\u001e\u0006\u0003a}\tAaY8sK&\u0011!g\u000b\u0002\u0014'\u0006$xn\u001d5jgB+'oS5m_\nKH/\u001a\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\b!J|G-^2u!\tQ$I\u0004\u0002<\u0001:\u0011AhP\u0007\u0002{)\u0011ahI\u0001\u0007yI|w\u000e\u001e \n\u0003YJ!!Q\u001b\u0002\u000fA\f7m[1hK&\u00111\t\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0003V\naB\u00197pG.$\u0016M]4fi>\u0003H/F\u0001H!\r!\u0004JS\u0005\u0003\u0013V\u0012aa\u00149uS>t\u0007C\u0001\u001bL\u0013\taUGA\u0002J]R\fqB\u00197pG.$\u0016M]4fi>\u0003H\u000fI\u0001\u0007gf\u001cH/Z7\u0016\u0003A\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003U\u000bA!Y6lC&\u0011qK\u0015\u0002\f\u0003\u000e$xN]*zgR,W.A\u0004tsN$X-\u001c\u0011\u0002\rqJg.\u001b;?)\tYf\f\u0006\u0002];B\u0011a\u0005\u0001\u0005\u0006\u001d\u0016\u0001\u001d\u0001\u0015\u0005\u0006\u000b\u0016\u0001\raR\u0001\u0004kJLW#A1\u0011\u0005\tLW\"A2\u000b\u0005\u0011,\u0017!B7pI\u0016d'B\u00014h\u0003!\u00198-\u00197bINd'B\u00015U\u0003\u0011AG\u000f\u001e9\n\u0005)\u001c'aA+sS\u0006!QO]5!\u0003%\u0019wN\u001c<feR,'\u000f\u0006\u0002oiB\u0019qN]\u0015\u000e\u0003AT!!]\u001b\u0002\tU$\u0018\u000e\\\u0005\u0003gB\u00141\u0001\u0016:z\u0011\u0015)\b\u00021\u0001w\u0003\r\u0019HO\u001d\t\u0003ont!\u0001_=\u0011\u0005q*\u0014B\u0001>6\u0003\u0019\u0001&/\u001a3fM&\u0011A0 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i,\u0014AD3yiJ\f7\r\u001e$fKJ\fG/\u001a\u000b\u0006S\u0005\u0005\u00111\u0002\u0005\b\u0003\u0007I\u0001\u0019AA\u0003\u0003%1W-\u001a*b]\u001e,7\u000fE\u0003x\u0003\u000fQ\u0015&C\u0002\u0002\nu\u00141!T1q\u0011\u0019\ti!\u0003a\u0001\u0015\u0006Y!\r\\8dWR\u000b'oZ3u\u0003\u0011\u0019w\u000e]=\u0015\t\u0005M\u0011q\u0003\u000b\u00049\u0006U\u0001\"\u0002(\u000b\u0001\b\u0001\u0006bB#\u000b!\u0003\u0005\raR\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiBK\u0002H\u0003?Y#!!\t\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003W)\u0014AC1o]>$\u0018\r^5p]&!\u0011qFA\u0013\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003\u0003j!!!\u000f\u000b\t\u0005m\u0012QH\u0001\u0005Y\u0006twM\u0003\u0002\u0002@\u0005!!.\u0019<b\u0013\ra\u0018\u0011H\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002\u0015\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA&\u0003#\u00022\u0001NA'\u0013\r\ty%\u000e\u0002\u0004\u0003:L\b\u0002CA*\u001d\u0005\u0005\t\u0019\u0001&\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u0006\u0005\u0004\u0002\\\u0005\u0005\u00141J\u0007\u0003\u0003;R1!a\u00186\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003G\niF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA5\u0003_\u00022\u0001NA6\u0013\r\ti'\u000e\u0002\b\u0005>|G.Z1o\u0011%\t\u0019\u0006EA\u0001\u0002\u0004\tY%\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u001b\u0003kB\u0001\"a\u0015\u0012\u0003\u0003\u0005\rAS\u0001\tQ\u0006\u001c\bnQ8eKR\t!*\u0001\u0005u_N#(/\u001b8h)\t\t)$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003S\n\u0019\tC\u0005\u0002TQ\t\t\u00111\u0001\u0002L\u0005!\")\u001b;H_\u001a+WMU1uKB\u0013xN^5eKJ\u0004\"A\n\f\u0014\u000fY\tY)!%\u0002\u0018B\u0019A'!$\n\u0007\u0005=UG\u0001\u0004B]f\u0014VM\u001a\t\u0005M\u0005ME,C\u0002\u0002\u0016v\u0011!CR3f!J|g/\u001b3fe\u001a\u000b7\r^8ssB!\u0011\u0011TAP\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006u\u0012AA5p\u0013\r\u0019\u00151\u0014\u000b\u0003\u0003\u000f\u000bqB\u001a:p[\ncwnY6UCJ<W\r\u001e\u000b\u0005\u0003O\u000bY\u000bF\u0002]\u0003SCQA\u0014\rA\u0004ACa!!,\u0019\u0001\u0004Q\u0015A\u00022m_\u000e\\7/A\u0003baBd\u0017\u0010\u0006\u0003\u00024\u0006]Fc\u0001/\u00026\")a*\u0007a\u0002!\")Q)\u0007a\u0001\u000f\u00069QO\\1qa2LH\u0003BA_\u0003\u007f\u00032\u0001\u000e%H\u0011!\t\tMGA\u0001\u0002\u0004a\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\u0019\t\u0005\u0003o\tI-\u0003\u0003\u0002L\u0006e\"AB(cU\u0016\u001cG\u000f")
public class BitGoFeeRateProvider
extends CachedHttpFeeRateProvider<SatoshisPerKiloByte>
implements Product,
Serializable {
    private final Option<Object> blockTargetOpt;
    private final ActorSystem system;
    private final Uri uri;

    public static Option<Option<Object>> unapply(BitGoFeeRateProvider x$0) {
        return BitGoFeeRateProvider$.MODULE$.unapply(x$0);
    }

    public static BitGoFeeRateProvider apply(Option<Object> blockTargetOpt, ActorSystem system) {
        return BitGoFeeRateProvider$.MODULE$.apply(blockTargetOpt, system);
    }

    public static BitGoFeeRateProvider fromBlockTarget(int blocks, ActorSystem system) {
        return BitGoFeeRateProvider$.MODULE$.fromBlockTarget(blocks, system);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Option<Object> blockTargetOpt() {
        return this.blockTargetOpt;
    }

    @Override
    public ActorSystem system() {
        return this.system;
    }

    @Override
    public Uri uri() {
        return this.uri;
    }

    @Override
    public Try<SatoshisPerKiloByte> converter(String str) {
        Success success;
        JsValue json = Json$.MODULE$.parse(str);
        JsResult jsResult = json.validate(JsonSerializers$.MODULE$.bitGoResultReads());
        if (jsResult instanceof JsSuccess) {
            Success success2;
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            BitGoResult response = (BitGoResult)jsSuccess.value();
            Option<Object> option = this.blockTargetOpt();
            if (None$.MODULE$.equals(option)) {
                success2 = new Success((Object)response.feePerKb());
            } else if (option instanceof Some) {
                Some some = (Some)option;
                int blockTarget = BoxesRunTime.unboxToInt((Object)some.value());
                SatoshisPerKiloByte feeRate = this.extractFeerate((Map<Object, SatoshisPerKiloByte>)response.feeByBlockTarget(), blockTarget);
                success2 = new Success((Object)feeRate);
            } else {
                throw new MatchError(option);
            }
            success = success2;
        } else if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            Seq error = jsError.errors();
            success = new Failure((Throwable)new RuntimeException(new StringBuilder(41).append("Unexpected error when parsing response ").append(str).append(": ").append(error).toString()));
        } else {
            throw new MatchError((Object)jsResult);
        }
        return success;
    }

    private SatoshisPerKiloByte extractFeerate(Map<Object, SatoshisPerKiloByte> feeRanges, int blockTarget) {
        Map belowLimit = (Map)feeRanges.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BitGoFeeRateProvider.$anonfun$extractFeerate$1(blockTarget, x$1)));
        return (SatoshisPerKiloByte)belowLimit.values().min(package$.MODULE$.satoshisPerKiloByteOrdering());
    }

    public BitGoFeeRateProvider copy(Option<Object> blockTargetOpt, ActorSystem system) {
        return new BitGoFeeRateProvider(blockTargetOpt, system);
    }

    public Option<Object> copy$default$1() {
        return this.blockTargetOpt();
    }

    public String productPrefix() {
        return "BitGoFeeRateProvider";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.blockTargetOpt();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitGoFeeRateProvider;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "blockTargetOpt";
                break;
            }
            case 1: {
                string = "system";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitGoFeeRateProvider)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitGoFeeRateProvider bitGoFeeRateProvider = (BitGoFeeRateProvider)x$1;
        Option<Object> option = this.blockTargetOpt();
        Option<Object> option2 = bitGoFeeRateProvider.blockTargetOpt();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!bitGoFeeRateProvider.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$extractFeerate$1(int blockTarget$1, Tuple2 x$1) {
        return x$1._1$mcI$sp() <= blockTarget$1;
    }

    public BitGoFeeRateProvider(Option<Object> blockTargetOpt, ActorSystem system) {
        this.blockTargetOpt = blockTargetOpt;
        this.system = system;
        Product.$init$((Product)this);
        this.uri = Uri$.MODULE$.apply("https://www.bitgo.com/api/v2/btc/tx/fee");
    }
}

